/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.api;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.StreamSupport;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.security.api.ContextStateCache;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ConnectionSecurityContext {
    private ConnectionSecurityContext() {
    }

    public static Collection<Principal> getConnectionPrincipals() {
        Connection con = RemotingContext.getConnection();
        if (con != null) {
            HashSet<Principal> principals = new HashSet<Principal>();
            SecurityIdentity localIdentity = con.getLocalIdentity();
            if (localIdentity != null) {
                principals.add((Principal)new RealmUser(localIdentity.getPrincipal().getName()));
                StreamSupport.stream(localIdentity.getRoles().spliterator(), true).forEach(role -> {
                    principals.add((Principal)new RealmGroup(role));
                    principals.add((Principal)new RealmRole(role));
                });
                return principals;
            }
            return Collections.emptySet();
        }
        return null;
    }

    public static ContextStateCache pushIdentity(Principal principal, Object credential) throws Exception {
        SecurityContext current = SecurityContextAssociation.getSecurityContext();
        SecurityContext nextContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)new Subject(), (String)"USER_DELEGATION");
        SecurityContextAssociation.setSecurityContext((SecurityContext)nextContext);
        Connection con = RemotingContext.getConnection();
        RemotingContext.clear();
        return new ContextStateCache(con, current);
    }

    public static void popIdentity(ContextStateCache stateCache) {
        RemotingContext.setConnection((Connection)stateCache.getConnection());
        SecurityContextAssociation.setSecurityContext((SecurityContext)stateCache.getSecurityContext());
    }
}

