/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.service.descriptor.JBossServiceAttributeConfig;
import org.jboss.as.service.descriptor.JBossServiceConfig;
import org.jboss.as.service.descriptor.JBossServiceConstructorConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyListConfig;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.service.descriptor.ParseResult;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class JBossServiceXmlDescriptorParser
implements XMLElementReader<ParseResult<JBossServiceXmlDescriptor>>,
XMLStreamConstants {
    public static final String NAMESPACE = "urn:jboss:service:7.0";
    private final PropertyReplacer propertyReplacer;

    public JBossServiceXmlDescriptorParser(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<JBossServiceXmlDescriptor> value) throws XMLStreamException {
        JBossServiceXmlDescriptor serviceXmlDescriptor = new JBossServiceXmlDescriptor();
        ArrayList<JBossServiceConfig> serviceConfigs = new ArrayList<JBossServiceConfig>();
        serviceXmlDescriptor.setServiceConfigs(serviceConfigs);
        value.setResult(serviceXmlDescriptor);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = reader.getAttributeName(i);
            Attribute attribute = Attribute.of(attributeName);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case MODE: {
                    serviceXmlDescriptor.setControllerMode(JBossServiceXmlDescriptor.ControllerMode.of(attributeValue));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case MBEAN: {
                            serviceConfigs.add(this.parseMBean(reader));
                            break block3;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
    }

    private JBossServiceConfig parseMBean(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceConfig serviceConfig = new JBossServiceConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CODE);
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    serviceConfig.setName(attributeValue);
                    continue block19;
                }
                case CODE: {
                    serviceConfig.setCode(attributeValue);
                    continue block19;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        ArrayList<JBossServiceDependencyConfig> dependencyConfigs = new ArrayList<JBossServiceDependencyConfig>();
        ArrayList<JBossServiceDependencyListConfig> dependencyListConfigs = new ArrayList<JBossServiceDependencyListConfig>();
        ArrayList<JBossServiceAttributeConfig> attributes = new ArrayList<JBossServiceAttributeConfig>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> annotations = new ArrayList<String>();
        while (reader.hasNext()) {
            block4 : switch (reader.nextTag()) {
                case 2: {
                    serviceConfig.setDependencyConfigs(dependencyConfigs.toArray(new JBossServiceDependencyConfig[dependencyConfigs.size()]));
                    serviceConfig.setDependencyConfigLists(dependencyListConfigs.toArray(new JBossServiceDependencyListConfig[dependencyListConfigs.size()]));
                    serviceConfig.setAliases(aliases.toArray(new String[aliases.size()]));
                    serviceConfig.setAnnotations(annotations.toArray(new String[annotations.size()]));
                    serviceConfig.setAttributeConfigs(attributes.toArray(new JBossServiceAttributeConfig[attributes.size()]));
                    return serviceConfig;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case CONSTRUCTOR: {
                            serviceConfig.setConstructorConfig(this.parseConstructor(reader));
                            break block4;
                        }
                        case DEPENDS: {
                            dependencyConfigs.add(this.parseDepends(reader));
                            break block4;
                        }
                        case DEPENDS_LIST: {
                            dependencyListConfigs.add(this.parseDependsList(reader));
                            break block4;
                        }
                        case ALIAS: {
                            aliases.add(this.parseTextElement(reader));
                            break block4;
                        }
                        case ANNOTATION: {
                            annotations.add(this.parseTextElement(reader));
                            break block4;
                        }
                        case ATTRIBUTE: {
                            attributes.add(this.parseAttribute(reader));
                            break block4;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceConstructorConfig parseConstructor(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceConstructorConfig constructorConfig = new JBossServiceConstructorConfig();
        ArrayList<JBossServiceConstructorConfig.Argument> arguments = new ArrayList<JBossServiceConstructorConfig.Argument>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    constructorConfig.setArguments(arguments.toArray(new JBossServiceConstructorConfig.Argument[arguments.size()]));
                    return constructorConfig;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case ARG: {
                            arguments.add(this.parseArgument(reader));
                            break block0;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceConstructorConfig.Argument parseArgument(XMLExtendedStreamReader reader) throws XMLStreamException {
        String type = null;
        String value = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.TYPE, Attribute.VALUE);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case TYPE: {
                    type = attributeValue;
                    continue block4;
                }
                case VALUE: {
                    value = attributeValue;
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        reader.discardRemainder();
        return new JBossServiceConstructorConfig.Argument(type, value);
    }

    private JBossServiceAttributeConfig parseAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig attributeConfig = new JBossServiceAttributeConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    attributeConfig.setName(attributeValue);
                    continue block17;
                }
                case TRIM: {
                    attributeConfig.setTrim(Boolean.parseBoolean(attributeValue));
                    continue block17;
                }
                case REPLACE: {
                    attributeConfig.setReplace(Boolean.parseBoolean(attributeValue));
                    continue block17;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        StringBuilder valueBuilder = new StringBuilder();
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    attributeConfig.setValue(this.propertyReplacer.replaceProperties(valueBuilder.toString().trim()));
                    return attributeConfig;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case INJECT: {
                            attributeConfig.setInject(this.parseInject(reader));
                            break block5;
                        }
                        case VALUE_FACTORY: {
                            attributeConfig.setValueFactory(this.parseValueFactory(reader));
                            break block5;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
                case 4: {
                    valueBuilder.append(reader.getText());
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceAttributeConfig.Inject parseInject(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.Inject injectConfig = new JBossServiceAttributeConfig.Inject();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    injectConfig.setBeanName(attributeValue);
                    continue block4;
                }
                case PROPERTY: {
                    injectConfig.setPropertyName(attributeValue);
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        reader.discardRemainder();
        return injectConfig;
    }

    private JBossServiceAttributeConfig.ValueFactory parseValueFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.ValueFactory valueFactory = new JBossServiceAttributeConfig.ValueFactory();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN, Attribute.METHOD);
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    valueFactory.setBeanName(attributeValue);
                    continue block14;
                }
                case METHOD: {
                    valueFactory.setMethodName(attributeValue);
                    continue block14;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        ArrayList<JBossServiceAttributeConfig.ValueFactoryParameter> parameters = new ArrayList<JBossServiceAttributeConfig.ValueFactoryParameter>();
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    valueFactory.setParameters(parameters.toArray(new JBossServiceAttributeConfig.ValueFactoryParameter[parameters.size()]));
                    return valueFactory;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case PARAMETER: {
                            parameters.add(this.parseValueFactoryParameter(reader));
                            break block4;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceAttributeConfig.ValueFactoryParameter parseValueFactoryParameter(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceAttributeConfig.ValueFactoryParameter parameterConfig = new JBossServiceAttributeConfig.ValueFactoryParameter();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    parameterConfig.setType(attributeValue);
                    continue block7;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossServiceXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return parameterConfig;
                }
                case 4: {
                    parameterConfig.setValue(reader.getText());
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private JBossServiceDependencyConfig parseDepends(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceDependencyConfig dependencyConfig = new JBossServiceDependencyConfig();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case OPTIONAL_ATTRIBUTE_NAME: {
                    dependencyConfig.setOptionalAttributeName(attributeValue);
                    continue block4;
                }
                case PROXY_TYPE: {
                    dependencyConfig.setProxyType(attributeValue);
                    continue block4;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        this.parseDependency(reader, dependencyConfig);
        return dependencyConfig;
    }

    private JBossServiceDependencyListConfig parseDependsList(XMLExtendedStreamReader reader) throws XMLStreamException {
        JBossServiceDependencyListConfig dependencyListConfig = new JBossServiceDependencyListConfig();
        ArrayList<JBossServiceDependencyConfig> dependencyConfigs = new ArrayList<JBossServiceDependencyConfig>();
        String optionalAttributeName = null;
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case OPTIONAL_ATTRIBUTE_NAME: {
                    optionalAttributeName = attributeValue;
                    continue block13;
                }
                default: {
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.next()) {
                case 2: {
                    dependencyListConfig.setOptionalAttributeName(optionalAttributeName);
                    dependencyListConfig.setDependencyConfigs(dependencyConfigs.toArray(new JBossServiceDependencyConfig[dependencyConfigs.size()]));
                    return dependencyListConfig;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case DEPENDS_LIST_ELEMENT: {
                            JBossServiceDependencyConfig dependencyConfig = new JBossServiceDependencyConfig();
                            this.parseDependency(reader, dependencyConfig);
                            dependencyConfigs.add(dependencyConfig);
                            break block3;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private void parseDependency(XMLExtendedStreamReader reader, JBossServiceDependencyConfig dependencyConfig) throws XMLStreamException {
        StringBuilder nameBuilder = new StringBuilder();
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    dependencyConfig.setDependencyName(nameBuilder.toString().trim());
                    return;
                }
                case 1: {
                    switch (Namespace.of(reader.getNamespaceURI())) {
                        case NONE: 
                        case SERVICE_7_0: {
                            break;
                        }
                        default: {
                            throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    switch (Element.of(reader.getLocalName())) {
                        case MBEAN: {
                            dependencyConfig.setServiceConfig(this.parseMBean(reader));
                            break block0;
                        }
                    }
                    throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
                case 4: {
                    nameBuilder.append(reader.getText());
                }
            }
        }
    }

    private String parseTextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        StringBuilder valueBuilder = new StringBuilder();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return valueBuilder.toString().trim();
                }
                case 4: {
                    valueBuilder.append(reader.getText());
                }
            }
        }
        throw JBossServiceXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        return new XMLStreamException(SarLogger.ROOT_LOGGER.unexpectedContent(switch (reader.getEventType()) {
            case 10 -> "attribute";
            case 12 -> "cdata";
            case 4 -> "characters";
            case 5 -> "comment";
            case 11 -> "dtd";
            case 8 -> "document end";
            case 2 -> "element end";
            case 15 -> "entity decl";
            case 9 -> "entity ref";
            case 13 -> "namespace";
            case 14 -> "notation decl";
            case 3 -> "processing instruction";
            case 6 -> "whitespace";
            case 7 -> "document start";
            case 1 -> "element start";
            default -> "unknown";
        }, reader.getName(), reader.getText()), reader.getLocation());
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder(SarLogger.ROOT_LOGGER.missingRequiredAttributes());
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static enum Attribute {
        MODE(new QName("mode")),
        NAME(new QName("name")),
        CODE(new QName("code")),
        TYPE(new QName("type")),
        VALUE(new QName("value")),
        TRIM(new QName("trim")),
        REPLACE(new QName("replace")),
        BEAN(new QName("bean")),
        PROPERTY(new QName("property")),
        CLASS(new QName("class")),
        METHOD(new QName("method")),
        OPTIONAL_ATTRIBUTE_NAME(new QName("optional-attribute-name")),
        PROXY_TYPE(new QName("proxy-type")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Attribute> QNAME_MAP;

        private Attribute(QName qName) {
            this.qName = qName;
        }

        static Attribute of(QName qName) {
            Attribute attribute = QNAME_MAP.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            QNAME_MAP = new HashMap<QName, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                QNAME_MAP.put(attribute.qName, attribute);
            }
        }
    }

    private static enum Namespace {
        UNKNOWN(null),
        NONE(""),
        SERVICE_7_0("urn:jboss:service:7.0");

        private final String namespace;
        private static final Map<String, Namespace> NS_MAP;

        private Namespace(String namespace) {
            this.namespace = namespace;
        }

        public static Namespace of(String uri) {
            if (uri == null) {
                return NONE;
            }
            Namespace namespace = NS_MAP.get(uri);
            return namespace == null ? UNKNOWN : namespace;
        }

        static {
            NS_MAP = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                NS_MAP.put(namespace.namespace, namespace);
            }
        }
    }

    private static enum Element {
        UNKNOWN(null),
        MBEAN("mbean"),
        CONSTRUCTOR("constructor"),
        ARG("arg"),
        ATTRIBUTE("attribute"),
        INJECT("inject"),
        VALUE_FACTORY("value-factory"),
        PARAMETER("parameter"),
        DEPENDS("depends"),
        DEPENDS_LIST("depends-list"),
        DEPENDS_LIST_ELEMENT("depends-list-element"),
        ALIAS("alias"),
        ANNOTATION("annotation");

        private final String localName;
        private static final Map<String, Element> NAME_MAP;

        private Element(String localName) {
            this.localName = localName;
        }

        static Element of(String localName) {
            Element element = NAME_MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            NAME_MAP = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                NAME_MAP.put(element.localName, element);
            }
        }
    }
}

