/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.xnio.OptionMap;

public class HttpConnectorAdd
extends AbstractAddStepHandler {
    static final HttpConnectorAdd INSTANCE = new HttpConnectorAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        HttpConnectorResource.CONNECTOR_REF.validateAndSet(operation, model);
        HttpConnectorResource.AUTHENTICATION_PROVIDER.validateAndSet(operation, model);
        HttpConnectorResource.SECURITY_REALM.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String connectorName = address.getLastElement().getValue();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.launchServices(context, connectorName, fullModel, verificationHandler, newControllers);
    }

    void launchServices(OperationContext context, String connectorName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        OptionMap optionMap = ConnectorUtils.getFullOptions(context, model);
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.controller.temp.dir"});
        String realmName = model.hasDefined("security-realm") ? model.require("security-realm").asString() : null;
        RemotingServices.installSecurityServices(context.getServiceTarget(), connectorName, realmName, null, tmpDirPath, verificationHandler, newControllers);
        ServiceTarget target = context.getServiceTarget();
        String connectorRef = HttpConnectorResource.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        RemotingHttpUpgradeService.installServices(target, connectorName, connectorRef, RemotingServices.SUBSYSTEM_ENDPOINT, optionMap, verificationHandler, newControllers);
    }
}

