/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    AUTHENTICATION_PROVIDER("authentication-provider"),
    CONNECTOR("connector"),
    FORWARD_SECRECY("forward-secrecy"),
    HTTP_CONNECTOR("http-connector"),
    INCLUDE_MECHANISMS("include-mechanisms"),
    LOCAL_OUTBOUND_CONNECTION("local-outbound-connection"),
    NO_ACTIVE("no-active"),
    NO_ANONYMOUS("no-anonymous"),
    NO_DICTIONARY("no-dictionary"),
    NO_PLAIN_TEXT("no-plain-text"),
    OPTION("option"),
    OUTBOUND_CONNECTION("outbound-connection"),
    OUTBOUND_CONNECTIONS("outbound-connections"),
    PASS_CREDENTIALS("pass-credentials"),
    POLICY("policy"),
    PROPERTIES("properties"),
    PROPERTY("property"),
    REMOTE_OUTBOUND_CONNECTION("remote-outbound-connection"),
    QOP("qop"),
    REUSE_SESSION("reuse-session"),
    SASL("sasl"),
    SERVER_AUTH("server-auth"),
    STRENGTH("strength"),
    SUBSYSTEM("subsystem"),
    WORKER_THREAD_POOL("worker-thread-pool");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

