/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFileImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallbackAbstract;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashSet;

public abstract class AbstractJournalUpdateTask
implements JournalReaderCallback {
    public static final String FILE_COMPACT_CONTROL = "journal-rename-control.ctr";
    protected final JournalImpl journal;
    protected final SequentialFileFactory fileFactory;
    protected JournalFile currentFile;
    protected SequentialFile sequentialFile;
    protected final JournalFilesRepository filesRepository;
    protected long nextOrderingID;
    private ActiveMQBuffer writingChannel;
    private ByteBuffer bufferWrite;
    private final ConcurrentLongHashSet recordsSnapshot;
    protected final List<JournalFile> newDataFiles = new ArrayList<JournalFile>();

    protected AbstractJournalUpdateTask(SequentialFileFactory fileFactory, JournalImpl journal, JournalFilesRepository filesRepository, ConcurrentLongHashSet recordsSnapshot, long nextOrderingID) {
        this.journal = journal;
        this.filesRepository = filesRepository;
        this.fileFactory = fileFactory;
        this.nextOrderingID = nextOrderingID;
        this.recordsSnapshot = recordsSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequentialFile writeControlFile(SequentialFileFactory fileFactory, List<JournalFile> files, List<JournalFile> newFiles, List<Pair<String, String>> renames) throws Exception {
        SequentialFile controlFile = fileFactory.createSequentialFile(FILE_COMPACT_CONTROL);
        try {
            controlFile.open(1, false);
            JournalImpl.initFileHeader(fileFactory, controlFile, 0, 0L);
            ActiveMQBuffer filesToRename = ActiveMQBuffers.dynamicBuffer((int)1);
            if (files == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(files.size());
                for (JournalFile journalFile : files) {
                    filesToRename.writeUTF(journalFile.getFile().getFileName());
                }
            }
            if (newFiles == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(newFiles.size());
                for (JournalFile journalFile : newFiles) {
                    filesToRename.writeUTF(journalFile.getFile().getFileName());
                }
            }
            if (renames == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(renames.size());
                for (Pair pair : renames) {
                    filesToRename.writeUTF((String)pair.getA());
                    filesToRename.writeUTF((String)pair.getB());
                }
            }
            JournalAddRecord controlRecord = new JournalAddRecord(true, 1L, 0, EncoderPersister.getInstance(), new ByteArrayEncoding(filesToRename.toByteBuffer().array()));
            ActiveMQBuffer activeMQBuffer = ActiveMQBuffers.dynamicBuffer((int)filesToRename.writerIndex());
            controlRecord.setFileID(0);
            controlRecord.encode(activeMQBuffer);
            ByteBuffer writeBuffer = fileFactory.newBuffer(activeMQBuffer.writerIndex());
            writeBuffer.put(activeMQBuffer.toByteBuffer().array(), 0, activeMQBuffer.writerIndex());
            writeBuffer.rewind();
            controlFile.writeDirect(writeBuffer, true);
            SequentialFile sequentialFile = controlFile;
            return sequentialFile;
        }
        finally {
            controlFile.close(false, false);
        }
    }

    static SequentialFile readControlFile(SequentialFileFactory fileFactory, List<String> dataFiles, List<String> newFiles, List<Pair<String, String>> renameFile, AtomicReference<ByteBuffer> wholeFileBufferRef) throws Exception {
        SequentialFile controlFile = fileFactory.createSequentialFile(FILE_COMPACT_CONTROL);
        if (controlFile.exists()) {
            JournalFileImpl file = new JournalFileImpl(controlFile, 0L, 2);
            final ArrayList records = new ArrayList();
            JournalImpl.readJournalFile(fileFactory, file, new JournalReaderCallbackAbstract(){

                @Override
                public void onReadAddRecord(RecordInfo info) throws Exception {
                    records.add(info);
                }
            }, wholeFileBufferRef);
            if (records.size() == 0) {
                controlFile.delete();
                return null;
            }
            ActiveMQBuffer input = ActiveMQBuffers.wrappedBuffer((byte[])((RecordInfo)records.get((int)0)).data);
            int numberDataFiles = input.readInt();
            for (int i = 0; i < numberDataFiles; ++i) {
                dataFiles.add(input.readUTF());
            }
            int numberNewFiles = input.readInt();
            for (int i = 0; i < numberNewFiles; ++i) {
                newFiles.add(input.readUTF());
            }
            int numberRenames = input.readInt();
            for (int i = 0; i < numberRenames; ++i) {
                String from = input.readUTF();
                String to = input.readUTF();
                renameFile.add((Pair<String, String>)new Pair((Object)from, (Object)to));
            }
            return controlFile;
        }
        return null;
    }

    public static SequentialFile readControlFile(SequentialFileFactory fileFactory, List<String> dataFiles, List<String> newFiles, List<Pair<String, String>> renameFile) throws Exception {
        return AbstractJournalUpdateTask.readControlFile(fileFactory, dataFiles, newFiles, renameFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean releaseWritingBuffer) throws Exception {
        block8: {
            if (this.writingChannel != null) {
                try {
                    if (!this.sequentialFile.isOpen()) break block8;
                    try {
                        this.sequentialFile.position(0L);
                        this.writingChannel.writerIndex(this.writingChannel.capacity());
                        ByteBuffer byteBuffer = this.bufferWrite;
                        int readerIndex = this.writingChannel.readerIndex();
                        byteBuffer.clear().position(readerIndex).limit(readerIndex + this.writingChannel.readableBytes());
                        this.sequentialFile.blockingWriteDirect(byteBuffer, true, false);
                    }
                    finally {
                        this.sequentialFile.close(false, false);
                        this.newDataFiles.add(this.currentFile);
                    }
                }
                finally {
                    if (releaseWritingBuffer) {
                        this.fileFactory.releaseDirectBuffer(this.bufferWrite);
                        this.writingChannel = null;
                        this.bufferWrite = null;
                    }
                }
            }
        }
    }

    public void flush() throws Exception {
        this.flush(true);
    }

    public boolean containsRecord(long id) {
        return this.recordsSnapshot.contains(id);
    }

    protected void openFile() throws Exception {
        this.flush(false);
        this.currentFile = this.filesRepository.openFileCMP();
        this.sequentialFile = this.currentFile.getFile();
        this.sequentialFile.open(1, false);
        this.currentFile = new JournalFileImpl(this.sequentialFile, this.nextOrderingID++, 2);
        int fileSize = this.journal.getFileSize();
        if (this.bufferWrite != null && this.bufferWrite.capacity() < fileSize) {
            this.fileFactory.releaseDirectBuffer(this.bufferWrite);
            this.bufferWrite = null;
            this.writingChannel = null;
        }
        if (this.bufferWrite == null) {
            ByteBuffer bufferWrite;
            this.bufferWrite = bufferWrite = this.fileFactory.allocateDirectBuffer(fileSize);
            this.writingChannel = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bufferWrite);
        } else {
            this.writingChannel.clear();
            this.bufferWrite.clear();
        }
        JournalImpl.writeHeader(this.writingChannel, this.journal.getUserVersion(), this.currentFile.getFileID());
    }

    protected void addToRecordsSnaptshot(long id) {
        this.recordsSnapshot.add(id);
    }

    protected ActiveMQBuffer getWritingChannel() {
        return this.writingChannel;
    }

    protected void writeEncoder(JournalInternalRecord record) throws Exception {
        record.setFileID(this.currentFile.getRecordID());
        record.encode(this.getWritingChannel());
    }

    protected void writeEncoder(JournalInternalRecord record, int txcounter) throws Exception {
        record.setNumberOfRecords(txcounter);
        this.writeEncoder(record);
    }
}

