/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Singleton
public class StrategyCache {
    private final Map<InterceptionPoint, FaultToleranceStrategy<?>> strategies = new ConcurrentHashMap();
    private final Map<InterceptionPoint, MetricsRecorder> metricsRecorders = new ConcurrentHashMap<InterceptionPoint, MetricsRecorder>();

    public <V> FaultToleranceStrategy<V> getStrategy(InterceptionPoint point, Supplier<FaultToleranceStrategy<V>> producer) {
        return this.strategies.computeIfAbsent(point, ignored -> (FaultToleranceStrategy)producer.get());
    }

    public MetricsRecorder getMetrics(InterceptionPoint point, Supplier<MetricsRecorder> producer) {
        return this.metricsRecorders.computeIfAbsent(point, ignored -> (MetricsRecorder)producer.get());
    }
}

