/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.ExistingCircuitBreakerNames;
import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class CircuitBreakerMaintenanceImpl
implements CircuitBreakerMaintenance {
    private final ConcurrentMap<String, CircuitBreaker<?>> registry = new ConcurrentHashMap();
    private final ExistingCircuitBreakerNames existingCircuitBreakerNames;

    @Inject
    public CircuitBreakerMaintenanceImpl(ExistingCircuitBreakerNames existingCircuitBreakerNames) {
        this.existingCircuitBreakerNames = existingCircuitBreakerNames;
    }

    void register(String circuitBreakerName, CircuitBreaker<?> circuitBreaker) {
        this.registry.putIfAbsent(circuitBreakerName, circuitBreaker);
    }

    public CircuitBreakerState currentState(String name) {
        if (!this.existingCircuitBreakerNames.contains(name)) {
            throw new IllegalArgumentException("Circuit breaker '" + name + "' doesn't exist");
        }
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.registry.get(name);
        if (circuitBreaker == null) {
            return CircuitBreakerState.CLOSED;
        }
        int currentState = circuitBreaker.currentState();
        switch (currentState) {
            case 0: {
                return CircuitBreakerState.CLOSED;
            }
            case 1: {
                return CircuitBreakerState.OPEN;
            }
            case 2: {
                return CircuitBreakerState.HALF_OPEN;
            }
        }
        throw new IllegalStateException("Unknown circuit breaker state " + currentState);
    }

    public void reset(String name) {
        if (!this.existingCircuitBreakerNames.contains(name)) {
            throw new IllegalArgumentException("Circuit breaker '" + name + "' doesn't exist");
        }
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.registry.get(name);
        if (circuitBreaker != null) {
            circuitBreaker.reset();
        }
    }

    public void resetAll() {
        this.registry.values().forEach(CircuitBreaker::reset);
    }
}

