/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import jakarta.faces.bean.ManagedBean;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.view.facelets.FaceletsResourceResolver;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class JSFAnnotationProcessor
implements DeploymentUnitProcessor {
    public static final String FACES_ANNOTATIONS_SC_ATTR = "org.jboss.as.jsf.FACES_ANNOTATIONS";
    private static final String MANAGED_ANNOTATION_PARAMETER = "managed";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            return;
        }
        HashMap instances = new HashMap();
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        for (FacesAnnotation annotation : FacesAnnotation.values()) {
            List annotationInstances = compositeIndex.getAnnotations(annotation.indexName);
            if (annotationInstances == null || annotationInstances.isEmpty()) continue;
            HashSet discoveredClasses = new HashSet();
            instances.put(annotation.annotationClass, discoveredClasses);
            for (AnnotationInstance annotationInstance : annotationInstances) {
                AnnotationValue value;
                AnnotationTarget target = annotationInstance.target();
                if (target instanceof ClassInfo) {
                    Class<?> annotatedClass;
                    DotName className = ((ClassInfo)ClassInfo.class.cast(target)).name();
                    try {
                        annotatedClass = classLoader.loadClass(className.toString());
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException(JSFLogger.ROOT_LOGGER.classLoadingFailed(className));
                    }
                    discoveredClasses.add(annotatedClass);
                    continue;
                }
                if ((annotation == FacesAnnotation.FACES_VALIDATOR || annotation == FacesAnnotation.FACES_CONVERTER || annotation == FacesAnnotation.FACES_BEHAVIOR) && (value = annotationInstance.value(MANAGED_ANNOTATION_PARAMETER)) != null && value.asBoolean()) continue;
                throw new DeploymentUnitProcessingException(JSFLogger.ROOT_LOGGER.invalidAnnotationLocation((Object)annotation, target));
            }
        }
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute(FACES_ANNOTATIONS_SC_ATTR, instances));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static enum FacesAnnotation {
        FACES_COMPONENT(FacesComponent.class),
        FACES_CONVERTER(FacesConverter.class),
        FACES_VALIDATOR(FacesValidator.class),
        FACES_RENDERER(FacesRenderer.class),
        MANAGED_BEAN(ManagedBean.class),
        NAMED_EVENT(NamedEvent.class),
        FACES_BEHAVIOR(FacesBehavior.class),
        FACES_BEHAVIOR_RENDERER(FacesBehaviorRenderer.class),
        FACELETS_RESOURCE_RESOLVER(FaceletsResourceResolver.class);

        private final Class<? extends Annotation> annotationClass;
        private final DotName indexName;

        private FacesAnnotation(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
            this.indexName = DotName.createSimple((String)annotationClass.getName());
        }
    }
}

