/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.SecurityRoleRef;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.security.jacc.PolicyContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.core.security.SimplePrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.SecurityActions;

public class JbossAuthorizationManager
implements AuthorizationManager {
    private final AuthorizationManager delegate;

    public JbossAuthorizationManager(AuthorizationManager delegate) {
        this.delegate = delegate;
    }

    public boolean isUserInRole(String role, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        boolean authzDecision = true;
        boolean baseDecision = this.delegate.isUserInRole(role, account, servletInfo, request, deployment);
        if (baseDecision) {
            String servletName = servletInfo.getName();
            String roleName = role;
            List roleRefs = servletInfo.getSecurityRoleRefs();
            if (roleRefs != null) {
                for (SecurityRoleRef ref : roleRefs) {
                    if (!ref.getLinkedRole().equals(role)) continue;
                    roleName = ref.getRole();
                    break;
                }
            }
            SecurityContext sc = SecurityActions.getSecurityContext();
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.noAuthorizationHelper(e);
                return false;
            }
            Subject callerSubject = sc.getUtil().getSubject();
            authzDecision = SecurityActions.hasRole(helper, roleName, account.getPrincipal(), servletName, this.getPrincipalRoles(account), PolicyContext.getContextID(), callerSubject, new ArrayList<String>(account.getRoles()));
        }
        boolean finalDecision = baseDecision && authzDecision;
        UndertowLogger.ROOT_LOGGER.tracef("hasRole:RealmBase says: %s ::Authz framework says: %s :final= %s", baseDecision, authzDecision, finalDecision);
        return finalDecision;
    }

    private Set<Principal> getPrincipalRoles(Account account) {
        HashSet<Principal> roles = new HashSet<Principal>();
        for (String role : account.getRoles()) {
            roles.add((Principal)new SimplePrincipal(role));
        }
        return roles;
    }

    public boolean canAccessResource(List<SingleConstraintMatch> mappedConstraints, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        ServletRequestContext src = ServletRequestContext.current();
        boolean baseDecision = this.delegate.canAccessResource(mappedConstraints, account, servletInfo, request, deployment);
        boolean authzDecision = false;
        if (baseDecision) {
            SecurityContext sc = SecurityActions.getSecurityContext();
            Subject caller = sc.getUtil().getSubject();
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("resourcePermissionCheck", Boolean.TRUE);
            contextMap.put("securityConstraints", mappedConstraints);
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.noAuthorizationHelper(e);
                return false;
            }
            ArrayList roles = new ArrayList();
            if (account != null) {
                roles.addAll(account.getRoles());
            }
            authzDecision = helper.checkResourcePermission(contextMap, (ServletRequest)request, src.getServletResponse(), caller, PolicyContext.getContextID(), this.requestURI(src.getExchange()), roles);
        }
        boolean finalDecision = baseDecision && authzDecision && this.hasUserDataPermission(request, (HttpServletResponse)src.getOriginalResponse(), account, mappedConstraints);
        UndertowLogger.ROOT_LOGGER.tracef("hasResourcePermission:RealmBase says: %s ::Authz framework says: %s :final= %s", baseDecision, authzDecision, finalDecision);
        return finalDecision;
    }

    public boolean hasUserDataPermission(HttpServletRequest request, HttpServletResponse response, Account account, List<SingleConstraintMatch> constraints) {
        boolean ok;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityConstraints", constraints);
        map.put("userDataPermissionCheck", Boolean.TRUE);
        SecurityContext sc = SecurityActions.getSecurityContext();
        AbstractWebAuthorizationHelper helper = null;
        try {
            helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
        }
        catch (Exception e) {
            UndertowLogger.ROOT_LOGGER.noAuthorizationHelper(e);
            return false;
        }
        Subject callerSubject = sc.getUtil().getSubject();
        if (callerSubject == null) {
            callerSubject = new Subject();
        }
        ArrayList roles = new ArrayList();
        if (account != null) {
            roles.addAll(account.getRoles());
        }
        if (!(ok = helper.hasUserDataPermission(map, (ServletRequest)request, (ServletResponse)response, PolicyContext.getContextID(), callerSubject, roles)) && response.getStatus() == 200) {
            try {
                response.sendError(403);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ok;
    }

    public TransportGuaranteeType transportGuarantee(TransportGuaranteeType currentConnectionGuarantee, TransportGuaranteeType configuredRequiredGuarantee, HttpServletRequest request) {
        return this.delegate.transportGuarantee(currentConnectionGuarantee, configuredRequiredGuarantee, request);
    }

    protected String requestURI(HttpServerExchange request) {
        String uri = request.getRelativePath();
        if (uri == null || uri.equals("/")) {
            uri = "";
        }
        return uri;
    }
}

