/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.customization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.CustomNodeSelector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class CustomizationParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private ToolContext env;
    private final Map<Element, Element> jaxwsBindingsMap = new HashMap<Element, Element>();
    private final List<InputSource> jaxbBindings = new ArrayList<InputSource>();
    private final Map<String, Element> customizedElements = new HashMap<String, Element>();
    private Element handlerChains;
    private Element wsdlNode;
    private String wsdlURL;
    private CustomNodeSelector nodeSelector = new CustomNodeSelector();

    public CustomizationParser() {
        this.jaxwsBindingsMap.clear();
        this.jaxbBindings.clear();
    }

    public Element getHandlerChains() {
        return this.handlerChains;
    }

    public void parse(ToolContext pe) {
        String[] bindingFiles;
        this.env = pe;
        try {
            this.wsdlURL = URIParserUtil.getAbsoluteURI((String)((String)this.env.get("wsdlurl")));
            if (this.env.get("catalog") != null) {
                this.wsdlNode = this.resolveNodeByCatalog(this.wsdlURL);
            }
            if (this.wsdlNode == null) {
                this.wsdlNode = this.getTargetNode(this.wsdlURL);
            }
            if (this.wsdlNode == null) {
                throw new ToolException(new Message("MISSING_WSDL", LOG, new Object[]{this.wsdlURL}));
            }
            this.customizedElements.put(this.wsdlURL, this.wsdlNode);
            bindingFiles = (String[])this.env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)this.env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            try {
                this.addBinding(bindingFiles[i]);
                continue;
            }
            catch (XMLStreamException xse) {
                Message msg = new Message("STAX_PARSER_ERROR", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)xse);
            }
        }
        for (Map.Entry<Element, Element> entry : this.jaxwsBindingsMap.entrySet()) {
            Element oldTargetNode;
            this.nodeSelector.addNamespaces(entry.getKey());
            Element targetNode = oldTargetNode = entry.getValue();
            this.internalizeBinding(entry.getKey(), targetNode, "");
            String uri = entry.getKey().getAttribute("wsdlLocation");
            this.customizedElements.put(uri, targetNode);
            this.updateJaxwsBindingMapValue(targetNode);
        }
        this.buildHandlerChains();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element getTargetNode(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.equals(this.wsdlURL) && this.wsdlNode != null) {
            return this.wsdlNode;
        }
        Document doc = null;
        try (URIResolver resolver = new URIResolver(uri);){
            if (!resolver.isResolved()) {
                Element element = null;
                return element;
            }
            XMLStreamReader reader = null;
            try {
                reader = StaxUtils.createXMLStreamReader((String)uri, (InputStream)resolver.getInputStream());
                doc = StaxUtils.read((XMLStreamReader)reader, (boolean)true);
            }
            catch (Exception e) {
                Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{uri});
                throw new ToolException(msg, (Throwable)e);
            }
            finally {
                try {
                    StaxUtils.close((XMLStreamReader)reader);
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        catch (IOException e1) {
            return null;
        }
        try {
            doc.setDocumentURI(uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (doc == null) return null;
        return doc.getDocumentElement();
    }

    private void updateJaxwsBindingMapValue(Element value) {
        String baseURI = value.getBaseURI();
        for (Map.Entry<Element, Element> entry : this.jaxwsBindingsMap.entrySet()) {
            String uri = entry.getValue().getBaseURI();
            if (uri == null || !uri.equals(baseURI)) continue;
            this.jaxwsBindingsMap.put(entry.getKey(), value);
        }
    }

    private void buildHandlerChains() {
        for (Element jaxwsBinding : this.jaxwsBindingsMap.keySet()) {
            List elemList = DOMUtils.findAllElementsByTagNameNS((Element)jaxwsBinding, (String)"http://java.sun.com/xml/ns/javaee", (String)"handler-chains");
            if (elemList.isEmpty()) continue;
            this.handlerChains = (Element)elemList.get(0);
            return;
        }
    }

    private Node[] getAnnotationNodes(Node node) {
        Node appinfoNode;
        Node annotationNode;
        Node[] nodes = new Node[2];
        for (annotationNode = node.getFirstChild(); !(annotationNode == null || "annotation".equals(annotationNode.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(annotationNode.getNamespaceURI())); annotationNode = annotationNode.getNextSibling()) {
        }
        if (annotationNode == null) {
            annotationNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        }
        nodes[0] = annotationNode;
        for (appinfoNode = annotationNode.getFirstChild(); !(appinfoNode == null || "appinfo".equals(appinfoNode.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(appinfoNode.getNamespaceURI())); appinfoNode = appinfoNode.getNextSibling()) {
        }
        if (appinfoNode == null) {
            appinfoNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            annotationNode.appendChild(appinfoNode);
        }
        nodes[1] = appinfoNode;
        return nodes;
    }

    private void appendJaxbVersion(Element schemaElement) {
        String jaxbPrefix = schemaElement.lookupPrefix("https://jakarta.ee/xml/ns/jaxb");
        if (jaxbPrefix == null) {
            schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "https://jakarta.ee/xml/ns/jaxb");
            schemaElement.setAttributeNS("https://jakarta.ee/xml/ns/jaxb", "jaxb:version", "2.0");
        }
    }

    protected void copyAllJaxbDeclarations(Node schemaNode, Element jaxwsBindingNode) {
        if (this.isSchemaElement(schemaNode)) {
            this.appendJaxbVersion((Element)schemaNode);
        }
        Node[] embededNodes = this.getAnnotationNodes(schemaNode);
        Node annotationNode = embededNodes[0];
        Node appinfoNode = embededNodes[1];
        for (Node childNode = jaxwsBindingNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (this.isSchemaElement(schemaNode)) {
                this.copyJaxbAttributes(childNode, (Element)schemaNode);
            }
            if (!(childNode instanceof Element)) continue;
            Element childEl = (Element)childNode;
            if (this.isJaxbBindings(childNode) && this.isJaxbBindingsElement(childEl)) {
                NodeList nlist = this.nodeSelector.queryNodes(schemaNode, childEl.getAttribute("node"));
                for (int i = 0; i < nlist.getLength(); ++i) {
                    Node node = nlist.item(i);
                    this.copyAllJaxbDeclarations(node, childEl);
                }
                continue;
            }
            Element cloneNode = (Element)ProcessorUtil.cloneNode(schemaNode.getOwnerDocument(), childEl, true);
            NamedNodeMap atts = cloneNode.getAttributes();
            for (int x = 0; x < atts.getLength(); ++x) {
                Attr attr = (Attr)atts.item(x);
                if (!"https://jakarta.ee/xml/ns/jaxb".equals(attr.getNamespaceURI())) continue;
                cloneNode.removeAttributeNode(attr);
                atts = cloneNode.getAttributes();
                x = -1;
            }
            appinfoNode.appendChild(cloneNode);
        }
        if (schemaNode.getFirstChild() != null) {
            schemaNode.insertBefore(annotationNode, schemaNode.getFirstChild());
        } else {
            schemaNode.appendChild(annotationNode);
        }
    }

    private void copyJaxbAttributes(Node childNode, Element schemaNode) {
        if (childNode instanceof Element) {
            Element el = (Element)childNode;
            if (el.getParentNode() != null) {
                this.copyJaxbAttributes(el.getParentNode(), schemaNode);
            }
            NamedNodeMap atts = el.getAttributes();
            for (int x = 0; x < atts.getLength(); ++x) {
                Attr attr = (Attr)atts.item(x);
                if (!"https://jakarta.ee/xml/ns/jaxb".equals(attr.getNamespaceURI())) continue;
                Attr attrnew = schemaNode.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getName());
                attrnew.setValue(attr.getValue());
                schemaNode.setAttributeNodeNS(attrnew);
                if (!"extensionBindingPrefixes".equals(attr.getLocalName())) continue;
                String pfxs = attr.getValue();
                while (pfxs.length() > 0) {
                    String pfx = pfxs;
                    int idx = pfx.indexOf(32);
                    if (idx != -1) {
                        pfxs = pfxs.substring(idx + 1);
                        pfx = pfx.substring(0, idx);
                    } else {
                        pfxs = "";
                    }
                    String ns = el.lookupNamespaceURI(pfx);
                    schemaNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + pfx, ns);
                }
            }
        }
    }

    protected void internalizeBinding(Element bindings, Element targetNode, String expression) {
        Element[] children;
        if (bindings.getAttributeNode("wsdlLocation") != null) {
            expression = "/";
        }
        if (this.isGlobaleBindings(bindings)) {
            this.nodeSelector.addNamespaces(this.wsdlNode);
            if (targetNode != this.wsdlNode) {
                this.nodeSelector.addNamespaces(targetNode);
            }
            this.copyBindingsToWsdl(targetNode, bindings, this.nodeSelector.getNamespaceContext());
        }
        if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") != null) {
            expression = expression + "/" + bindings.getAttribute("node");
            this.nodeSelector.addNamespaces(bindings);
            NodeList nodeList = this.nodeSelector.queryNodes(targetNode, expression);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new ToolException(new Message("NODE_NOT_EXISTS", LOG, new Object[]{expression}));
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (this.hasJaxbBindingDeclaration(bindings)) {
                    this.copyAllJaxbDeclarations(node, bindings);
                    continue;
                }
                this.copyBindingsToWsdl(node, bindings, this.nodeSelector.getNamespaceContext());
            }
        }
        for (Element child : children = this.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxws")) {
            this.internalizeBinding(child, targetNode, expression);
        }
    }

    private void copyBindingsToWsdl(Node node, Node bindings, MapNamespaceContext ctx) {
        if (bindings.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) {
            bindings.setPrefix("jaxws");
        }
        for (Map.Entry ent : ctx.getUsedNamespaces().entrySet()) {
            if (node.lookupNamespaceURI((String)ent.getKey()) != null) continue;
            node.getOwnerDocument().getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)ent.getKey(), (String)ent.getValue());
        }
        Element element = DOMUtils.getFirstElement((Node)bindings);
        while (element != null) {
            if (element.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) {
                element.setPrefix("jaxws");
            }
            element = DOMUtils.getNextElement((Element)element);
        }
        Node cloneNode = ProcessorUtil.cloneNode(node.getOwnerDocument(), bindings, true);
        Node firstChild = DOMUtils.getChild((Node)node, (String)"jaxws:bindings");
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") == -1) {
            this.wsdlNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            Element jaxwsBindingElement = node.getOwnerDocument().createElementNS(ToolConstants.JAXWS_BINDINGS.getNamespaceURI(), "jaxws:bindings");
            node.appendChild(jaxwsBindingElement);
            firstChild = jaxwsBindingElement;
        }
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") > -1) {
            firstChild = node;
            if (this.wsdlNode.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "jaxws") == null) {
                this.wsdlNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            }
        }
        Element cloneEle = (Element)cloneNode;
        cloneEle.removeAttribute("node");
        Element elem = DOMUtils.getFirstElement((Node)cloneNode);
        while (elem != null) {
            Attr attrNode = elem.getAttributeNode("node");
            if (attrNode != null) {
                cloneNode.removeChild(elem);
            }
            elem = DOMUtils.getNextElement((Element)elem);
        }
        if (firstChild != null) {
            firstChild.appendChild(cloneNode);
        }
    }

    private boolean isGlobaleBindings(Element binding) {
        Element ele;
        boolean globleNode = binding.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && "package".equals(binding.getLocalName()) || "enableAsyncMapping".equals(binding.getLocalName()) || "enableAdditionalSOAPHeaderMapping".equals(binding.getLocalName()) || "enableWrapperStyle".equals(binding.getLocalName()) || "enableMIMEContent".equals(binding.getLocalName());
        Node parentNode = binding.getParentNode();
        return parentNode instanceof Element && (ele = (Element)parentNode).getAttributeNode("wsdlLocation") != null && globleNode;
    }

    private Element[] getChildElements(Element parent, String nsUri) {
        ArrayList<Element> a = new ArrayList<Element>();
        for (Node item = parent.getFirstChild(); item != null; item = item.getNextSibling()) {
            if (!(item instanceof Element) || !nsUri.equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[0]);
    }

    private void addBinding(String bindingFile) throws XMLStreamException {
        Element root = null;
        XMLStreamReader xmlReader = null;
        try (URIResolver resolver = new URIResolver(bindingFile);){
            xmlReader = StaxUtils.createXMLStreamReader((String)resolver.getURI().toString(), (InputStream)resolver.getInputStream());
            root = StaxUtils.read((XMLStreamReader)xmlReader, (boolean)true).getDocumentElement();
        }
        catch (Exception e1) {
            try {
                Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{bindingFile});
                throw new ToolException(msg, (Throwable)e1);
            }
            catch (Throwable throwable) {
                StaxUtils.close(xmlReader);
                throw throwable;
            }
        }
        StaxUtils.close((XMLStreamReader)xmlReader);
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Element)root);
        StaxUtils.toNextTag((XMLStreamReader)reader);
        if (this.isValidJaxwsBindingFile(bindingFile, reader)) {
            String wsdlLocation = root.getAttribute("wsdlLocation");
            Element targetNode = null;
            if (!StringUtils.isEmpty((String)wsdlLocation)) {
                String wsdlURI = this.getAbsoluteURI(wsdlLocation, bindingFile);
                targetNode = this.getTargetNode(wsdlURI);
                String resolvedLoc = wsdlURI;
                if (targetNode == null && this.env.get("catalog") != null) {
                    resolvedLoc = this.resolveByCatalog(wsdlURI);
                    targetNode = this.getTargetNode(resolvedLoc);
                }
                if (targetNode == null) {
                    Message msg = new Message("POINT_TO_WSDL_DOES_NOT_EXIST", LOG, new Object[]{bindingFile, resolvedLoc});
                    throw new ToolException(msg);
                }
                root.setAttributeNS(null, "wsdlLocation", wsdlURI);
            } else {
                targetNode = this.wsdlNode;
                root.setAttributeNS(null, "wsdlLocation", this.wsdlURL);
            }
            this.jaxwsBindingsMap.put(root, targetNode);
        } else if (this.isValidJaxbBindingFile(reader)) {
            String schemaLocation = root.getAttribute("schemaLocation");
            String resolvedSchemaLocation = this.resolveByCatalog(schemaLocation);
            if (resolvedSchemaLocation != null) {
                InputSource tmpIns = null;
                try {
                    tmpIns = this.convertToTmpInputSource(root, resolvedSchemaLocation);
                }
                catch (Exception e1) {
                    Message msg = new Message("FAILED_TO_ADD_SCHEMALOCATION", LOG, new Object[]{bindingFile});
                    throw new ToolException(msg, (Throwable)e1);
                }
                this.jaxbBindings.add(tmpIns);
            } else {
                this.jaxbBindings.add(new InputSource(bindingFile));
            }
        }
    }

    private String getAbsoluteURI(String uri, String bindingFile) {
        URI locURI = null;
        try {
            locURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            Message msg = new Message("BINDING_LOC_ERROR", LOG, new Object[]{uri});
            throw new ToolException(msg);
        }
        if (!locURI.isAbsolute()) {
            try {
                String base = URIParserUtil.getAbsoluteURI((String)bindingFile);
                URI baseURI = new URI(base);
                locURI = baseURI.resolve(locURI);
            }
            catch (URISyntaxException e) {
                Message msg = new Message("NOT_URI", LOG, new Object[]{bindingFile});
                throw new ToolException(msg, (Throwable)e);
            }
        }
        return locURI.toString();
    }

    private Element resolveNodeByCatalog(String url) {
        String resolvedLocation = this.resolveByCatalog(url);
        return this.getTargetNode(resolvedLocation);
    }

    private String resolveByCatalog(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        Bus bus = (Bus)this.env.get(Bus.class);
        OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager((Bus)bus);
        try {
            return new OASISCatalogManagerHelper().resolve(catalogResolver, url, null);
        }
        catch (Exception e1) {
            Message msg = new Message("FAILED_RESOLVE_CATALOG", LOG, new Object[]{url});
            throw new ToolException(msg, (Throwable)e1);
        }
    }

    private InputSource convertToTmpInputSource(Element ele, String schemaLoc) throws Exception {
        InputSource result = null;
        ele.setAttributeNS(null, "schemaLocation", schemaLoc);
        File tmpFile = FileUtils.createTempFile((String)"jaxbbinding", (String)".xml");
        StaxUtils.writeTo((Node)ele, (OutputStream)Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]));
        result = new InputSource(URIParserUtil.getAbsoluteURI((String)tmpFile.getAbsolutePath()));
        tmpFile.deleteOnExit();
        return result;
    }

    private boolean isValidJaxbBindingFile(XMLStreamReader reader) {
        return ToolConstants.JAXB_BINDINGS.equals(reader.getName()) || ToolConstants.SCHEMA.equals(reader.getName());
    }

    private boolean isValidJaxwsBindingFile(String bindingLocation, XMLStreamReader reader) {
        return ToolConstants.JAXWS_BINDINGS.equals(reader.getName());
    }

    protected void setWSDLNode(Element node) {
        this.wsdlNode = node;
    }

    public Node getWSDLNode() {
        return this.wsdlNode;
    }

    private boolean isSchemaElement(Node schema) {
        return "http://www.w3.org/2001/XMLSchema".equals(schema.getNamespaceURI()) && "schema".equals(schema.getLocalName());
    }

    private boolean isJAXWSBindings(Node bindings) {
        return "http://java.sun.com/xml/ns/jaxws".equals(bindings.getNamespaceURI()) && "bindings".equals(bindings.getLocalName());
    }

    private boolean isJaxbBindings(Node bindings) {
        return "https://jakarta.ee/xml/ns/jaxb".equals(bindings.getNamespaceURI());
    }

    private boolean isJaxbBindingsElement(Node bindings) {
        return "bindings".equals(bindings.getLocalName());
    }

    protected boolean hasJaxbBindingDeclaration(Node bindings) {
        for (Node childNode = bindings.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!this.isJaxbBindings(childNode)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Element> getCustomizedWSDLElements() {
        return this.customizedElements;
    }

    public List<InputSource> getJaxbBindings() {
        return this.jaxbBindings;
    }

    public static JAXWSBinding mergeJawsBinding(JAXWSBinding binding1, JAXWSBinding binding2) {
        if (binding1 != null && binding2 != null) {
            if (binding2.isEnableAsyncMapping()) {
                binding1.setEnableAsyncMapping(true);
            }
            if (binding2.isEnableWrapperStyle()) {
                binding1.setEnableWrapperStyle(true);
            }
            if (binding2.isEnableMime()) {
                binding1.setEnableMime(true);
            }
            if (binding2.getJaxwsClass() != null) {
                binding1.setJaxwsClass(binding2.getJaxwsClass());
            }
            if (binding2.getJaxwsParas() != null) {
                binding1.setJaxwsParas(binding2.getJaxwsParas());
            }
            return binding1;
        }
        return binding1 == null ? binding2 : binding1;
    }
}

