/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracer;
import io.opentelemetry.sdk.trace.SdkTracerBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SdkTracerProvider
implements TracerProvider,
Closeable {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, spanLimitsSupplier, sampler, spanProcessors);
        this.tracerSdkComponentRegistry = new ComponentRegistry(instrumentationLibraryInfo -> new SdkTracer(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
    }

    public Tracer get(String instrumentationName) {
        return this.tracerBuilder(instrumentationName).build();
    }

    public Tracer get(String instrumentationName, String instrumentationVersion) {
        return this.tracerBuilder(instrumentationName).setInstrumentationVersion(instrumentationVersion).build();
    }

    public TracerBuilder tracerBuilder(@Nullable String instrumentationName) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation name.");
            instrumentationName = DEFAULT_TRACER_NAME;
        }
        return new SdkTracerBuilder(this.tracerSdkComponentRegistry, instrumentationName);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

