/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.Map;

public class ClusterDescriptionConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ClusterDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "clusterId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterId((String)member.getValue());
                    break;
                }
                case "controller": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setController(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "nodes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList<Node>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setNodes(list);
                }
            }
        }
    }

    public static void toJson(ClusterDescription obj, JsonObject json) {
        ClusterDescriptionConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ClusterDescription obj, Map<String, Object> json) {
        if (obj.getClusterId() != null) {
            json.put("clusterId", obj.getClusterId());
        }
        if (obj.getController() != null) {
            json.put("controller", obj.getController().toJson());
        }
        if (obj.getNodes() != null) {
            JsonArray array = new JsonArray();
            obj.getNodes().forEach(item -> array.add((Object)item.toJson()));
            json.put("nodes", array);
        }
    }
}

