/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.EnumSet;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceDependency;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionServiceConfigurator
extends ComponentServiceConfigurator<TransactionConfiguration> {
    private volatile LockingMode locking;
    private volatile long stopTimeout;
    private volatile long transactionTimeout;
    private volatile TransactionMode mode;
    private volatile Dependency transactionDependency;
    private volatile SupplierDependency<TransactionSynchronizationRegistry> tsrDependency;

    public TransactionServiceConfigurator(PathAddress address) {
        super(CacheComponent.TRANSACTION, address);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        new CompositeDependency(new Dependency[]{this.transactionDependency, this.tsrDependency}).register(builder);
        return super.register(builder);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.mode = (TransactionMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.MODE.resolveModelAttribute((ExpressionResolver)context, model), TransactionMode.class);
        this.locking = (LockingMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.LOCKING.resolveModelAttribute((ExpressionResolver)context, model), LockingMode.class);
        this.stopTimeout = TransactionResourceDefinition.Attribute.STOP_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.transactionTimeout = TransactionResourceDefinition.Attribute.COMPLETE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.transactionDependency = !EnumSet.of(TransactionMode.NONE, TransactionMode.BATCH).contains((Object)this.mode) ? new ServiceDependency(context.getCapabilityServiceName(CommonRequirement.LOCAL_TRANSACTION_PROVIDER.getName(), null)) : null;
        this.tsrDependency = this.mode == TransactionMode.NON_XA ? new ServiceSupplierDependency(context.getCapabilityServiceName(TransactionResourceDefinition.TransactionRequirement.TRANSACTION_SYNCHRONIZATION_REGISTRY.getName(), null)) : null;
        return this;
    }

    @Override
    public TransactionConfiguration get() {
        TransactionConfigurationBuilder builder = new ConfigurationBuilder().transaction().lockingMode(this.locking).cacheStopTimeout(this.stopTimeout).completedTxTimeout(this.transactionTimeout).transactionMode(this.mode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL).useSynchronization(this.mode == TransactionMode.NON_XA).recovery().enabled(this.mode == TransactionMode.FULL_XA).transaction();
        switch (this.mode) {
            case NONE: {
                break;
            }
            case BATCH: {
                builder.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((TransactionManager)EmbeddedTransactionManager.getInstance()));
                break;
            }
            case NON_XA: {
                builder.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider((TransactionSynchronizationRegistry)this.tsrDependency.get()));
            }
            default: {
                builder.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((TransactionManager)ContextTransactionManager.getInstance()));
            }
        }
        return builder.create();
    }
}

