/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.deployment;

import jakarta.enterprise.inject.spi.Extension;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemDefinition;
import org.wildfly.extension.opentelemetry.api.OpenTelemetryCdiExtension;

public class OpenTelemetryDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        this.addDependencies(phaseContext.getDeploymentUnit());
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        try {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            weldCapability.registerExtensionInstance((Extension)new OpenTelemetryCdiExtension(), deploymentUnit);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : OpenTelemetrySubsystemDefinition.EXPORTED_MODULES) {
            ModuleDependency modDep = new ModuleDependency(moduleLoader, module, false, true, true, false);
            moduleSpecification.addSystemDependency(modDep);
        }
    }
}

