/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.reader;

import jakarta.persistence.NoResultException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.CrossTypeRevisionChangesReader;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.exception.NotAuditedException;
import org.hibernate.envers.exception.RevisionDoesNotExistException;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.reader.CrossTypeRevisionChangesReaderImpl;
import org.hibernate.envers.internal.reader.FirstLevelCache;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.tools.ArgumentsTools;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQueryCreator;
import org.hibernate.event.spi.EventSource;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.Query;

public class AuditReaderImpl
implements AuditReaderImplementor {
    private final EnversService enversService;
    private final SessionImplementor sessionImplementor;
    private final Session session;
    private final FirstLevelCache firstLevelCache;
    private final CrossTypeRevisionChangesReader crossTypeRevisionChangesReader;

    public AuditReaderImpl(EnversService enversService, Session session, SessionImplementor sessionImplementor) {
        this.enversService = enversService;
        this.sessionImplementor = sessionImplementor;
        this.session = session;
        this.firstLevelCache = new FirstLevelCache();
        this.crossTypeRevisionChangesReader = new CrossTypeRevisionChangesReaderImpl(this, enversService);
    }

    private void checkSession() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }

    @Override
    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = EntityTools.getTargetClassIfProxied(cls);
        return this.find(cls, cls.getName(), primaryKey, revision);
    }

    @Override
    public <T> T find(Class<T> cls, String entityName, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        return this.find(cls, entityName, primaryKey, revision, false);
    }

    @Override
    public <T> T find(Class<T> cls, String entityName, Object primaryKey, Number revision, boolean includeDeletions) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        Object result;
        cls = EntityTools.getTargetClassIfProxied(cls);
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        if (this.firstLevelCache.contains(entityName, revision, primaryKey)) {
            return (T)this.firstLevelCache.get(entityName, revision, primaryKey);
        }
        try {
            result = this.createQuery().forEntitiesAtRevision(cls, entityName, revision, includeDeletions).add(AuditEntity.id().eq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
        return (T)result;
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = EntityTools.getTargetClassIfProxied(cls);
        return this.getRevisions(cls, cls.getName(), primaryKey);
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Date date) throws IllegalArgumentException, NotAuditedException, RevisionDoesNotExistException, IllegalStateException {
        return this.find(cls, primaryKey, this.getRevisionNumberForDate(date));
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, String entityName, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = EntityTools.getTargetClassIfProxied(cls);
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        this.checkSession();
        return this.createQuery().forRevisionsOfEntity(cls, entityName, false, true).addProjection(AuditEntity.revisionNumber()).addOrder(AuditEntity.revisionNumber().asc()).add(AuditEntity.id().eq(primaryKey)).getResultList();
    }

    @Override
    public Date getRevisionDate(Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Query<?> query = this.enversService.getRevisionInfoQueryCreator().getRevisionDateQuery(this.session, revision);
        try {
            Object timestampObject = query.uniqueResult();
            if (timestampObject == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return timestampObject instanceof Date ? (Date)timestampObject : new Date((Long)timestampObject);
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public Number getRevisionNumberForDate(Date date) {
        ArgumentsTools.checkNotNull(date, "Date of revision");
        this.checkSession();
        Query<?> query = this.enversService.getRevisionInfoQueryCreator().getRevisionNumberForDateQuery(this.session, date);
        try {
            Number res = (Number)query.uniqueResult();
            if (res == null) {
                throw new RevisionDoesNotExistException(date);
            }
            return res;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> T findRevision(Class<T> revisionEntityClass, Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        revisionEntityClass = EntityTools.getTargetClassIfProxied(revisionEntityClass);
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        HashSet<Number> revisions = new HashSet<Number>(1);
        revisions.add(revision);
        Query<?> query = this.enversService.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            Object revisionData = query.uniqueResult();
            if (revisionData == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return (T)revisionData;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> Map<Number, T> findRevisions(Class<T> revisionEntityClass, Set<Number> revisions) throws IllegalArgumentException, IllegalStateException {
        revisionEntityClass = EntityTools.getTargetClassIfProxied(revisionEntityClass);
        HashMap result = new HashMap(revisions.size());
        for (Number revision : revisions) {
            ArgumentsTools.checkNotNull(revision, "Entity revision");
            ArgumentsTools.checkPositive(revision, "Entity revision");
        }
        this.checkSession();
        Query<?> query = this.enversService.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            List revisionList = query.getResultList();
            for (Object revision : revisionList) {
                Number revNo = this.enversService.getRevisionInfoNumberReader().getRevisionNumber(revision);
                result.put(revNo, revision);
            }
            return result;
        }
        catch (HibernateException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public CrossTypeRevisionChangesReader getCrossTypeRevisionChangesReader() throws AuditException {
        if (!this.enversService.getGlobalConfiguration().isTrackEntitiesChangedInRevision()) {
            throw new AuditException("This API is designed for Envers default mechanism of tracking entities modified in a given revision. Extend DefaultTrackingModifiedEntitiesRevisionEntity, utilize @ModifiedEntityNames annotation or set 'org.hibernate.envers.track_entities_changed_in_revision' parameter to true.");
        }
        return this.crossTypeRevisionChangesReader;
    }

    @Override
    public <T> T getCurrentRevision(Class<T> revisionEntityClass, boolean persist) {
        revisionEntityClass = EntityTools.getTargetClassIfProxied(revisionEntityClass);
        if (!(this.session instanceof EventSource)) {
            throw new IllegalArgumentException("The provided session is not an EventSource!");
        }
        AuditProcess auditProcess = this.enversService.getAuditProcessManager().get((EventSource)this.session);
        return (T)auditProcess.getCurrentRevisionData(this.session, persist);
    }

    @Override
    public AuditQueryCreator createQuery() {
        return new AuditQueryCreator(this.enversService, this);
    }

    @Override
    public boolean isEntityClassAudited(Class<?> entityClass) {
        entityClass = EntityTools.getTargetClassIfProxied(entityClass);
        return this.isEntityNameAudited(entityClass.getName());
    }

    @Override
    public boolean isEntityNameAudited(String entityName) {
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        this.checkSession();
        return this.enversService.getEntitiesConfigurations().isVersioned(entityName);
    }

    @Override
    public String getEntityName(Object primaryKey, Number revision, Object entity) throws HibernateException {
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        ArgumentsTools.checkNotNull(entity, "Entity");
        this.checkSession();
        if (entity instanceof HibernateProxy) {
            entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        if (this.firstLevelCache.containsEntityName(primaryKey, revision, entity)) {
            return this.firstLevelCache.getFromEntityNameCache(primaryKey, revision, entity);
        }
        throw new HibernateException("Envers can't resolve entityName for historic entity. The id, revision and entity is not on envers first level cache.");
    }
}

