/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;

@MappedSuperclass
public class DefaultRevisionEntity
implements Serializable {
    private static final long serialVersionUID = 8530213963961662300L;
    @Id
    @GeneratedValue
    @RevisionNumber
    private int id;
    @RevisionTimestamp
    private long timestamp;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Transient
    public Date getRevisionDate() {
        return new Date(this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRevisionEntity)) {
            return false;
        }
        DefaultRevisionEntity that = (DefaultRevisionEntity)o;
        return this.id == that.id && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "DefaultRevisionEntity(id = " + this.id + ", revisionDate = " + DateFormat.getDateTimeInstance().format(this.getRevisionDate()) + ")";
    }
}

