/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.wildfly.security.http.oidc.ClientCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcClientConfigurationResolver;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.PublicKeyLocator;

public class OidcClientContext {
    protected OidcClientConfiguration oidcClientConfig;
    protected OidcClientConfigurationResolver oidcConfigResolver;

    public OidcClientContext() {
    }

    public OidcClientContext(OidcClientConfiguration oidcClientConfig) {
        this.oidcClientConfig = oidcClientConfig;
    }

    public OidcClientContext(OidcClientConfigurationResolver oidcConfigResolver) {
        this.oidcConfigResolver = oidcConfigResolver;
    }

    public OidcClientConfiguration resolveDeployment(OidcHttpFacade facade) {
        if (this.oidcConfigResolver != null) {
            return this.oidcConfigResolver.resolve(facade.getRequest());
        }
        if (this.oidcClientConfig == null) {
            return null;
        }
        if (this.oidcClientConfig.getAuthServerBaseUrl() == null && this.oidcClientConfig.getProviderUrl() == null) {
            return this.oidcClientConfig;
        }
        OidcClientConfiguration resolvedDeployment = this.resolveUrls(this.oidcClientConfig, facade);
        if (resolvedDeployment.getPublicKeyLocator() == null) {
            throw new RuntimeException("KeycloakDeployment was never initialized through appropriate SPIs");
        }
        return resolvedDeployment;
    }

    protected OidcClientConfiguration resolveUrls(OidcClientConfiguration deployment, OidcHttpFacade facade) {
        if (deployment.relativeUrls == OidcClientConfiguration.RelativeUrlsUsed.NEVER) {
            return deployment;
        }
        OidcClientConfigurationDelegate delegate = new OidcClientConfigurationDelegate(this.oidcClientConfig);
        if (this.oidcClientConfig.getAuthServerBaseUrl() != null) {
            delegate.setAuthServerBaseUrl(this.getAuthServerBaseUrl(facade, this.oidcClientConfig.getAuthServerBaseUrl()));
        }
        if (this.oidcClientConfig.getProviderUrl() != null) {
            delegate.setProviderUrl(this.oidcClientConfig.getProviderUrl());
        }
        return delegate;
    }

    protected String getAuthServerBaseUrl(OidcHttpFacade facade, String base) {
        try {
            URIBuilder builder = new URIBuilder(base);
            URI request = URI.create(facade.getRequest().getURI());
            String scheme = request.getScheme();
            if (this.oidcClientConfig.getSSLRequired().isRequired(facade.getRequest().getRemoteAddr())) {
                scheme = "https";
                if (!request.getScheme().equals(scheme) && request.getPort() != -1) {
                    ElytronMessages.log.error("request scheme: " + request.getScheme() + " ssl required");
                    throw ElytronMessages.log.unableToResolveARelativeUrl();
                }
            }
            builder.setScheme(scheme);
            builder.setHost(request.getHost());
            if (request.getPort() != -1) {
                builder.setPort(request.getPort());
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw ElytronMessages.log.unableToSetAuthServerUrl(e);
        }
    }

    protected static class OidcClientConfigurationDelegate
    extends OidcClientConfiguration {
        protected OidcClientConfiguration delegate;

        public OidcClientConfigurationDelegate(OidcClientConfiguration delegate) {
            this.delegate = delegate;
        }

        public void setAuthServerBaseUrl(String authServerBaseUrl) {
            this.authServerBaseUrl = authServerBaseUrl;
            this.resolveUrls();
        }

        @Override
        public void setProviderUrl(String providerUrl) {
            this.providerUrl = providerUrl;
            this.resolveUrls();
        }

        @Override
        public OidcClientConfiguration.RelativeUrlsUsed getRelativeUrls() {
            return this.delegate.getRelativeUrls();
        }

        @Override
        public String getTokenUrl() {
            return this.tokenUrl != null ? this.tokenUrl : this.delegate.getTokenUrl();
        }

        @Override
        public String getLogoutUrl() {
            return this.logoutUrl != null ? this.logoutUrl : this.delegate.getLogoutUrl();
        }

        @Override
        public String getAccountUrl() {
            return this.accountUrl != null ? this.accountUrl : this.delegate.getAccountUrl();
        }

        @Override
        public String getRegisterNodeUrl() {
            return this.registerNodeUrl != null ? this.registerNodeUrl : this.delegate.getRegisterNodeUrl();
        }

        @Override
        public String getUnregisterNodeUrl() {
            return this.unregisterNodeUrl != null ? this.unregisterNodeUrl : this.delegate.getUnregisterNodeUrl();
        }

        @Override
        public String getJwksUrl() {
            return this.jwksUrl != null ? this.jwksUrl : this.delegate.getJwksUrl();
        }

        @Override
        public String getResource() {
            return this.delegate.getResource();
        }

        @Override
        public String getClientId() {
            return this.delegate.getClientId();
        }

        @Override
        public String getResourceName() {
            return this.delegate.getResourceName();
        }

        @Override
        public String getRealm() {
            return this.delegate.getRealm();
        }

        @Override
        public void setRealm(String realm) {
            this.delegate.setRealm(realm);
        }

        @Override
        public void setPublicKeyLocator(PublicKeyLocator publicKeyLocator) {
            this.delegate.setPublicKeyLocator(publicKeyLocator);
        }

        @Override
        public PublicKeyLocator getPublicKeyLocator() {
            return this.delegate.getPublicKeyLocator();
        }

        @Override
        public void setResource(String resourceName) {
            this.delegate.setResource(resourceName);
        }

        @Override
        public void setClientId(String clientId) {
            this.delegate.setClientId(clientId);
        }

        @Override
        public boolean isBearerOnly() {
            return this.delegate.isBearerOnly();
        }

        @Override
        public void setBearerOnly(boolean bearerOnly) {
            this.delegate.setBearerOnly(bearerOnly);
        }

        @Override
        public boolean isAutodetectBearerOnly() {
            return this.delegate.isAutodetectBearerOnly();
        }

        @Override
        public void setAutodetectBearerOnly(boolean autodetectBearerOnly) {
            this.delegate.setAutodetectBearerOnly(autodetectBearerOnly);
        }

        @Override
        public boolean isEnableBasicAuth() {
            return this.delegate.isEnableBasicAuth();
        }

        @Override
        public void setEnableBasicAuth(boolean enableBasicAuth) {
            this.delegate.setEnableBasicAuth(enableBasicAuth);
        }

        @Override
        public boolean isPublicClient() {
            return this.delegate.isPublicClient();
        }

        @Override
        public void setPublicClient(boolean publicClient) {
            this.delegate.setPublicClient(publicClient);
        }

        @Override
        public Map<String, Object> getResourceCredentials() {
            return this.delegate.getResourceCredentials();
        }

        @Override
        public void setResourceCredentials(Map<String, Object> resourceCredentials) {
            this.delegate.setResourceCredentials(resourceCredentials);
        }

        @Override
        public void setClientAuthenticator(ClientCredentialsProvider clientAuthenticator) {
            this.delegate.setClientAuthenticator(clientAuthenticator);
        }

        @Override
        public ClientCredentialsProvider getClientAuthenticator() {
            return this.delegate.getClientAuthenticator();
        }

        @Override
        public HttpClient getClient() {
            return this.delegate.getClient();
        }

        @Override
        public void setClient(HttpClient client) {
            this.delegate.setClient(client);
        }

        @Override
        public String getScope() {
            return this.delegate.getScope();
        }

        @Override
        public void setScope(String scope) {
            this.delegate.setScope(scope);
        }

        @Override
        public Oidc.SSLRequired getSSLRequired() {
            return this.delegate.getSSLRequired();
        }

        @Override
        public void setSSLRequired(Oidc.SSLRequired sslRequired) {
            this.delegate.setSSLRequired(sslRequired);
        }

        @Override
        public int getConfidentialPort() {
            return this.delegate.getConfidentialPort();
        }

        @Override
        public void setConfidentialPort(int confidentialPort) {
            this.delegate.setConfidentialPort(confidentialPort);
        }

        @Override
        public Oidc.TokenStore getTokenStore() {
            return this.delegate.getTokenStore();
        }

        @Override
        public void setTokenStore(Oidc.TokenStore tokenStore) {
            this.delegate.setTokenStore(tokenStore);
        }

        @Override
        public String getOidcStateCookiePath() {
            return this.delegate.getOidcStateCookiePath();
        }

        @Override
        public void setOidcStateCookiePath(String oidcStateCookiePath) {
            this.delegate.setOidcStateCookiePath(oidcStateCookiePath);
        }

        @Override
        public String getStateCookieName() {
            return this.delegate.getStateCookieName();
        }

        @Override
        public void setStateCookieName(String stateCookieName) {
            this.delegate.setStateCookieName(stateCookieName);
        }

        @Override
        public boolean isUseResourceRoleMappings() {
            return this.delegate.isUseResourceRoleMappings();
        }

        @Override
        public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
            this.delegate.setUseResourceRoleMappings(useResourceRoleMappings);
        }

        @Override
        public boolean isCors() {
            return this.delegate.isCors();
        }

        @Override
        public void setCors(boolean cors) {
            this.delegate.setCors(cors);
        }

        @Override
        public int getCorsMaxAge() {
            return this.delegate.getCorsMaxAge();
        }

        @Override
        public void setCorsMaxAge(int corsMaxAge) {
            this.delegate.setCorsMaxAge(corsMaxAge);
        }

        @Override
        public String getCorsAllowedHeaders() {
            return this.delegate.getCorsAllowedHeaders();
        }

        @Override
        public void setNotBefore(int notBefore) {
            this.delegate.setNotBefore(notBefore);
        }

        @Override
        public int getNotBefore() {
            return this.delegate.getNotBefore();
        }

        @Override
        public void updateNotBefore(int notBefore) {
            this.delegate.setNotBefore(notBefore);
            this.getPublicKeyLocator().reset(this);
        }

        @Override
        public void setExposeToken(boolean exposeToken) {
            this.delegate.setExposeToken(exposeToken);
        }

        @Override
        public boolean isExposeToken() {
            return this.delegate.isExposeToken();
        }

        @Override
        public void setCorsAllowedMethods(String corsAllowedMethods) {
            this.delegate.setCorsAllowedMethods(corsAllowedMethods);
        }

        @Override
        public String getCorsAllowedMethods() {
            return this.delegate.getCorsAllowedMethods();
        }

        @Override
        public void setCorsAllowedHeaders(String corsAllowedHeaders) {
            this.delegate.setCorsAllowedHeaders(corsAllowedHeaders);
        }

        @Override
        public boolean isAlwaysRefreshToken() {
            return this.delegate.isAlwaysRefreshToken();
        }

        @Override
        public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
            this.delegate.setAlwaysRefreshToken(alwaysRefreshToken);
        }

        @Override
        public int getRegisterNodePeriod() {
            return this.delegate.getRegisterNodePeriod();
        }

        @Override
        public void setRegisterNodePeriod(int registerNodePeriod) {
            this.delegate.setRegisterNodePeriod(registerNodePeriod);
        }

        @Override
        public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
            this.delegate.setRegisterNodeAtStartup(registerNodeAtStartup);
        }

        @Override
        public boolean isRegisterNodeAtStartup() {
            return this.delegate.isRegisterNodeAtStartup();
        }

        @Override
        public String getPrincipalAttribute() {
            return this.delegate.getPrincipalAttribute();
        }

        @Override
        public void setPrincipalAttribute(String principalAttribute) {
            this.delegate.setPrincipalAttribute(principalAttribute);
        }

        @Override
        public boolean isTurnOffChangeSessionIdOnLogin() {
            return this.delegate.isTurnOffChangeSessionIdOnLogin();
        }

        @Override
        public void setTurnOffChangeSessionIdOnLogin(boolean turnOffChangeSessionIdOnLogin) {
            this.delegate.setTurnOffChangeSessionIdOnLogin(turnOffChangeSessionIdOnLogin);
        }

        @Override
        public int getTokenMinimumTimeToLive() {
            return this.delegate.getTokenMinimumTimeToLive();
        }

        @Override
        public void setTokenMinimumTimeToLive(int tokenMinimumTimeToLive) {
            this.delegate.setTokenMinimumTimeToLive(tokenMinimumTimeToLive);
        }

        @Override
        public void setMinTimeBetweenJwksRequests(int minTimeBetweenJwksRequests) {
            this.delegate.setMinTimeBetweenJwksRequests(minTimeBetweenJwksRequests);
        }

        @Override
        public int getMinTimeBetweenJwksRequests() {
            return this.delegate.getMinTimeBetweenJwksRequests();
        }

        @Override
        public int getPublicKeyCacheTtl() {
            return this.delegate.getPublicKeyCacheTtl();
        }

        @Override
        public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
            this.delegate.setPublicKeyCacheTtl(publicKeyCacheTtl);
        }

        @Override
        public boolean isVerifyTokenAudience() {
            return this.delegate.isVerifyTokenAudience();
        }

        @Override
        public void setVerifyTokenAudience(boolean verifyTokenAudience) {
            this.delegate.setVerifyTokenAudience(verifyTokenAudience);
        }

        @Override
        public String getTokenSignatureAlgorithm() {
            return this.delegate.getTokenSignatureAlgorithm();
        }

        @Override
        public void setTokenSignatureAlgorithm(String tokenSignatureAlgorithm) {
            this.delegate.setTokenSignatureAlgorithm(tokenSignatureAlgorithm);
        }
    }
}

