/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.transaction.xa.XAException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;

public class HttpRemoteTransactionMessages_$logger
extends DelegatingBasicLogger
implements HttpRemoteTransactionMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpRemoteTransactionMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public HttpRemoteTransactionMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String operationInterrupted$str() {
        return "TXNWFHTTP000001: The protocol operation was interrupted locally";
    }

    @Override
    public final SystemException operationInterrupted() {
        SystemException result = new SystemException(String.format(this.getLoggingLocale(), this.operationInterrupted$str(), new Object[0]));
        HttpRemoteTransactionMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String rollbackOnlyRollback$str() {
        return "TXNWFHTTP000002: Rollback-only transaction rolled back";
    }

    @Override
    public final RollbackException rollbackOnlyRollback() {
        RollbackException result = new RollbackException(String.format(this.getLoggingLocale(), this.rollbackOnlyRollback$str(), new Object[0]));
        HttpRemoteTransactionMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTxnState$str() {
        return "TXNWFHTTP000003: Invalid transaction state";
    }

    @Override
    public final IllegalStateException invalidTxnState() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidTxnState$str(), new Object[0]));
        HttpRemoteTransactionMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedXA$str() {
        return "TXNWFHTTP000004: Transaction operation failed due to thread interruption";
    }

    @Override
    public final XAException interruptedXA(int errorCode) {
        XAException result = new XAException(String.format(this.getLoggingLocale(), this.interruptedXA$str(), new Object[0]));
        HttpRemoteTransactionMessages_$logger._copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
}

