/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public class JsonLoader {
    private static final JsonProvider provider = JsonLoader.loadProvider();

    private static JsonProvider loadProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){

            @Override
            public JsonProvider run() {
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(JsonLoader.class.getClassLoader());
                    JsonProvider jsonProvider = JsonProvider.provider();
                    return jsonProvider;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                }
            }
        });
    }

    public static JsonParser createParser(Reader reader) {
        return provider.createParser(reader);
    }

    public static JsonParser createParser(InputStream in) {
        return provider.createParser(in);
    }

    public static JsonGenerator createGenerator(Writer writer) {
        return provider.createGenerator(writer);
    }

    public static JsonGenerator createGenerator(OutputStream out) {
        return provider.createGenerator(out);
    }

    public static JsonParserFactory createParserFactory(Map<String, ?> config) {
        return provider.createParserFactory(config);
    }

    public static JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return provider.createGeneratorFactory(config);
    }

    public static JsonWriter createWriter(Writer writer) {
        return provider.createWriter(writer);
    }

    public static JsonWriter createWriter(OutputStream out) {
        return provider.createWriter(out);
    }

    public static JsonReader createReader(Reader reader) {
        return provider.createReader(reader);
    }

    public static JsonReader createReader(InputStream in) {
        return provider.createReader(in);
    }

    public static JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return provider.createReaderFactory(config);
    }

    public static JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return provider.createWriterFactory(config);
    }

    public static JsonArrayBuilder createArrayBuilder() {
        return provider.createArrayBuilder();
    }

    public static JsonObjectBuilder createObjectBuilder() {
        return provider.createObjectBuilder();
    }

    public static JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        return provider.createBuilderFactory(config);
    }
}

