/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.ssl.DefaultSSLContextFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class CachingSSLContextFactory
extends DefaultSSLContextFactory {
    private static final Map<String, SSLContext> SSL_CONTEXTS = Collections.synchronizedMap(new HashMap());

    @Override
    public void clearSSLContexts() {
        SSL_CONTEXTS.clear();
    }

    @Override
    public SSLContext getSSLContext(Map<String, Object> configuration, String keystoreProvider, String keystorePath, String keystorePassword, String truststoreProvider, String truststorePath, String truststorePassword, String crlPath, String trustManagerFactoryPlugin, boolean trustAll) throws Exception {
        String sslContextName = this.getSSLContextName(configuration, keystorePath, keystoreProvider, truststorePath, truststoreProvider);
        if (!SSL_CONTEXTS.containsKey(sslContextName)) {
            SSL_CONTEXTS.put(sslContextName, this.createSSLContext(configuration, keystoreProvider, keystorePath, keystorePassword, truststoreProvider, truststorePath, truststorePassword, crlPath, trustManagerFactoryPlugin, trustAll));
        }
        return SSL_CONTEXTS.get(sslContextName);
    }

    protected String getSSLContextName(Map<String, Object> configuration, String keyStorePath, String keystoreProvider, String truststorePath, String truststoreProvider) {
        String sslContextName = ConfigurationHelper.getStringProperty("sslContext", null, configuration);
        if (sslContextName == null) {
            if (keyStorePath != null) {
                return keyStorePath + '_' + keystoreProvider;
            }
            return truststorePath + '_' + truststoreProvider;
        }
        return sslContextName;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

