/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.util.Proxies;

public final class DefaultProxyInstantiator
implements ProxyInstantiator {
    public static final ProxyInstantiator INSTANCE = new DefaultProxyInstantiator();

    private DefaultProxyInstantiator() {
    }

    @Override
    public <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    @Override
    public <T> UnproxyableResolutionException validateNoargConstructor(Constructor<T> constructor, Class<?> clazz, Bean<?> declaringBean) throws UnproxyableResolutionException {
        if (constructor == null) {
            return ValidatorLogger.LOG.notProxyableNoConstructor(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            return new UnproxyableResolutionException(ValidatorLogger.LOG.notProxyablePrivateConstructor(clazz.getName(), constructor, Proxies.getDeclaringBeanInfo(declaringBean)));
        }
        return null;
    }

    @Override
    public boolean isUsingConstructor() {
        return true;
    }

    public void cleanup() {
    }
}

