/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wscoor.client;

import com.arjuna.webservices.logging.WSCLogger;
import com.arjuna.webservices11.util.PrivilegedServiceFactory;
import com.arjuna.webservices11.util.PrivilegedServiceHelper;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.util.Map;
import org.jboss.jbossts.xts.environment.WSCEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationPortType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationService;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationPortType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationService;

public class WSCOORClient {
    private static ThreadLocal<ActivationService> activationService = new ThreadLocal();
    private static ThreadLocal<RegistrationService> registrationService = new ThreadLocal();

    private static synchronized ActivationService getActivationService() {
        if (activationService.get() == null) {
            activationService.set(PrivilegedServiceFactory.getInstance(ActivationService.class).getService());
        }
        return activationService.get();
    }

    private static synchronized RegistrationService getRegistrationService() {
        if (registrationService.get() == null) {
            registrationService.set(PrivilegedServiceFactory.getInstance(RegistrationService.class).getService());
        }
        return registrationService.get();
    }

    public static ActivationPortType getActivationPort(MAP map, String action) {
        ActivationService service = WSCOORClient.getActivationService();
        ActivationPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, ActivationPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        String to = map.getTo();
        Map requestContext = bindingProvider.getRequestContext();
        AddressingHelper.configureRequestContext(requestContext, map, to, action);
        return port;
    }

    public static RegistrationPortType getRegistrationPort(W3CEndpointReference endpointReference, String action, String messageID) {
        RegistrationService service = WSCOORClient.getRegistrationService();
        RegistrationPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, RegistrationPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        Map requestContext = bindingProvider.getRequestContext();
        MAP map = WSCOORClient.getRegistrationPortMap(requestContext);
        AddressingHelper.installActionMessageID(map, action, messageID);
        AddressingHelper.configureRequestContext(requestContext, map.getTo(), action);
        return port;
    }

    private static MAP getRegistrationPortMap(Map<String, Object> requestContext) {
        MAP map;
        WSCEnvironmentBean wscEnvironmentBean = XTSPropertyManager.getWSCEnvironmentBean();
        if ("SECURE".equals(wscEnvironmentBean.getUseAsynchronousRequest())) {
            String responseService = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry().getSecureServiceURI("RegistrationResponseService");
            String faultService = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry().getSecureServiceURI("CoordinationFaultService");
            WSCLogger.logger.tracev("WSCOORClient Using secure endpoints {0} {1}", (Object)responseService, (Object)faultService);
            map = AddressingHelper.outboundMap(requestContext, responseService, faultService);
        } else if ("PLAIN".equals(wscEnvironmentBean.getUseAsynchronousRequest())) {
            String responseService = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry().getServiceURI("RegistrationResponseService");
            String faultService = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry().getServiceURI("CoordinationFaultService");
            WSCLogger.logger.tracev("WSCOORClient Using plain endpoints {0} {1}", (Object)responseService, (Object)faultService);
            map = AddressingHelper.outboundMap(requestContext, responseService, faultService);
        } else {
            WSCLogger.logger.tracev("WSCOORClient Using anonymous endpoints", new Object[0]);
            map = AddressingHelper.outboundMap(requestContext);
        }
        return map;
    }
}

