/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.jndi;

import java.util.Enumeration;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jndi.JNDIReferenceFactory;
import org.junit.Assert;
import org.junit.Test;

public class StringRefAddrReferenceTest {
    private static final String FACTORY = "factory";
    private static final String TYPE = "type";

    @Test(timeout=10000L)
    public void testActiveMQQueueFromPropertiesJNDI() throws Exception {
        Properties properties = new Properties();
        properties.setProperty(TYPE, ActiveMQQueue.class.getName());
        properties.setProperty(FACTORY, JNDIReferenceFactory.class.getName());
        String address = "foo.bar.queue";
        properties.setProperty("address", address);
        Reference reference = this.from(properties);
        ActiveMQQueue object = this.getObject(reference, ActiveMQQueue.class);
        Assert.assertEquals((Object)address, (Object)object.getAddress());
    }

    @Test(timeout=10000L)
    public void testActiveMQTopicFromPropertiesJNDI() throws Exception {
        Properties properties = new Properties();
        properties.setProperty(TYPE, ActiveMQTopic.class.getName());
        properties.setProperty(FACTORY, JNDIReferenceFactory.class.getName());
        String address = "foo.bar.topic";
        properties.setProperty("address", address);
        Reference reference = this.from(properties);
        ActiveMQTopic object = this.getObject(reference, ActiveMQTopic.class);
        Assert.assertEquals((Object)address, (Object)object.getAddress());
    }

    @Test(timeout=10000L)
    public void testActiveMQConnectionFactoryFromPropertiesJNDI() throws Exception {
        Properties properties = new Properties();
        properties.setProperty(TYPE, ActiveMQConnectionFactory.class.getName());
        properties.setProperty(FACTORY, JNDIReferenceFactory.class.getName());
        String brokerURL = "vm://0";
        String connectionTTL = "1000";
        String preAcknowledge = "true";
        properties.setProperty("brokerURL", brokerURL);
        properties.setProperty("connectionTTL", connectionTTL);
        properties.setProperty("preAcknowledge", preAcknowledge);
        Reference reference = this.from(properties);
        ActiveMQConnectionFactory object = this.getObject(reference, ActiveMQConnectionFactory.class);
        Assert.assertEquals((long)Long.parseLong(connectionTTL), (long)object.getConnectionTTL());
        Assert.assertEquals((Object)Boolean.parseBoolean(preAcknowledge), (Object)object.isPreAcknowledge());
    }

    private <T> T getObject(Reference reference, Class<T> tClass) throws Exception {
        String factoryName = reference.getFactoryClassName();
        Class<?> factoryClass = Class.forName(factoryName);
        ObjectFactory factory = (ObjectFactory)factoryClass.newInstance();
        Object o = factory.getObjectInstance(reference, null, null, null);
        if (tClass.isAssignableFrom(tClass)) {
            return tClass.cast(o);
        }
        throw new IllegalStateException("Expected class, " + tClass.getName());
    }

    public Reference from(Properties properties) {
        String type = (String)properties.remove(TYPE);
        String factory = (String)properties.remove(FACTORY);
        Reference result = new Reference(type, factory, null);
        Enumeration<?> iter = properties.propertyNames();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            result.add(new StringRefAddr(key, properties.getProperty(key)));
        }
        return result;
    }
}

