/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class WildcardAddressManagerPerfTest {
    @Test
    @Ignore
    public void testConcurrencyAndEfficiency() throws Exception {
        System.out.println("Type so we can go on..");
        System.out.println("we can go on..");
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        int numSubs = 5000;
        int numThreads = 4;
        int partitions = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        int i = 0;
        while (i < numSubs) {
            int id = i++;
            executorService.submit(() -> {
                try {
                    Bindings binding;
                    if (id % 1000 == 0) {
                        Thread.yield();
                    }
                    ad.addBinding((Binding)new BindingFake(SimpleString.toSimpleString((String)("Topic1." + id % 2 + ".>")), SimpleString.toSimpleString((String)("" + id)), id));
                    SimpleString pubAddr = SimpleString.toSimpleString((String)("Topic1." + id % 2 + "." + id));
                    if (id != 0 && id % 1000 == 0) {
                        System.err.println("0. pub for: " + id);
                    }
                    if ((binding = ad.getBindingsForRoutingAddress(pubAddr)) != null) {
                        if (id != 0 && id % 1000 == 0) {
                            System.err.println("1. Bindings for: " + id + ", " + binding.getBindings().size());
                        }
                        binding = ad.getBindingsForRoutingAddress(pubAddr);
                        if (id % 500 == 0) {
                            System.err.println("2. Bindings for: " + id + ", " + binding.getBindings().size());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        executorService.shutdown();
        Assert.assertTrue((String)"finished on time", (boolean)executorService.awaitTermination(10L, TimeUnit.MINUTES));
        final AtomicLong addresses = new AtomicLong();
        final AtomicLong bindings = new AtomicLong();
        ad.getAddressMap().visitMatchingWildcards(SimpleString.toSimpleString((String)">"), (AddressMapVisitor)new AddressMapVisitor<Bindings>(){

            public void visit(Bindings value) {
                addresses.incrementAndGet();
                bindings.addAndGet(value.getBindings().size());
            }
        });
        System.err.println("Total: Addresses: " + addresses.get() + ", bindings: " + bindings.get());
        System.out.println("Type so we can go on..");
        System.out.println("we can go on..");
    }

    class BindingFake
    implements Binding {
        final SimpleString address;
        final SimpleString id;
        final Long idl;

        BindingFake(SimpleString addressParameter, SimpleString id, long idl) {
            this.address = addressParameter;
            this.id = id;
            this.idl = idl;
        }

        public void unproposed(SimpleString groupID) {
        }

        public SimpleString getAddress() {
            return this.address;
        }

        public Bindable getBindable() {
            return null;
        }

        public BindingType getType() {
            return BindingType.LOCAL_QUEUE;
        }

        public SimpleString getUniqueName() {
            return this.id;
        }

        public SimpleString getRoutingName() {
            return this.id;
        }

        public SimpleString getClusterName() {
            return null;
        }

        public Filter getFilter() {
            return null;
        }

        public boolean isHighAcceptPriority(Message message) {
            return false;
        }

        public boolean isExclusive() {
            return false;
        }

        public Long getID() {
            return this.idl;
        }

        public int getDistance() {
            return 0;
        }

        public void route(Message message, RoutingContext context) throws Exception {
        }

        public void close() throws Exception {
        }

        public String toManagementString() {
            return "FakeBiding Address=" + this.address;
        }

        public boolean isConnected() {
            return true;
        }

        public void routeWithAck(Message message, RoutingContext context) {
        }
    }

    class BindingFactoryFake
    implements BindingsFactory {
        BindingFactoryFake() {
        }

        public Bindings createBindings(SimpleString address) throws Exception {
            return new BindingsImpl(address, null);
        }
    }
}

