/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.paging.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagingManagerImplTest
extends ActiveMQTestBase {
    private final ReentrantReadWriteLock.ReadLock lock = new ReentrantReadWriteLock().readLock();

    @Test
    public void testPagingManager() throws Exception {
        HierarchicalObjectRepository addressSettings = new HierarchicalObjectRepository();
        addressSettings.setDefault((Object)new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        NullStorageManager storageManager = new NullStorageManager();
        PagingStoreFactoryNIO storeFactory = new PagingStoreFactoryNIO((StorageManager)storageManager, this.getPageDirFile(), 100L, null, (ExecutorFactory)this.getOrderedExecutor(), true, null);
        PagingManagerImpl managerImpl = new PagingManagerImpl((PagingStoreFactory)storeFactory, (HierarchicalRepository)addressSettings);
        managerImpl.start();
        PagingStore store = managerImpl.getPageStore(new SimpleString("simple-test"));
        ICoreMessage msg = this.createMessage(1L, new SimpleString("simple-test"), this.createRandomBuffer(10));
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assert.assertFalse((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName()), this.lock));
        store.startPaging();
        Assert.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName()), this.lock));
        Page page = store.depage();
        page.open();
        List msgs = page.read((StorageManager)new NullStorageManager());
        page.close(false, false);
        Assert.assertEquals((long)1L, (long)msgs.size());
        ActiveMQTestBase.assertEqualsByteArrays((int)msg.getBodyBuffer().writerIndex(), (byte[])msg.getBodyBuffer().toByteBuffer().array(), (byte[])((PagedMessage)msgs.get(0)).getMessage().toCore().getBodyBuffer().toByteBuffer().array());
        Assert.assertTrue((boolean)store.isPaging());
        Assert.assertNull((Object)store.depage());
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        Assert.assertFalse((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName()), this.lock));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        File fileJournalDir = new File(this.getJournalDir());
        fileJournalDir.mkdirs();
        File pageDirDir = new File(this.getPageDir());
        pageDirDir.mkdirs();
    }

    protected ICoreMessage createMessage(long messageId, SimpleString destination, ByteBuffer buffer) {
        CoreMessage msg = new CoreMessage(messageId, 200);
        msg.setAddress(destination);
        msg.getBodyBuffer().writeBytes(buffer);
        return msg;
    }

    protected ByteBuffer createRandomBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int j = 0; j < buffer.limit(); ++j) {
            buffer.put(RandomUtil.randomByte());
        }
        return buffer;
    }
}

