/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalFileImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class JournaHistorylBackupTest
extends ActiveMQTestBase {
    @Test
    public void testDoubleReplacement() throws Throwable {
        File history = new File(this.getTestDirfile(), "history");
        history.mkdirs();
        File journalFolder = new File(this.getTestDirfile(), "journal");
        journalFolder.mkdirs();
        NIOSequentialFileFactory nioSequentialFileFactory = new NIOSequentialFileFactory(journalFolder, 1);
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)nioSequentialFileFactory, "test", "journal", 1);
        journal.setHistoryFolder(history, -1L, -1L);
        journal.start();
        journal.loadInternalOnly();
        SequentialFile file = nioSequentialFileFactory.createSequentialFile("test-4.journal");
        file.open();
        JournalFileImpl journalFile = journal.readFileHeader(file);
        file.close();
        journalFile.getFile().renameTo(journalFile.getFile().getFileName() + ".bkp");
        journal.stop();
        GregorianCalendar oldCalendar = new GregorianCalendar();
        oldCalendar.setTimeInMillis(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
        String toBeReplacedFileName = journal.getHistoryFileName(journalFile.getFileID(), (Calendar)oldCalendar);
        File historyFile = new File(history, toBeReplacedFileName);
        FileOutputStream outputStream = new FileOutputStream(historyFile);
        outputStream.write(0);
        outputStream.close();
        nioSequentialFileFactory = new NIOSequentialFileFactory(journalFolder, 1);
        journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)nioSequentialFileFactory, "test", "journal", 1);
        journal.setHistoryFolder(history, -1L, -1L);
        journal.start();
        journal.loadInternalOnly();
        File[] fileList = history.listFiles((a, name) -> name.endsWith(".journal"));
        Assert.assertEquals((long)1L, (long)fileList.length);
    }

    @Test
    public void verifyFileName() throws Throwable {
        GregorianCalendar clebertsBirthday = new GregorianCalendar(1972, 1, 19, 4, 5, 7);
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "cleberts", "birthday", 1);
        String fileNameGenerated = journal.getHistoryFileName(1L, (Calendar)clebertsBirthday);
        Assert.assertEquals((Object)"cleberts-19720119040507-1.birthday", (Object)fileNameGenerated);
        Assert.assertEquals((Object)"19720119040507", (Object)journal.getDatePortion(fileNameGenerated));
        long d = journal.getDatePortionMillis(fileNameGenerated);
        GregorianCalendar compareCalendar = new GregorianCalendar();
        compareCalendar.setTimeInMillis(d);
        Assert.assertEquals((long)1972L, (long)compareCalendar.get(1));
        Assert.assertEquals((long)1L, (long)compareCalendar.get(2));
        Assert.assertEquals((long)19L, (long)compareCalendar.get(5));
        Assert.assertEquals((long)4L, (long)compareCalendar.get(11));
        Assert.assertEquals((long)5L, (long)compareCalendar.get(12));
        Assert.assertEquals((long)7L, (long)compareCalendar.get(13));
        Assert.assertFalse((d < clebertsBirthday.getTimeInMillis() ? (byte)1 : 0) != 0);
        compareCalendar.set(1, 1971);
        Assert.assertTrue((compareCalendar.getTimeInMillis() < clebertsBirthday.getTimeInMillis() ? (byte)1 : 0) != 0);
    }

    @Test
    public void removeBKPExtension() throws Throwable {
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "jrn", "data", 1);
        String withoutBkp = "jrn-1.data";
        String withBKP = withoutBkp + ".bkp";
        Assert.assertEquals((Object)withoutBkp, (Object)journal.removeBackupExtension(withBKP));
        Assert.assertEquals((Object)withoutBkp, (Object)journal.removeBackupExtension(withoutBkp));
        String withoutBKP = "jrn-1.data";
    }

    @Test
    public void testFileID() throws Throwable {
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "jrn", "data", 1);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        String fileName = journal.getHistoryFileName(3L, (Calendar)calendar);
        long id = JournalFilesRepository.getFileNameID((String)"jrn", (String)fileName);
        Assert.assertEquals((long)3L, (long)id);
    }

    @Test
    public void testRemoveOldFiles() throws Exception {
        File[] outputStream;
        File file;
        String fileName;
        int i;
        GregorianCalendar todayCalendar = new GregorianCalendar();
        todayCalendar.setTimeInMillis(System.currentTimeMillis());
        File tempFolder = new File(this.getTestDirfile(), "history");
        tempFolder.mkdirs();
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "jrn", "data", 1);
        journal.setHistoryFolder(tempFolder, -1L, TimeUnit.HOURS.toMillis(24L));
        GregorianCalendar dayOlderCalendar = new GregorianCalendar();
        dayOlderCalendar.setTimeInMillis(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(25L));
        for (i = 0; i < 100; ++i) {
            fileName = journal.getHistoryFileName((long)i, (Calendar)dayOlderCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        for (i = 0; i < 100; ++i) {
            fileName = journal.getHistoryFileName((long)i, (Calendar)todayCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        journal.processBackupCleanup();
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".data");
            }
        };
        File[] files = tempFolder.listFiles(fnf);
        Assert.assertEquals((long)100L, (long)files.length);
        HashSet<String> hashSet = new HashSet<String>();
        for (File file2 : files) {
            hashSet.add(file2.getName());
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)hashSet.contains(journal.getHistoryFileName((long)i2, (Calendar)todayCalendar)));
        }
    }

    @Test
    public void testKeepOldFiles() throws Exception {
        int i;
        File[] outputStream;
        File file;
        String fileName;
        int i2;
        GregorianCalendar todayCalendar = new GregorianCalendar();
        todayCalendar.setTimeInMillis(System.currentTimeMillis());
        File tempFolder = new File(this.getTestDirfile(), "history");
        tempFolder.mkdirs();
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "jrn", "data", 1);
        journal.setHistoryFolder(tempFolder, -1L, TimeUnit.HOURS.toMillis(24L));
        GregorianCalendar oldCalendar = new GregorianCalendar();
        oldCalendar.setTimeInMillis(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
        for (i2 = 0; i2 < 100; ++i2) {
            fileName = journal.getHistoryFileName((long)i2, (Calendar)oldCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            fileName = journal.getHistoryFileName((long)i2, (Calendar)todayCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        journal.processBackupCleanup();
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".data");
            }
        };
        File[] files = tempFolder.listFiles(fnf);
        Assert.assertEquals((long)200L, (long)files.length);
        HashSet<String> hashSet = new HashSet<String>();
        for (File file2 : files) {
            hashSet.add(file2.getName());
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)hashSet.contains(journal.getHistoryFileName((long)i, (Calendar)todayCalendar)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)hashSet.contains(journal.getHistoryFileName((long)i, (Calendar)oldCalendar)));
        }
    }

    @Test
    public void testMaxFiles() throws Exception {
        File[] outputStream;
        File file;
        String fileName;
        int i;
        GregorianCalendar todayCalendar = new GregorianCalendar();
        todayCalendar.setTimeInMillis(System.currentTimeMillis());
        File tempFolder = new File(this.getTestDirfile(), "history");
        tempFolder.mkdirs();
        JournalImpl journal = new JournalImpl(10240, 10, 10, 0, 100, (SequentialFileFactory)new FakeSequentialFileFactory(), "jrn", "data", 1);
        journal.setHistoryFolder(tempFolder, (long)(10 * journal.getFileSize()), TimeUnit.HOURS.toMillis(24L));
        GregorianCalendar oldCalendar = new GregorianCalendar();
        oldCalendar.setTimeInMillis(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
        for (i = 0; i < 100; ++i) {
            fileName = journal.getHistoryFileName((long)i, (Calendar)oldCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        for (i = 0; i < 100; ++i) {
            fileName = journal.getHistoryFileName((long)i, (Calendar)todayCalendar);
            file = new File(tempFolder, fileName);
            outputStream = new FileOutputStream(file);
            outputStream.write(0);
            outputStream.close();
        }
        journal.processBackupCleanup();
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".data");
            }
        };
        File[] files = tempFolder.listFiles(fnf);
        Assert.assertEquals((long)10L, (long)files.length);
        HashSet<String> hashSet = new HashSet<String>();
        for (File file2 : files) {
            hashSet.add(file2.getName());
        }
        for (int i2 = 90; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)hashSet.contains(journal.getHistoryFileName((long)i2, (Calendar)todayCalendar)));
        }
    }
}

