/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class AddressQueryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testAddressQueryDefaultsOnStaticAddress() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(addressName));
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        AddressQueryTest.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        AddressQueryTest.assertEquals((long)-1L, (long)addressQueryResult.getDefaultMaxConsumers());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isAutoCreated());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryOnStaticAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.toSimpleString((String)UUID.randomUUID().toString()));
        this.server.addAddressInfo(new AddressInfo(fqqn));
        AddressQueryTest.assertEquals((Object)addressName, (Object)this.server.addressQuery(addressName).getName());
        AddressQueryTest.assertEquals((Object)addressName, (Object)this.server.addressQuery(fqqn).getName());
    }

    @Test
    public void testAddressQueryNonExistentAddress() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
    }

    @Test
    public void testAddressQueryNonExistentAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.toSimpleString((String)UUID.randomUUID().toString()));
        AddressQueryResult addressQueryResult = this.server.addressQuery(fqqn);
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
    }

    @Test
    public void testAddressQueryNonDefaultsOnStaticAddress() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        this.server.addAddressInfo(new AddressInfo(addressName).addRoutingType(RoutingType.ANYCAST));
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        AddressQueryTest.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isAutoCreateAddresses());
        AddressQueryTest.assertEquals((long)1L, (long)addressQueryResult.getDefaultMaxConsumers());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isAutoCreated());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryDefaultsOnAutoCreatedAddress() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings());
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(addressName.toString()), c.createMessage());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        AddressQueryTest.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        AddressQueryTest.assertEquals((long)-1L, (long)addressQueryResult.getDefaultMaxConsumers());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isAutoCreated());
        AddressQueryTest.assertFalse((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryOnAutoCreatedAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.toSimpleString((String)UUID.randomUUID().toString()));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(fqqn.toString()), c.createMessage());
        AddressQueryTest.assertEquals((Object)addressName, (Object)this.server.addressQuery(addressName).getName());
        AddressQueryTest.assertEquals((Object)addressName, (Object)this.server.addressQuery(fqqn).getName());
    }

    @Test
    public void testAddressQueryNonDefaultsOnAutoCreatedAddress() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(addressName.toString()), c.createMessage());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isExists());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        AddressQueryTest.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        AddressQueryTest.assertEquals((long)1L, (long)addressQueryResult.getDefaultMaxConsumers());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isAutoCreated());
        AddressQueryTest.assertTrue((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }
}

