/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"test.ldif"})
public class LDAPSecurityTest
extends AbstractLdapTestUnit {
    private ServerLocator locator;
    ActiveMQServer server;
    public static final String TARGET_TMP = "./target/tmp";
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    @Rule
    public TemporaryFolder temporaryFolder;
    private String testDir;

    public LDAPSecurityTest() {
        File parent = new File(TARGET_TMP);
        parent.mkdirs();
        this.temporaryFolder = new TemporaryFolder(parent);
    }

    @Before
    public void setUp() throws Exception {
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getCanonicalName())});
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("LDAPLogin");
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(true).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getCanonicalName())).setJournalDirectory(ActiveMQTestBase.getJournalDir((String)this.testDir, (int)0, (boolean)false)).setBindingsDirectory(ActiveMQTestBase.getBindingsDir((String)this.testDir, (int)0, (boolean)false)).setPagingDirectory(ActiveMQTestBase.getPageDir((String)this.testDir, (int)0, (boolean)false)).setLargeMessagesDirectory(ActiveMQTestBase.getLargeMessagesDir((String)this.testDir, (int)0, (boolean)false));
        this.server = ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        this.locator.close();
        this.server.stop();
    }

    @Test
    public void testRunning() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        InitialDirContext ctx = new InitialDirContext(env);
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
        ctx.close();
    }

    @Test
    public void testJAASSecurityManagerAuthentication() throws Exception {
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        try {
            ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
        cf.close();
    }

    @Test
    public void testJAASSecurityManagerAuthenticationBadPassword() throws Exception {
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        try {
            cf.createSession("first", "badpassword", false, true, true, false, 0);
            Assert.fail((String)"should throw exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cf.close();
    }

    @Test
    public void testJAASSecurityManagerAuthorizationNegative() throws Exception {
        ClientProducer producer2;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false));
        this.server.getConfiguration().putSecurityRoles("#", roles);
        this.server.start();
        this.server.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        this.server.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.locator.createSessionFactory();
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            producer2 = session.createProducer(ADDRESS);
            producer2.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException producer2) {
            // empty catch block
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException consumer) {
            // empty catch block
        }
        try {
            producer2 = session.createProducer(this.server.getConfiguration().getManagementAddress());
            producer2.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException producer3) {
            // empty catch block
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        session.close();
        cf.close();
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositive() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("admins", true, true, true, true, true, true, true, true, true, true));
        this.server.getConfiguration().putSecurityRoles("#", roles);
        this.server.start();
        ClientSessionFactory cf = this.locator.createSessionFactory();
        ClientSession session = cf.createSession("first", CREDENTIALS, false, true, true, false, 0);
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(this.server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        session.close();
        cf.close();
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = LDAPSecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

