/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.scheduling;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScheduledMessageTest
extends ActiveMQTestBase {
    private final SimpleString atestq = new SimpleString("ascheduledtestq");
    private final SimpleString atestq2 = new SimpleString("ascheduledtestq2");
    private Configuration configuration;
    private ActiveMQServer server;
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    protected void startServer() throws Exception {
        this.configuration = this.createDefaultInVMConfig();
        this.server = this.createServer(true, this.configuration);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testRecoveredMessageDeliveredCorrectly() throws Exception {
        this.testMessageDeliveredCorrectly(true);
    }

    @Test
    public void testMessageDeliveredCorrectly() throws Exception {
        this.testMessageDeliveredCorrectly(false);
    }

    @Test
    public void testScheduledMessagesDeliveredCorrectly() throws Exception {
        this.testScheduledMessagesDeliveredCorrectly(false);
    }

    @Test
    public void testRecoveredScheduledMessagesDeliveredCorrectly() throws Exception {
        this.testScheduledMessagesDeliveredCorrectly(true);
    }

    @Test
    public void testScheduledMessagesDeliveredCorrectlyDifferentOrder() throws Exception {
        this.testScheduledMessagesDeliveredCorrectlyDifferentOrder(false);
    }

    @Test
    public void testRecoveredScheduledMessagesDeliveredCorrectlyDifferentOrder() throws Exception {
        this.testScheduledMessagesDeliveredCorrectlyDifferentOrder(true);
    }

    @Test
    public void testScheduledAndNormalMessagesDeliveredCorrectly() throws Exception {
        this.testScheduledAndNormalMessagesDeliveredCorrectly(false);
    }

    @Test
    public void testRecoveredScheduledAndNormalMessagesDeliveredCorrectly() throws Exception {
        this.testScheduledAndNormalMessagesDeliveredCorrectly(true);
    }

    @Test
    public void testTxMessageDeliveredCorrectly() throws Exception {
        this.testTxMessageDeliveredCorrectly(false);
    }

    @Test
    public void testRecoveredTxMessageDeliveredCorrectly() throws Exception {
        this.testTxMessageDeliveredCorrectly(true);
    }

    @Test
    public void testPagedMessageDeliveredCorrectly() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage message = this.createDurableMessage(session, "m1");
        long time = System.currentTimeMillis();
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 10000L);
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        ClientMessage message2 = consumer.receive(10250L);
        Assert.assertTrue((System.currentTimeMillis() >= time ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message2.getBodyBuffer().readString());
        message2.acknowledge();
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testPagedMessageDeliveredMultipleConsumersCorrectly() throws Exception {
        AddressSettings qs = new AddressSettings().setRedeliveryDelay(5000L);
        this.server.getAddressSettingsRepository().addMatch(this.atestq.toString(), (Object)qs);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        session.createQueue(new QueueConfiguration(this.atestq2).setAddress(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage message = this.createDurableMessage(session, "m1");
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = session.createConsumer(this.atestq);
        ClientConsumer consumer2 = session.createConsumer(this.atestq2);
        session.start();
        ClientMessage message3 = consumer.receive(1000L);
        message3.acknowledge();
        ClientMessage message2 = consumer2.receive(1000L);
        message2.acknowledge();
        Assert.assertEquals((Object)"m1", (Object)message3.getBodyBuffer().readString());
        Assert.assertEquals((Object)"m1", (Object)message2.getBodyBuffer().readString());
        long time = System.currentTimeMillis();
        consumer.close();
        consumer2.close();
        session.rollback();
        consumer = session.createConsumer(this.atestq);
        consumer2 = session.createConsumer(this.atestq2);
        message3 = consumer.receive(5250L);
        message2 = consumer2.receive(1000L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 5000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message3.getBodyBuffer().readString());
        Assert.assertEquals((Object)"m1", (Object)message2.getBodyBuffer().readString());
        message2.acknowledge();
        message3.acknowledge();
        consumer.close();
        consumer2.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testPagedMessageDeliveredMultipleConsumersAfterRecoverCorrectly() throws Exception {
        AddressSettings qs = new AddressSettings().setRedeliveryDelay(5000L);
        this.server.getAddressSettingsRepository().addMatch(this.atestq.toString(), (Object)qs);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        session.createQueue(new QueueConfiguration(this.atestq2).setAddress(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage message = this.createDurableMessage(session, "m1");
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = session.createConsumer(this.atestq);
        ClientConsumer consumer2 = session.createConsumer(this.atestq2);
        session.start();
        ClientMessage message3 = consumer.receive(1000L);
        Assert.assertNotNull((Object)message3);
        message3.acknowledge();
        ClientMessage message2 = consumer2.receive(1000L);
        Assert.assertNotNull((Object)message2);
        message2.acknowledge();
        Assert.assertEquals((Object)"m1", (Object)message3.getBodyBuffer().readString());
        Assert.assertEquals((Object)"m1", (Object)message2.getBodyBuffer().readString());
        long time = System.currentTimeMillis();
        consumer.close();
        consumer2.close();
        session.rollback();
        producer.close();
        session.close();
        this.server.stop();
        this.server = null;
        this.server = this.createServer(true, this.configuration);
        this.server.start();
        sessionFactory = this.createSessionFactory(this.locator);
        session = sessionFactory.createSession(false, true, true);
        consumer = session.createConsumer(this.atestq);
        consumer2 = session.createConsumer(this.atestq2);
        session.start();
        message3 = consumer.receive(5250L);
        Assert.assertNotNull((Object)message3);
        message2 = consumer2.receive(1000L);
        Assert.assertNotNull((Object)message2);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 5000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message3.getBodyBuffer().readString());
        Assert.assertEquals((Object)"m1", (Object)message2.getBodyBuffer().readString());
        message2.acknowledge();
        message3.acknowledge();
        consumer.close();
        consumer2.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    public void testMessageDeliveredCorrectly(boolean recover) throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString("testINVMCoreClient");
        message.setDurable(true);
        long time = System.currentTimeMillis();
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 10000L);
        producer.send((Message)message);
        if (recover) {
            producer.close();
            session.close();
            this.server.stop();
            this.server = null;
            this.server = this.createServer(true, this.configuration);
            this.server.start();
            sessionFactory = this.createSessionFactory(this.locator);
            session = sessionFactory.createSession(false, true, true);
        }
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        ClientMessage message2 = consumer.receive(11000L);
        Assert.assertTrue((System.currentTimeMillis() >= time ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testINVMCoreClient", (Object)message2.getBodyBuffer().readString());
        message2.acknowledge();
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    public void testScheduledMessagesDeliveredCorrectly(boolean recover) throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage m1 = this.createDurableMessage(session, "m1");
        ClientMessage m2 = this.createDurableMessage(session, "m2");
        ClientMessage m3 = this.createDurableMessage(session, "m3");
        ClientMessage m4 = this.createDurableMessage(session, "m4");
        ClientMessage m5 = this.createDurableMessage(session, "m5");
        long time = System.currentTimeMillis();
        m1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 10000L);
        producer.send((Message)m1);
        m2.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m2);
        m3.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m3);
        m4.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m4);
        m5.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m5);
        time -= 4000L;
        if (recover) {
            producer.close();
            session.close();
            this.server.stop();
            this.server = null;
            this.server = this.createServer(true, this.configuration);
            this.server.start();
            sessionFactory = this.createSessionFactory(this.locator);
            session = sessionFactory.createSession(false, true, true);
        }
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        ClientMessage message = consumer.receive(11000L);
        Assert.assertTrue((System.currentTimeMillis() >= time ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m2", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m3", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m4", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m5", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    public void testScheduledMessagesDeliveredCorrectlyDifferentOrder(boolean recover) throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage m1 = this.createDurableMessage(session, "m1");
        ClientMessage m2 = this.createDurableMessage(session, "m2");
        ClientMessage m3 = this.createDurableMessage(session, "m3");
        ClientMessage m4 = this.createDurableMessage(session, "m4");
        ClientMessage m5 = this.createDurableMessage(session, "m5");
        long time = System.currentTimeMillis();
        m1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 10000L);
        producer.send((Message)m1);
        m2.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 3000L);
        producer.send((Message)m2);
        m3.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time -= 2000L);
        producer.send((Message)m3);
        m4.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 3000L);
        producer.send((Message)m4);
        m5.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time -= 2000L);
        producer.send((Message)m5);
        time -= 2000L;
        ClientConsumer consumer = null;
        if (recover) {
            producer.close();
            session.close();
            this.server.stop();
            this.server = null;
            this.server = this.createServer(true, this.configuration);
            this.server.start();
            sessionFactory = this.createSessionFactory(this.locator);
            session = sessionFactory.createSession(false, true, true);
        }
        consumer = session.createConsumer(this.atestq);
        session.start();
        ClientMessage message = consumer.receive(10250L);
        Assert.assertTrue((System.currentTimeMillis() >= time ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m3", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m5", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m2", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m4", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testManyMessagesSameTime() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        long time = System.currentTimeMillis();
        time += 1000L;
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("value", i);
            message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time);
            producer.send((Message)message);
        }
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.atestq);
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = consumer.receive(15000L);
            ScheduledMessageTest.assertNotNull((Object)message);
            message.acknowledge();
            ScheduledMessageTest.assertEquals((long)i, (long)message.getIntProperty("value").intValue());
        }
        session.commit();
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    public void testScheduledAndNormalMessagesDeliveredCorrectly(boolean recover) throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage m1 = this.createDurableMessage(session, "m1");
        ClientMessage m2 = this.createDurableMessage(session, "m2");
        ClientMessage m3 = this.createDurableMessage(session, "m3");
        ClientMessage m4 = this.createDurableMessage(session, "m4");
        ClientMessage m5 = this.createDurableMessage(session, "m5");
        long time = System.currentTimeMillis();
        m1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 10000L);
        producer.send((Message)m1);
        producer.send((Message)m2);
        m3.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m3);
        producer.send((Message)m4);
        m5.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 1000L);
        producer.send((Message)m5);
        time -= 2000L;
        ClientConsumer consumer = null;
        if (recover) {
            producer.close();
            session.close();
            this.server.stop();
            this.server = null;
            this.server = this.createServer(true, this.configuration);
            this.server.start();
            sessionFactory = this.createSessionFactory(this.locator);
            session = sessionFactory.createSession(false, true, true);
        }
        consumer = session.createConsumer(this.atestq);
        session.start();
        ClientMessage message = consumer.receive(1000L);
        Assert.assertEquals((Object)"m2", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1000L);
        Assert.assertEquals((Object)"m4", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(10250L);
        Assert.assertTrue((System.currentTimeMillis() >= time ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m1", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m3", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        message = consumer.receive(1250L);
        Assert.assertTrue((System.currentTimeMillis() >= (time += 1000L) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"m5", (Object)message.getBodyBuffer().readString());
        message.acknowledge();
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    public void testTxMessageDeliveredCorrectly(boolean recover) throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        session.start((Xid)xid, 0);
        ClientProducer producer = session.createProducer(this.atestq);
        ClientMessage message = this.createDurableMessage(session, "testINVMCoreClient");
        long time = System.currentTimeMillis() + 1000L;
        message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time);
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        if (recover) {
            producer.close();
            session.close();
            this.server.stop();
            this.server = null;
            this.server = this.createServer(true, this.configuration);
            this.server.start();
            sessionFactory = this.createSessionFactory(this.locator);
            session = sessionFactory.createSession(true, false, false);
        }
        session.commit((Xid)xid, false);
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        session.start((Xid)xid2, 0);
        ClientMessage message2 = consumer.receive(11000L);
        long end = System.currentTimeMillis();
        Assert.assertTrue((end >= time ? 1 : 0) != 0);
        Assert.assertNotNull((Object)message2);
        Assert.assertEquals((Object)"testINVMCoreClient", (Object)message2.getBodyBuffer().readString());
        message2.acknowledge();
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        consumer.close();
        consumer = session.createConsumer(this.atestq);
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testPendingACKOnPrepared() throws Exception {
        int i;
        int NUMBER_OF_MESSAGES = 100;
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(true, false, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        long scheduled = System.currentTimeMillis() + 1000L;
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("value", i);
            msg.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, scheduled);
            producer.send((Message)msg);
        }
        session.close();
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            XidImpl xid = this.newXID();
            session = sessionFactory.createSession(true, false, false);
            ClientConsumer consumer = session.createConsumer(this.atestq);
            session.start();
            session.start((Xid)xid, 0);
            ClientMessage msg = consumer.receive(5000L);
            ScheduledMessageTest.assertNotNull((Object)msg);
            msg.acknowledge();
            session.end((Xid)xid, 0x4000000);
            session.prepare((Xid)xid);
            session.close();
        }
        sessionFactory.close();
        this.locator.close();
        this.server.stop();
        this.startServer();
        sessionFactory = this.createSessionFactory(this.locator);
        session = sessionFactory.createSession(false, false);
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        ScheduledMessageTest.assertNull((Object)consumer.receive(1000L));
        session.close();
        sessionFactory.close();
    }

    @Test
    public void testScheduledDeliveryTX() throws Exception {
        this.scheduledDelivery(true);
    }

    @Test
    public void testScheduledDeliveryNoTX() throws Exception {
        this.scheduledDelivery(false);
    }

    @Test
    public void testRedeliveryAfterPrepare() throws Exception {
        AddressSettings qs = new AddressSettings().setRedeliveryDelay(5000L);
        this.server.getAddressSettingsRepository().addMatch(this.atestq.toString(), (Object)qs);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("key", i);
            producer.send((Message)msg);
            session.commit();
        }
        session.close();
        session = sessionFactory.createSession(true, false, false);
        ClientConsumer consumer = session.createConsumer(this.atestq);
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>();
        session.start();
        for (int i = 0; i < 100; ++i) {
            XidImpl xid = this.newXID();
            session.start((Xid)xid, 0);
            ClientMessage msg = consumer.receive(5000L);
            ScheduledMessageTest.assertNotNull((Object)msg);
            msg.acknowledge();
            session.end((Xid)xid, 0x4000000);
            session.prepare((Xid)xid);
            xids.add(xid);
        }
        session.rollback((Xid)xids.get(0));
        xids.set(0, null);
        session.close();
        this.server.stop();
        this.configuration = this.createDefaultInVMConfig().addAddressesSetting(this.atestq.toString(), qs);
        this.server = this.createServer(true, this.configuration);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ClientSessionFactory sf = ScheduledMessageTest.this.createSessionFactory(ScheduledMessageTest.this.locator);
                    ClientSession session = sf.createSession(false, false);
                    session.start();
                    ClientConsumer cons = session.createConsumer(ScheduledMessageTest.this.atestq);
                    for (int i = 0; i < 100; ++i) {
                        ClientMessage msg = cons.receive(100000L);
                        Assert.assertNotNull((Object)msg);
                        count.incrementAndGet();
                        msg.acknowledge();
                        session.commit();
                    }
                    session.close();
                    sf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    count.set(-1);
                }
            }
        };
        t.start();
        sessionFactory = this.createSessionFactory(this.locator);
        session = sessionFactory.createSession(true, false, false);
        for (Xid xid : xids) {
            if (xid == null) continue;
            session.rollback(xid);
        }
        session.close();
        t.join();
        ScheduledMessageTest.assertEquals((long)100L, (long)count.get());
    }

    private void scheduledDelivery(boolean tx) throws Exception {
        ActiveMQTestBase.forceGC();
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(tx, false, false);
        session.createQueue(new QueueConfiguration(this.atestq));
        ClientProducer producer = session.createProducer(this.atestq);
        ClientConsumer consumer = session.createConsumer(this.atestq);
        session.start();
        if (tx) {
            session.start((Xid)xid, 0);
        }
        long now = System.currentTimeMillis();
        ClientMessage tm1 = this.createDurableMessage(session, "testScheduled1");
        tm1.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, now + 7000L);
        producer.send((Message)tm1);
        ClientMessage tm2 = this.createDurableMessage(session, "testScheduled2");
        producer.send((Message)tm2);
        ClientMessage tm3 = this.createDurableMessage(session, "testScheduled3");
        producer.send((Message)tm3);
        ClientMessage tm4 = this.createDurableMessage(session, "testScheduled4");
        producer.send((Message)tm4);
        ClientMessage tm5 = this.createDurableMessage(session, "testScheduled5");
        tm5.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, now + 5000L);
        producer.send((Message)tm5);
        ClientMessage tm6 = this.createDurableMessage(session, "testScheduled6");
        tm6.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, now + 4000L);
        producer.send((Message)tm6);
        ClientMessage tm7 = this.createDurableMessage(session, "testScheduled7");
        tm7.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, now + 3000L);
        producer.send((Message)tm7);
        ClientMessage tm8 = this.createDurableMessage(session, "testScheduled8");
        tm8.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, now + 6000L);
        producer.send((Message)tm8);
        ClientMessage tm9 = this.createDurableMessage(session, "testScheduled9");
        tm9.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, -3L);
        producer.send((Message)tm9);
        if (tx) {
            session.end((Xid)xid, 0x4000000);
            session.prepare((Xid)xid);
            session.commit((Xid)xid, false);
        } else {
            session.commit();
        }
        if (tx) {
            session.start((Xid)xid, 0);
        }
        ClientMessage rm1 = consumer.receive(250L);
        Assert.assertNotNull((Object)rm1);
        Assert.assertEquals((Object)"testScheduled2", (Object)rm1.getBodyBuffer().readString());
        ClientMessage rm2 = consumer.receive(250L);
        Assert.assertNotNull((Object)rm2);
        Assert.assertEquals((Object)"testScheduled3", (Object)rm2.getBodyBuffer().readString());
        ClientMessage rm3 = consumer.receive(250L);
        Assert.assertNotNull((Object)rm3);
        Assert.assertEquals((Object)"testScheduled4", (Object)rm3.getBodyBuffer().readString());
        ClientMessage rm5 = consumer.receive(250L);
        Assert.assertNotNull((Object)rm5);
        Assert.assertEquals((Object)"testScheduled9", (Object)rm5.getBodyBuffer().readString());
        ClientMessage rm6 = consumer.receive(3250L);
        Assert.assertNotNull((Object)rm6);
        Assert.assertEquals((Object)"testScheduled7", (Object)rm6.getBodyBuffer().readString());
        long now2 = System.currentTimeMillis();
        Assert.assertTrue((now2 - now >= 3000L ? 1 : 0) != 0);
        ClientMessage rm7 = consumer.receive(1250L);
        Assert.assertNotNull((Object)rm7);
        Assert.assertEquals((Object)"testScheduled6", (Object)rm7.getBodyBuffer().readString());
        now2 = System.currentTimeMillis();
        Assert.assertTrue((now2 - now >= 4000L ? 1 : 0) != 0);
        ClientMessage rm8 = consumer.receive(1250L);
        Assert.assertNotNull((Object)rm8);
        Assert.assertEquals((Object)"testScheduled5", (Object)rm8.getBodyBuffer().readString());
        now2 = System.currentTimeMillis();
        Assert.assertTrue((now2 - now >= 5000L ? 1 : 0) != 0);
        ClientMessage rm9 = consumer.receive(1250L);
        Assert.assertNotNull((Object)rm9);
        Assert.assertEquals((Object)"testScheduled8", (Object)rm9.getBodyBuffer().readString());
        now2 = System.currentTimeMillis();
        Assert.assertTrue((now2 - now >= 6000L ? 1 : 0) != 0);
        ClientMessage rm10 = consumer.receive(1250L);
        Assert.assertNotNull((Object)rm10);
        Assert.assertEquals((Object)"testScheduled1", (Object)rm10.getBodyBuffer().readString());
        now2 = System.currentTimeMillis();
        Assert.assertTrue((now2 - now >= 7000L ? 1 : 0) != 0);
        if (tx) {
            session.end((Xid)xid, 0x4000000);
            session.prepare((Xid)xid);
            session.commit((Xid)xid, false);
        }
        session.close();
        sessionFactory.close();
    }

    private ClientMessage createDurableMessage(ClientSession session, String body) {
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(body);
        return message;
    }
}

