/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BatchDelayTest
extends ActiveMQTestBase {
    private static final int N = 1000;
    private static final long DELAY = 500L;
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("batchDelay", 500L);
        TransportConfiguration tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(tc);
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
    }

    protected ClientSessionFactory createSessionFactory() throws Exception {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("batchDelay", 500L);
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{BatchDelayTest.createTransportConfiguration((boolean)true, (boolean)false, params)});
        this.addServerLocator(locator);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        return this.addSessionFactory(sf);
    }

    @Test
    public void testSendReceiveMany() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory();
        ClientSession session = sf.createSession();
        String foo = "foo";
        session.createQueue(new QueueConfiguration("foo").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("foo");
        ClientConsumer cons = session.createConsumer("foo");
        session.start();
        this.sendMessages(session, prod, 1000);
        this.receiveMessages(cons, 0, 1000, true);
    }

    @Test
    public void testSendReceiveOne() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory();
        ClientSession session = sf.createSession();
        String foo = "foo";
        session.createQueue(new QueueConfiguration("foo").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("foo");
        ClientConsumer cons = session.createConsumer("foo");
        session.start();
        ClientMessage msg = session.createMessage(false);
        prod.send((Message)msg);
        msg = cons.receive(10000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
    }
}

