/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicConnection;
import jakarta.jms.XAConnection;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XASession;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAdapter;
import java.util.HashSet;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapperImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OutgoingConnectionTest
extends ActiveMQRATestBase {
    private ActiveMQResourceAdapter resourceAdapter;
    private ActiveMQRAConnectionFactory qraConnectionFactory;
    private ActiveMQRAManagedConnectionFactory mcf;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();

    @Override
    public boolean useSecurity() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("testuser", "testpassword");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        securityManager.getConfiguration().addRole("testuser", "arole");
        securityManager.getConfiguration().addRole("guest", "arole");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setEntries("[\"java://jmsXA\"]");
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        this.mcf = new ActiveMQRAManagedConnectionFactory();
        this.mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(this.mcf, (ConnectionManager)this.qraConnectionManager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test
    public void testSimpleMessageSendAndReceiveXA() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XAQueueConnection queueConnection = this.qraConnectionFactory.createXAQueueConnection();
        XASession s = queueConnection.createXASession();
        XAResource resource = s.getXAResource();
        resource.start((Xid)xid, 0);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receiveNoWait();
        OutgoingConnectionTest.assertNull((Object)textMessage);
        resource.end((Xid)xid, 0x4000000);
        resource.commit((Xid)xid, true);
        resource.start((Xid)xid, 0);
        textMessage = (TextMessage)consumer.receiveNoWait();
        resource.end((Xid)xid, 0x4000000);
        resource.commit((Xid)xid, true);
        OutgoingConnectionTest.assertNotNull((Object)textMessage);
        OutgoingConnectionTest.assertEquals((Object)textMessage.getText(), (Object)"test");
        textMessage.getJMSDeliveryTime();
    }

    @Test
    public void testInexistentUserOnCreateConnection() throws Exception {
        QueueConnection queueconn2;
        TopicConnection topicconn2;
        XAConnection xaconn2;
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        Connection conn = null;
        try {
            conn = qraConnectionFactory.createConnection("IDont", "Exist");
            OutgoingConnectionTest.fail((String)"Exception was expected");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
        conn = qraConnectionFactory.createConnection("testuser", "testpassword");
        conn.close();
        try {
            xaconn2 = qraConnectionFactory.createXAConnection("IDont", "Exist");
            OutgoingConnectionTest.fail((String)"Exception was expected");
        }
        catch (JMSSecurityException xaconn2) {
            // empty catch block
        }
        xaconn2 = qraConnectionFactory.createXAConnection("testuser", "testpassword");
        xaconn2.close();
        try {
            topicconn2 = qraConnectionFactory.createTopicConnection("IDont", "Exist");
            OutgoingConnectionTest.fail((String)"Exception was expected");
        }
        catch (JMSSecurityException topicconn2) {
            // empty catch block
        }
        topicconn2 = qraConnectionFactory.createTopicConnection("testuser", "testpassword");
        topicconn2.close();
        try {
            queueconn2 = qraConnectionFactory.createQueueConnection("IDont", "Exist");
            OutgoingConnectionTest.fail((String)"Exception was expected");
        }
        catch (JMSSecurityException queueconn2) {
            // empty catch block
        }
        queueconn2 = qraConnectionFactory.createQueueConnection("testuser", "testpassword");
        queueconn2.close();
        mcf.stop();
    }

    @Test
    public void testMultipleSessionsThrowsException() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(false, 1);
        try {
            Session s2 = queueConnection.createSession(false, 1);
            OutgoingConnectionTest.fail((String)"should throw javax,jms.IllegalStateException: Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectionCredentials() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        QueueSession session = queueConnection.createQueueSession(false, 1);
        queueConnection = qraConnectionFactory.createQueueConnection("testuser", "testpassword");
        session = queueConnection.createQueueSession(false, 1);
    }

    @Test
    public void testConnectionCredentialsFail() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        QueueSession session = queueConnection.createQueueSession(false, 1);
        ManagedConnection mc = ((ActiveMQRASession)session).getManagedConnection();
        queueConnection.close();
        mc.destroy();
        try {
            queueConnection = qraConnectionFactory.createQueueConnection("testuser", "testwrongpassword");
            queueConnection.createQueueSession(false, 1).close();
            OutgoingConnectionTest.fail((String)"should throw esxception");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectionCredentialsFailRecovery() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        try {
            QueueConnection queueConnection = qraConnectionFactory.createQueueConnection("testuser", "testwrongpassword");
            queueConnection.createQueueSession(false, 1).close();
            OutgoingConnectionTest.fail((String)"should throw esxception");
        }
        catch (JMSException e) {
            OutgoingConnectionTest.assertNull((Object)mcf.getResourceRecovery());
        }
    }

    @Test
    public void testConnectionCredentialsOKRecovery() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        QueueSession session = queueConnection.createQueueSession(false, 1);
        OutgoingConnectionTest.assertNotNull((Object)mcf.getResourceRecovery());
    }

    @Test
    public void testJMSContext() throws Exception {
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        JMSContext jmsctx = qraConnectionFactory.createContext(3);
        OutgoingConnectionTest.assertEquals((long)3L, (long)jmsctx.getSessionMode());
    }

    @Test
    public void testOutgoingXAResourceWrapper() throws Exception {
        XAQueueConnection queueConnection = this.qraConnectionFactory.createXAQueueConnection();
        XASession s = queueConnection.createXASession();
        XAResource resource = s.getXAResource();
        OutgoingConnectionTest.assertTrue((boolean)(resource instanceof ActiveMQXAResourceWrapper));
        ActiveMQXAResourceWrapperImpl xaResourceWrapper = (ActiveMQXAResourceWrapperImpl)resource;
        OutgoingConnectionTest.assertTrue((boolean)xaResourceWrapper.getJndiName().equals("java://jmsXA NodeId:" + this.server.getNodeID()));
        OutgoingConnectionTest.assertTrue((boolean)xaResourceWrapper.getProductVersion().equals(VersionLoader.getVersion().getFullVersion()));
        OutgoingConnectionTest.assertTrue((boolean)xaResourceWrapper.getProductName().equals("ActiveMQ Artemis"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedActiveMQConnectionFactory() throws Exception {
        Session s = null;
        Session s2 = null;
        ActiveMQRAManagedConnection mc = null;
        ActiveMQRAManagedConnection mc2 = null;
        try {
            this.resourceAdapter = new ActiveMQResourceAdapter();
            this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
            ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
            this.resourceAdapter.start((BootstrapContext)ctx);
            ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();
            ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
            mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
            ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)qraConnectionManager);
            QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
            s = queueConnection.createSession(false, 1);
            mc = (ActiveMQRAManagedConnection)((ActiveMQRASession)s).getManagedConnection();
            ActiveMQConnectionFactory cf1 = mc.getConnectionFactory();
            QueueConnection queueConnection2 = qraConnectionFactory.createQueueConnection();
            s2 = queueConnection2.createSession(false, 1);
            mc2 = (ActiveMQRAManagedConnection)((ActiveMQRASession)s2).getManagedConnection();
            ActiveMQConnectionFactory cf2 = mc2.getConnectionFactory();
            OutgoingConnectionTest.assertTrue((cf1 == cf2 ? (byte)1 : 0) != 0);
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (mc != null) {
                mc.destroy();
            }
            if (s2 != null) {
                s2.close();
            }
            if (mc2 != null) {
                mc2.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedActiveMQConnectionFactoryWithClose() throws Exception {
        Session s = null;
        Session s2 = null;
        ActiveMQRAManagedConnection mc = null;
        ActiveMQRAManagedConnection mc2 = null;
        try {
            this.server.getConfiguration().setSecurityEnabled(false);
            this.resourceAdapter = new ActiveMQResourceAdapter();
            this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
            ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
            this.resourceAdapter.start((BootstrapContext)ctx);
            ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();
            ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
            mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
            ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)qraConnectionManager);
            QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
            s = queueConnection.createSession(false, 1);
            mc = (ActiveMQRAManagedConnection)((ActiveMQRASession)s).getManagedConnection();
            QueueConnection queueConnection2 = qraConnectionFactory.createQueueConnection();
            s2 = queueConnection2.createSession(false, 1);
            mc2 = (ActiveMQRAManagedConnection)((ActiveMQRASession)s2).getManagedConnection();
            mc.destroy();
            MessageProducer producer = s2.createProducer((Destination)ActiveMQJMSClient.createQueue((String)"mdbQueue"));
            producer.send((Message)s2.createTextMessage("x"));
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (mc != null) {
                mc.destroy();
            }
            if (s2 != null) {
                s2.close();
            }
            if (mc2 != null) {
                mc2.destroy();
            }
        }
    }
}

