/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.XAJMSContext;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.transaction.TransactionManager;
import java.util.HashSet;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransaction;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JMSContextTest
extends ActiveMQRATestBase {
    private ActiveMQResourceAdapter resourceAdapter;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();
    private ActiveMQRAConnectionFactory qraConnectionFactory;

    public TransactionManager getTm() {
        return DummyTransactionManager.tm;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.useDummyTransactionManager();
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("testuser", "testpassword");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        securityManager.getConfiguration().addRole("testuser", "arole");
        securityManager.getConfiguration().addRole("guest", "arole");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        DummyTransactionManager.tm.tx = null;
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test
    public void testCreateContextThrowsException() throws Exception {
        JMSContext jmsctx = this.qraConnectionFactory.createContext();
        try {
            jmsctx.createContext(1);
            JMSContextTest.fail((String)"expected JMSRuntimeException");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
        }
        catch (Exception e) {
            JMSContextTest.fail((String)("wrong exception thrown: " + e));
        }
    }

    @Test
    public void testCreateXAContextThrowsException() throws Exception {
        XAJMSContext jmsctx = this.qraConnectionFactory.createXAContext();
        try {
            jmsctx.createContext(1);
            JMSContextTest.fail((String)"expected JMSRuntimeException");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
        }
        catch (Exception e) {
            JMSContextTest.fail((String)("wrong exception thrown: " + e));
        }
    }

    @Test
    public void sessionTransactedTestActiveJTATx() throws Exception {
        try {
            this.qraConnectionFactory.createContext(0);
            JMSContextTest.fail();
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void sessionTransactedTestNoActiveJTATx() throws Exception {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = new DummyTransaction();
        JMSContext context = this.qraConnectionFactory.createContext(0);
        JMSContextTest.assertEquals((long)context.getSessionMode(), (long)1L);
    }

    @Test
    public void clientAckTestActiveJTATx() throws Exception {
        try {
            this.qraConnectionFactory.createContext(2);
            JMSContextTest.fail();
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void clientAckTestNoActiveJTATx() throws Exception {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = new DummyTransaction();
        JMSContext context = this.qraConnectionFactory.createContext(2);
        JMSContextTest.assertEquals((long)context.getSessionMode(), (long)1L);
    }

    @Test
    public void testJMSContextConsumerThrowsMessageFormatExceptionOnMalformedBody() throws Exception {
        Queue queue = this.createQueue(true, "ContextMalformedBodyTestQueue");
        JMSContext context = this.qraConnectionFactory.createContext();
        JMSProducer producer = context.createProducer();
        TextMessage message = context.createTextMessage("TestMessage");
        producer.send((Destination)queue, (Message)message);
        JMSConsumer consumer = context.createConsumer((Destination)queue);
        try {
            consumer.receiveBody(Boolean.class);
            JMSContextTest.fail((String)"Should thrown MessageFormatException");
        }
        catch (MessageFormatRuntimeException messageFormatRuntimeException) {
        }
        catch (Exception e) {
            JMSContextTest.fail((String)("Threw wrong exception, should be MessageFormatRuntimeException, instead got: " + e.getClass().getCanonicalName()));
        }
    }
}

