/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import java.util.HashMap;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.junit.Before;

public class ActiveMQRAClusteredTestBase
extends ActiveMQRATestBase {
    protected ActiveMQServer secondaryServer;
    protected JMSServerManagerImpl secondaryJmsServer;
    protected TransportConfiguration secondaryConnector;
    protected TransportConfiguration primaryConnector;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.primaryConnector = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverId", "1");
        this.secondaryConnector = new TransportConfiguration(INVM_CONNECTOR_FACTORY, params);
        this.secondaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createSecondaryDefaultConfig(true), (MBeanServer)this.mbeanServer, (boolean)this.usePersistence()));
        this.addServer(this.secondaryServer);
        this.secondaryJmsServer = new JMSServerManagerImpl(this.secondaryServer);
        this.secondaryJmsServer.start();
        ActiveMQRAClusteredTestBase.waitForTopology((ActiveMQServer)this.secondaryServer, (int)2);
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return this.createSecondaryDefaultConfig(false);
    }

    protected Configuration createSecondaryDefaultConfig(boolean secondary) throws Exception {
        HashMap<String, String> invmMap = new HashMap<String, String>();
        HashMap<String, String> nettyMap = new HashMap<String, String>();
        String primaryConnectorName = "invm2";
        String secondaryConnectorName = "invm";
        int index = 0;
        if (secondary) {
            invmMap.put("serverId", "1");
            nettyMap.put("port", "5545");
            primaryConnectorName = "invm";
            secondaryConnectorName = "invm2";
            index = 1;
        }
        ConfigurationImpl configuration = this.createBasicConfig(index).setJMXManagementEnabled(false).clearAcceptorConfigurations().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, invmMap)).addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, nettyMap)).addConnectorConfiguration(secondaryConnectorName, this.secondaryConnector).addConnectorConfiguration(primaryConnectorName, this.primaryConnector).addClusterConfiguration(ActiveMQRAClusteredTestBase.basicClusterConnectionConfig((String)secondaryConnectorName, (String[])new String[]{primaryConnectorName}).setReconnectAttempts(0));
        this.recreateDataDirectories(this.getTestDir(), index, false);
        return configuration;
    }

    @Override
    protected boolean usePersistence() {
        return true;
    }
}

