/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class ConfigChangeTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Test
    public void testChangeQueueRoutingTypeOnRestart() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig();
        configuration.addAddressesSetting("#", new AddressSettings());
        ArrayList<CoreAddressConfiguration> addressConfigurations = new ArrayList<CoreAddressConfiguration>();
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(new QueueConfiguration("myQueue").setAddress("myAddress").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server = this.createServer(true, configuration);
        this.server.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (JMSContext context = connectionFactory.createContext();){
            context.createProducer().send((Destination)context.createQueue("myAddress"), "hello");
        }
        this.server.stop();
        addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.MULTICAST).addQueueConfiguration(new QueueConfiguration("myQueue").setAddress("myAddress").setRoutingType(RoutingType.MULTICAST));
        addressConfigurations.clear();
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server.start();
        ConfigChangeTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"myAddress")).getRoutingType());
        ConfigChangeTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.locateQueue(SimpleString.toSimpleString((String)"myQueue")).getRoutingType());
        context = connectionFactory.createContext();
        var6_6 = null;
        try {
            Message message = context.createSharedDurableConsumer(context.createTopic("myAddress"), "myQueue").receive();
            ConfigChangeTest.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (context != null) {
                if (var6_6 != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    context.close();
                }
            }
        }
        this.server.stop();
    }

    @Test
    public void testChangeQueueFilterOnRestart() throws Exception {
        String filter1 = "x = 'x'";
        String filter2 = "x = 'y'";
        Configuration configuration = this.createDefaultInVMConfig();
        configuration.addAddressesSetting("#", new AddressSettings());
        ArrayList<CoreAddressConfiguration> addressConfigurations = new ArrayList<CoreAddressConfiguration>();
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(new QueueConfiguration("myQueue").setAddress("myAddress").setFilterString("x = 'x'").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server = this.createServer(true, configuration);
        this.server.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (JMSContext context = connectionFactory.createContext();){
            context.createProducer().setProperty("x", "x").send((Destination)context.createQueue("myAddress"), "hello");
        }
        long originalBindingId = this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myQueue")).getID();
        this.server.stop();
        addressConfiguration = new CoreAddressConfiguration().setName("myAddress").addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(new QueueConfiguration("myQueue").setAddress("myAddress").setFilterString("x = 'y'").setRoutingType(RoutingType.ANYCAST));
        addressConfigurations.clear();
        addressConfigurations.add(addressConfiguration);
        configuration.setAddressConfigurations(addressConfigurations);
        this.server.start();
        ConfigChangeTest.assertEquals((Object)"x = 'y'", (Object)this.server.locateQueue(SimpleString.toSimpleString((String)"myQueue")).getFilter().getFilterString().toString());
        try (JMSContext context = connectionFactory.createContext();){
            Message message = context.createConsumer((Destination)context.createQueue("myAddress::myQueue")).receive();
            ConfigChangeTest.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
        }
        long bindingId = this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myQueue")).getID();
        ConfigChangeTest.assertEquals((String)"Ensure the original queue is not destroyed by checking the binding id is the same", (long)originalBindingId, (long)bindingId);
        this.server.stop();
    }
}

