/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Before;
import org.junit.Test;

public class QueueConsumerPriorityTest
extends BasicOpenWireTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.makeSureCoreQueueExist("QUEUE.A");
    }

    @Test
    public void testQueueConsumerPriority() throws JMSException, InterruptedException {
        this.connection.start();
        Session consumerLowPriority = this.connection.createSession(false, 1);
        Session consumerHighPriority = this.connection.createSession(false, 1);
        QueueConsumerPriorityTest.assertNotNull((Object)consumerHighPriority);
        Session senderSession = this.connection.createSession(false, 1);
        String queueName = "QUEUE.A";
        ActiveMQQueue low = new ActiveMQQueue(queueName + "?consumer.priority=1");
        MessageConsumer lowConsumer = consumerLowPriority.createConsumer((Destination)low);
        ActiveMQQueue high = new ActiveMQQueue(queueName + "?consumer.priority=2");
        MessageConsumer highConsumer = consumerLowPriority.createConsumer((Destination)high);
        ActiveMQQueue senderQueue = new ActiveMQQueue(queueName);
        MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
        TextMessage msg = senderSession.createTextMessage("test");
        for (int i = 0; i < 1000; ++i) {
            producer.send((Message)msg);
            QueueConsumerPriorityTest.assertNotNull((String)("null on iteration: " + i), (Object)highConsumer.receive(1000L));
        }
        QueueConsumerPriorityTest.assertNull((Object)lowConsumer.receive(250L));
    }
}

