/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Test;

public class JmsCreateConsumerInOnMessageTest
extends BasicOpenWireTest
implements MessageListener {
    private Session publisherSession;
    private Session consumerSession;
    private MessageConsumer consumer;
    private MessageConsumer testConsumer;
    private MessageProducer producer;
    private Topic topic;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateConsumer() throws Exception {
        this.connection.setClientID("connection:JmsCreateConsumerInOnMessageTest");
        this.publisherSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(false, 1);
        this.topic = (Topic)super.createDestination(this.consumerSession, (byte)2);
        this.consumer = this.consumerSession.createConsumer((Destination)this.topic);
        this.consumer.setMessageListener((MessageListener)this);
        this.producer = this.publisherSession.createProducer((Destination)this.topic);
        this.connection.start();
        Message msg = this.publisherSession.createMessage();
        this.producer.send(msg);
        Object object = this.lock;
        synchronized (object) {
            long timeout = System.currentTimeMillis() + 3000L;
            while (this.testConsumer == null && timeout > System.currentTimeMillis()) {
                this.lock.wait(1000L);
            }
        }
        JmsCreateConsumerInOnMessageTest.assertTrue((this.testConsumer != null ? (byte)1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.testConsumer = this.consumerSession.createConsumer((Destination)this.topic);
                this.consumerSession.createProducer((Destination)this.topic);
                this.lock.notify();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JmsCreateConsumerInOnMessageTest.assertTrue((boolean)false);
        }
    }
}

