/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TempQueueWithDotTest
extends BasicOpenWireTest {
    private static final Logger log = Logger.getLogger(TempQueueWithDotTest.class);

    protected Configuration createDefaultConfig(int serverID, boolean netty) throws Exception {
        Configuration configuration = super.createDefaultConfig(serverID, netty);
        configuration.getWildcardConfiguration().setDelimiter('_');
        return configuration;
    }

    @Test
    public void testSimple() throws Exception {
        this.testSimple("OPENWIRE");
        this.testSimple("CORE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimple(String protocol) throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, this.getConnectionUrl());
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue dest = session.createTemporaryQueue();
            String queueName = dest.getQueueName();
            Wait.waitFor(() -> this.server.locateQueue(queueName) != null);
            Queue queue = this.server.locateQueue(queueName);
            MessageConsumer consumer = null;
            try {
                consumer = session.createConsumer((Destination)dest);
            }
            catch (Exception e) {
                e.printStackTrace();
                TempQueueWithDotTest.fail((String)e.getMessage());
            }
            MessageProducer producer = session.createProducer((Destination)dest);
            producer.send((Message)session.createTextMessage("hello"));
            Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
            connection.start();
            Assert.assertNotNull((Object)consumer.receive(500L));
        }
    }
}

