/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.AddressSettingsInfo;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.RoleInfo;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.unit.core.config.impl.fakes.FakeConnectorServiceFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.RetryMethod;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQServerControlTest
extends ManagementTestBase {
    private static final Logger log = Logger.getLogger(ActiveMQServerControlTest.class);
    @Rule
    public RetryRule retryRule = new RetryRule(0);
    protected boolean legacyCreateQueue;
    private ActiveMQServer server;
    private Configuration conf;
    private TransportConfiguration connectorConfig;

    @Parameterized.Parameters(name="legacyCreateQueue={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public ActiveMQServerControlTest(boolean legacyCreateQueue) {
        this.legacyCreateQueue = legacyCreateQueue;
    }

    private static boolean contains(String name, String[] strings) {
        boolean found = false;
        for (String str : strings) {
            if (!name.equals(str)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean usingCore() {
        return false;
    }

    @Test
    public void testGetAttributes() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertEquals((Object)this.server.getVersion().getFullVersion(), (Object)serverControl.getVersion());
        Assert.assertEquals((Object)this.conf.isClustered(), (Object)serverControl.isClustered());
        Assert.assertEquals((Object)this.conf.isPersistDeliveryCountBeforeDelivery(), (Object)serverControl.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((long)this.conf.getScheduledThreadPoolMaxSize(), (long)serverControl.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)this.conf.getThreadPoolMaxSize(), (long)serverControl.getThreadPoolMaxSize());
        Assert.assertEquals((long)this.conf.getSecurityInvalidationInterval(), (long)serverControl.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)this.conf.isSecurityEnabled(), (Object)serverControl.isSecurityEnabled());
        Assert.assertEquals((Object)this.conf.isAsyncConnectionExecutionEnabled(), (Object)serverControl.isAsyncConnectionExecutionEnabled());
        Assert.assertEquals((long)this.conf.getIncomingInterceptorClassNames().size(), (long)serverControl.getIncomingInterceptorClassNames().length);
        Assert.assertEquals((long)this.conf.getIncomingInterceptorClassNames().size(), (long)serverControl.getIncomingInterceptorClassNames().length);
        Assert.assertEquals((long)this.conf.getOutgoingInterceptorClassNames().size(), (long)serverControl.getOutgoingInterceptorClassNames().length);
        Assert.assertEquals((long)this.conf.getConnectionTTLOverride(), (long)serverControl.getConnectionTTLOverride());
        Assert.assertEquals((Object)this.conf.getManagementAddress().toString(), (Object)serverControl.getManagementAddress());
        Assert.assertEquals((Object)this.conf.getManagementNotificationAddress().toString(), (Object)serverControl.getManagementNotificationAddress());
        Assert.assertEquals((long)this.conf.getIDCacheSize(), (long)serverControl.getIDCacheSize());
        Assert.assertEquals((Object)this.conf.isPersistIDCache(), (Object)serverControl.isPersistIDCache());
        Assert.assertEquals((Object)this.conf.getBindingsDirectory(), (Object)serverControl.getBindingsDirectory());
        Assert.assertEquals((Object)this.conf.getJournalDirectory(), (Object)serverControl.getJournalDirectory());
        Assert.assertEquals((Object)this.conf.getJournalType().toString(), (Object)serverControl.getJournalType());
        Assert.assertEquals((Object)this.conf.isJournalSyncTransactional(), (Object)serverControl.isJournalSyncTransactional());
        Assert.assertEquals((Object)this.conf.isJournalSyncNonTransactional(), (Object)serverControl.isJournalSyncNonTransactional());
        Assert.assertEquals((long)this.conf.getJournalFileSize(), (long)serverControl.getJournalFileSize());
        Assert.assertEquals((long)this.conf.getJournalMinFiles(), (long)serverControl.getJournalMinFiles());
        if (LibaioContext.isLoaded()) {
            Assert.assertEquals((long)this.conf.getJournalMaxIO_AIO(), (long)serverControl.getJournalMaxIO());
            Assert.assertEquals((long)this.conf.getJournalBufferSize_AIO(), (long)serverControl.getJournalBufferSize());
            Assert.assertEquals((long)this.conf.getJournalBufferTimeout_AIO(), (long)serverControl.getJournalBufferTimeout());
        }
        Assert.assertEquals((Object)this.conf.isCreateBindingsDir(), (Object)serverControl.isCreateBindingsDir());
        Assert.assertEquals((Object)this.conf.isCreateJournalDir(), (Object)serverControl.isCreateJournalDir());
        Assert.assertEquals((Object)this.conf.getPagingDirectory(), (Object)serverControl.getPagingDirectory());
        Assert.assertEquals((Object)this.conf.getLargeMessagesDirectory(), (Object)serverControl.getLargeMessagesDirectory());
        Assert.assertEquals((Object)this.conf.isWildcardRoutingEnabled(), (Object)serverControl.isWildcardRoutingEnabled());
        Assert.assertEquals((long)this.conf.getTransactionTimeout(), (long)serverControl.getTransactionTimeout());
        Assert.assertEquals((Object)this.conf.isMessageCounterEnabled(), (Object)serverControl.isMessageCounterEnabled());
        Assert.assertEquals((long)this.conf.getTransactionTimeoutScanPeriod(), (long)serverControl.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)this.conf.getMessageExpiryScanPeriod(), (long)serverControl.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)this.conf.getJournalCompactMinFiles(), (long)serverControl.getJournalCompactMinFiles());
        Assert.assertEquals((long)this.conf.getJournalCompactPercentage(), (long)serverControl.getJournalCompactPercentage());
        Assert.assertEquals((Object)this.conf.isPersistenceEnabled(), (Object)serverControl.isPersistenceEnabled());
        Assert.assertEquals((long)this.conf.getJournalPoolFiles(), (long)serverControl.getJournalPoolFiles());
        Assert.assertTrue((boolean)serverControl.isActive());
    }

    @Test
    public void testSecurityCacheSizes() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertEquals((long)(this.usingCore() ? 1L : 0L), (long)serverControl.getAuthenticationCacheSize());
        Assert.assertEquals((long)(this.usingCore() ? 7L : 0L), (long)serverControl.getAuthorizationCacheSize());
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession session = csf.createSession("myUser", "myPass", false, true, false, false, 0);
        session.start();
        String address = "ADDRESS";
        serverControl.createAddress("ADDRESS", "MULTICAST");
        ClientProducer producer = session.createProducer("ADDRESS");
        ClientMessage m = session.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((Message)m);
        Assert.assertEquals((long)(this.usingCore() ? 2L : 1L), (long)serverControl.getAuthenticationCacheSize());
        Assert.assertEquals((long)(this.usingCore() ? 8L : 1L), (long)serverControl.getAuthorizationCacheSize());
    }

    @Test
    public void testGetConnectors() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Object[] connectorData = serverControl.getConnectors();
        Assert.assertNotNull((Object)connectorData);
        Assert.assertEquals((long)1L, (long)connectorData.length);
        Object[] config = (Object[])connectorData[0];
        Assert.assertEquals((Object)this.connectorConfig.getName(), (Object)config[0]);
    }

    @Test
    public void testIsReplicaSync() throws Exception {
        Assert.assertFalse((boolean)this.createManagementControl().isReplicaSync());
    }

    @Test
    public void testGetConnectorsAsJSON() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String jsonString = serverControl.getConnectorsAsJSON();
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        JsonObject data = array.getJsonObject(0);
        Assert.assertEquals((Object)this.connectorConfig.getName(), (Object)data.getString("name"));
        Assert.assertEquals((Object)this.connectorConfig.getFactoryClassName(), (Object)data.getString("factoryClassName"));
        Assert.assertEquals((long)this.connectorConfig.getParams().size(), (long)data.getJsonObject("params").size());
    }

    @Test
    public void testCreateAndDestroyQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)true, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateQueueWithNullAddress() throws Exception {
        SimpleString address;
        SimpleString name = address = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(null, name.toString(), "ANYCAST");
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(name, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)true, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndDestroyQueue_2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = "color = 'green'";
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertEquals((Object)filter, (Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndDestroyQueue_3() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndDestroyQueue_4() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        boolean purgeOnNoConsumers = RandomUtil.randomBoolean();
        boolean autoCreateAddress = true;
        int maxConsumers = RandomUtil.randomInt();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), name.toString(), null, durable, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setAutoCreateAddress(Boolean.valueOf(autoCreateAddress)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)purgeOnNoConsumers, (Object)queueControl.isPurgeOnNoConsumers());
        Assert.assertEquals((long)maxConsumers, (long)queueControl.getMaxConsumers());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        this.checkResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        serverControl.destroyQueue(name.toString(), true, true);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
    }

    @Test
    public void testCreateAndDestroyQueue_5() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        int maxConsumers = RandomUtil.randomInt();
        boolean purgeOnNoConsumers = RandomUtil.randomBoolean();
        boolean exclusive = RandomUtil.randomBoolean();
        boolean groupRebalance = RandomUtil.randomBoolean();
        int groupBuckets = 1;
        String groupFirstKey = RandomUtil.randomSimpleString().toString();
        boolean lastValue = false;
        String lastValueKey = null;
        boolean nonDestructive = RandomUtil.randomBoolean();
        int consumersBeforeDispatch = RandomUtil.randomInt();
        long delayBeforeDispatch = RandomUtil.randomLong();
        boolean autoDelete = RandomUtil.randomBoolean();
        long autoDeleteDelay = RandomUtil.randomLong();
        long autoDeleteMessageCount = RandomUtil.randomLong();
        boolean autoCreateAddress = true;
        long ringSize = RandomUtil.randomLong();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), name.toString(), null, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, ringSize);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setExclusive(Boolean.valueOf(exclusive)).setGroupRebalance(Boolean.valueOf(groupRebalance)).setGroupBuckets(Integer.valueOf(groupBuckets)).setGroupFirstKey(groupFirstKey).setLastValue(Boolean.valueOf(lastValue)).setLastValueKey(lastValueKey).setNonDestructive(Boolean.valueOf(nonDestructive)).setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(autoDelete)).setAutoDeleteDelay(Long.valueOf(autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(autoDeleteMessageCount)).setRingSize(Long.valueOf(ringSize)).setAutoCreateAddress(Boolean.valueOf(autoCreateAddress)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((long)maxConsumers, (long)queueControl.getMaxConsumers());
        Assert.assertEquals((Object)purgeOnNoConsumers, (Object)queueControl.isPurgeOnNoConsumers());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        Assert.assertEquals((Object)exclusive, (Object)queueControl.isExclusive());
        Assert.assertEquals((Object)groupRebalance, (Object)queueControl.isGroupRebalance());
        Assert.assertEquals((long)groupBuckets, (long)queueControl.getGroupBuckets());
        Assert.assertEquals((Object)groupFirstKey, (Object)queueControl.getGroupFirstKey());
        Assert.assertEquals((Object)lastValue, (Object)queueControl.isLastValue());
        Assert.assertEquals((long)ringSize, (long)queueControl.getRingSize());
        this.checkResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        serverControl.destroyQueue(name.toString(), true, true);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
    }

    @Test
    public void testRemoveQueueFilter() throws Exception {
        String address = RandomUtil.randomString();
        QueueConfiguration queue1 = new QueueConfiguration("q1").setAddress(address).setFilterString("hello='world'");
        QueueConfiguration queue2 = new QueueConfiguration("q2").setAddress(address).setFilterString("hello='darling'");
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.createAddress(address, "MULTICAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address, queue1.getName().toString(), queue1.getFilterString().toString(), queue1.isDurable().booleanValue());
            serverControl.createQueue(address, queue2.getName().toString(), queue2.getFilterString().toString(), queue2.isDurable().booleanValue());
        } else {
            serverControl.createQueue(queue1.toJSON());
            serverControl.createQueue(queue2.toJSON());
        }
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession session = csf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(address);
        ClientConsumer consumer1 = session.createConsumer("q1");
        ClientConsumer consumer2 = session.createConsumer("q2");
        ClientMessage m = session.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((Message)m);
        ActiveMQServerControlTest.assertNotNull((Object)consumer1.receiveImmediate());
        ActiveMQServerControlTest.assertNull((Object)consumer2.receiveImmediate());
        serverControl.updateQueue(queue2.setFilterString((String)null).toJSON());
        producer.send((Message)m);
        ActiveMQServerControlTest.assertNotNull((Object)consumer1.receive(1000L));
        ActiveMQServerControlTest.assertNotNull((Object)consumer2.receive(1000L));
    }

    @Test
    public void testCreateAndDestroyQueueClosingConsumers() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        final ClientConsumer consumer = receiveClientSession.createConsumer(name);
        Assert.assertFalse((boolean)consumer.isClosed());
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.destroyQueue(name.toString(), true);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return consumer.isClosed();
            }
        }, (long)1000L, (long)100L);
        Assert.assertTrue((boolean)consumer.isClosed());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndDestroyQueueWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = null;
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndDestroyQueueWithEmptyStringForFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = "";
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assert.assertEquals((Object)false, (Object)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @Test
    public void testCreateAndUpdateQueueWithoutFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)).setFilterString((String)null).toJSON());
        serverControl.updateQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).toJSON());
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assert.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assert.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assert.assertNull((Object)queueControl.getFilter());
        Assert.assertEquals((long)1L, (long)queueControl.getMaxConsumers());
        serverControl.destroyQueue(name.toString());
    }

    @Test
    public void testGetQueueCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        int countBeforeCreate = serverControl.getQueueCount();
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        Assert.assertTrue((countBeforeCreate < serverControl.getQueueCount() ? (byte)1 : 0) != 0);
        serverControl.destroyQueue(name.toString());
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
    }

    @Test
    public void testGetQueueNames() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        serverControl.destroyQueue(name.toString());
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
    }

    @Test
    public void testGetQueueNamesWithRoutingType() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString anycastName = RandomUtil.randomSimpleString();
        SimpleString multicastName = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames()));
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames()));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), anycastName.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(new QueueConfiguration(anycastName).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames(RoutingType.ANYCAST.toString())));
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames(RoutingType.MULTICAST.toString())));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.MULTICAST.toString(), multicastName.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(new QueueConfiguration(multicastName).setAddress(address).setRoutingType(RoutingType.MULTICAST).toJSON());
        }
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames(RoutingType.MULTICAST.toString())));
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames(RoutingType.ANYCAST.toString())));
        serverControl.destroyQueue(anycastName.toString());
        serverControl.destroyQueue(multicastName.toString());
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames()));
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames()));
    }

    @Test
    public void testGetClusterConnectionNames() throws Exception {
        String clusterConnection1 = RandomUtil.randomString();
        String clusterConnection2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(clusterConnection1, serverControl.getClusterConnectionNames()));
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(clusterConnection2, serverControl.getClusterConnectionNames()));
        this.server.stop();
        this.server.getConfiguration().addClusterConfiguration(new ClusterConnectionConfiguration().setName(clusterConnection1).setConnectorName(this.connectorConfig.getName())).addClusterConfiguration(new ClusterConnectionConfiguration().setName(clusterConnection2).setConnectorName(this.connectorConfig.getName()));
        this.server.start();
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(clusterConnection1, serverControl.getClusterConnectionNames()));
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(clusterConnection2, serverControl.getClusterConnectionNames()));
    }

    @Test
    public void testGetAddressCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        int countBeforeCreate = serverControl.getAddressCount();
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assert.assertTrue((countBeforeCreate < serverControl.getAddressCount() ? (byte)1 : 0) != 0);
        serverControl.destroyQueue(name.toString(), true, true);
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @Test
    public void testGetAddressNames() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        serverControl.destroyQueue(name.toString(), true, true);
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @Test
    public void testGetAddressDeletedFromJournal() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        serverControl.createAddress(address.toString(), "ANYCAST");
        Assert.assertTrue((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        this.restartServer();
        serverControl.deleteAddress(address.toString());
        this.restartServer();
        Assert.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @Test
    public void testMessageCounterMaxDayCount() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertEquals((long)MessageCounterManagerImpl.DEFAULT_MAX_DAY_COUNT, (long)serverControl.getMessageCounterMaxDayCount());
        int newCount = 100;
        serverControl.setMessageCounterMaxDayCount(newCount);
        Assert.assertEquals((long)newCount, (long)serverControl.getMessageCounterMaxDayCount());
        try {
            serverControl.setMessageCounterMaxDayCount(-1);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverControl.setMessageCounterMaxDayCount(0);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)newCount, (long)serverControl.getMessageCounterMaxDayCount());
    }

    @Test
    public void testGetMessageCounterSamplePeriod() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assert.assertEquals((long)MessageCounterManagerImpl.DEFAULT_SAMPLE_PERIOD, (long)serverControl.getMessageCounterSamplePeriod());
        long newSample = 20000L;
        serverControl.setMessageCounterSamplePeriod(newSample);
        Assert.assertEquals((long)newSample, (long)serverControl.getMessageCounterSamplePeriod());
        try {
            serverControl.setMessageCounterSamplePeriod(-1L);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverControl.setMessageCounterSamplePeriod(0L);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serverControl.setMessageCounterSamplePeriod(999L);
        Assert.assertEquals((long)999L, (long)serverControl.getMessageCounterSamplePeriod());
    }

    protected void restartServer() throws Exception {
        this.server.stop();
        this.server.start();
    }

    @Test
    public void testSecuritySettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addressMatch = "test.#";
        String exactAddress = "test.whatever";
        ActiveMQServerControlTest.assertEquals((long)1L, (long)serverControl.getRoles(addressMatch).length);
        serverControl.addSecuritySettings(addressMatch, "foo", "foo, bar", null, "bar", "foo, bar", "", "", "bar", "foo", "foo");
        this.restartServer();
        serverControl = this.createManagementControl();
        String rolesAsJSON = serverControl.getRolesAsJSON(exactAddress);
        RoleInfo[] roleInfos = RoleInfo.from((String)rolesAsJSON);
        ActiveMQServerControlTest.assertEquals((long)2L, (long)roleInfos.length);
        RoleInfo fooRole = null;
        RoleInfo barRole = null;
        if (roleInfos[0].getName().equals("foo")) {
            fooRole = roleInfos[0];
            barRole = roleInfos[1];
        } else {
            fooRole = roleInfos[1];
            barRole = roleInfos[0];
        }
        ActiveMQServerControlTest.assertTrue((boolean)fooRole.isSend());
        ActiveMQServerControlTest.assertTrue((boolean)fooRole.isConsume());
        ActiveMQServerControlTest.assertFalse((boolean)fooRole.isCreateDurableQueue());
        ActiveMQServerControlTest.assertFalse((boolean)fooRole.isDeleteDurableQueue());
        ActiveMQServerControlTest.assertTrue((boolean)fooRole.isCreateNonDurableQueue());
        ActiveMQServerControlTest.assertFalse((boolean)fooRole.isDeleteNonDurableQueue());
        ActiveMQServerControlTest.assertFalse((boolean)fooRole.isManage());
        ActiveMQServerControlTest.assertFalse((boolean)fooRole.isBrowse());
        ActiveMQServerControlTest.assertTrue((boolean)fooRole.isCreateAddress());
        ActiveMQServerControlTest.assertFalse((boolean)barRole.isSend());
        ActiveMQServerControlTest.assertTrue((boolean)barRole.isConsume());
        ActiveMQServerControlTest.assertFalse((boolean)barRole.isCreateDurableQueue());
        ActiveMQServerControlTest.assertTrue((boolean)barRole.isDeleteDurableQueue());
        ActiveMQServerControlTest.assertTrue((boolean)barRole.isCreateNonDurableQueue());
        ActiveMQServerControlTest.assertFalse((boolean)barRole.isDeleteNonDurableQueue());
        ActiveMQServerControlTest.assertFalse((boolean)barRole.isManage());
        ActiveMQServerControlTest.assertTrue((boolean)barRole.isBrowse());
        ActiveMQServerControlTest.assertFalse((boolean)barRole.isCreateAddress());
        serverControl.removeSecuritySettings(addressMatch);
        ActiveMQServerControlTest.assertEquals((long)1L, (long)serverControl.getRoles(exactAddress).length);
    }

    @Test
    public void testAddressSettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addressMatch = "test.#";
        String exactAddress = "test.whatever";
        String DLA = "someDLA";
        String expiryAddress = "someExpiry";
        long expiryDelay = RandomUtil.randomPositiveLong();
        long minExpiryDelay = RandomUtil.randomPositiveLong();
        long maxExpiryDelay = RandomUtil.randomPositiveLong();
        boolean lastValueQueue = true;
        int deliveryAttempts = 1;
        long maxSizeBytes = 20L;
        int pageSizeBytes = 10;
        int pageMaxCacheSize = 7;
        long redeliveryDelay = 4L;
        double redeliveryMultiplier = 1.0;
        long maxRedeliveryDelay = 1000L;
        long redistributionDelay = 5L;
        boolean sendToDLAOnNoRoute = true;
        String addressFullMessagePolicy = "PAGE";
        long slowConsumerThreshold = 5L;
        long slowConsumerCheckPeriod = 10L;
        String slowConsumerPolicy = SlowConsumerPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        boolean autoCreateJmsQueues = RandomUtil.randomBoolean();
        boolean autoDeleteJmsQueues = RandomUtil.randomBoolean();
        boolean autoCreateJmsTopics = RandomUtil.randomBoolean();
        boolean autoDeleteJmsTopics = RandomUtil.randomBoolean();
        boolean autoCreateQueues = RandomUtil.randomBoolean();
        boolean autoDeleteQueues = RandomUtil.randomBoolean();
        boolean autoCreateAddresses = RandomUtil.randomBoolean();
        boolean autoDeleteAddresses = RandomUtil.randomBoolean();
        String configDeleteQueues = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        String configDeleteAddresses = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        long maxSizeBytesRejectThreshold = RandomUtil.randomPositiveLong();
        String defaultLastValueKey = RandomUtil.randomString();
        boolean defaultNonDestructive = RandomUtil.randomBoolean();
        boolean defaultExclusiveQueue = RandomUtil.randomBoolean();
        boolean defaultGroupRebalance = RandomUtil.randomBoolean();
        int defaultGroupBuckets = RandomUtil.randomPositiveInt();
        String defaultGroupFirstKey = RandomUtil.randomString();
        int defaultMaxConsumers = RandomUtil.randomPositiveInt();
        boolean defaultPurgeOnNoConsumers = RandomUtil.randomBoolean();
        int defaultConsumersBeforeDispatch = RandomUtil.randomPositiveInt();
        long defaultDelayBeforeDispatch = RandomUtil.randomPositiveLong();
        String defaultQueueRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        String defaultAddressRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        int defaultConsumerWindowSize = RandomUtil.randomPositiveInt();
        long defaultRingSize = RandomUtil.randomPositiveLong();
        boolean autoDeleteCreatedQueues = RandomUtil.randomBoolean();
        long autoDeleteQueuesDelay = RandomUtil.randomPositiveLong();
        long autoDeleteQueuesMessageCount = RandomUtil.randomPositiveLong();
        long autoDeleteAddressesDelay = RandomUtil.randomPositiveLong();
        double redeliveryCollisionAvoidanceFactor = RandomUtil.randomDouble();
        long retroactiveMessageCount = RandomUtil.randomPositiveLong();
        boolean autoCreateDeadLetterResources = RandomUtil.randomBoolean();
        String deadLetterQueuePrefix = RandomUtil.randomString();
        String deadLetterQueueSuffix = RandomUtil.randomString();
        boolean autoCreateExpiryResources = RandomUtil.randomBoolean();
        String expiryQueuePrefix = RandomUtil.randomString();
        String expiryQueueSuffix = RandomUtil.randomString();
        boolean enableMetrics = RandomUtil.randomBoolean();
        serverControl.addAddressSettings(addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
        boolean ex = false;
        try {
            serverControl.addAddressSettings(addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, 100L, 1000, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
        }
        catch (Exception expected) {
            ex = true;
        }
        ActiveMQServerControlTest.assertTrue((String)"Exception expected", (boolean)ex);
        this.restartServer();
        serverControl = this.createManagementControl();
        String jsonString = serverControl.getAddressSettingsAsJSON(exactAddress);
        AddressSettingsInfo info = AddressSettingsInfo.from((String)jsonString);
        ActiveMQServerControlTest.assertEquals((Object)DLA, (Object)info.getDeadLetterAddress());
        ActiveMQServerControlTest.assertEquals((Object)expiryAddress, (Object)info.getExpiryAddress());
        ActiveMQServerControlTest.assertEquals((long)expiryDelay, (long)info.getExpiryDelay());
        ActiveMQServerControlTest.assertEquals((long)minExpiryDelay, (long)info.getMinExpiryDelay());
        ActiveMQServerControlTest.assertEquals((long)maxExpiryDelay, (long)info.getMaxExpiryDelay());
        ActiveMQServerControlTest.assertEquals((Object)lastValueQueue, (Object)info.isLastValueQueue());
        ActiveMQServerControlTest.assertEquals((long)deliveryAttempts, (long)info.getMaxDeliveryAttempts());
        ActiveMQServerControlTest.assertEquals((long)maxSizeBytes, (long)info.getMaxSizeBytes());
        ActiveMQServerControlTest.assertEquals((long)pageMaxCacheSize, (long)info.getPageCacheMaxSize());
        ActiveMQServerControlTest.assertEquals((long)pageSizeBytes, (long)info.getPageSizeBytes());
        ActiveMQServerControlTest.assertEquals((long)redeliveryDelay, (long)info.getRedeliveryDelay());
        ActiveMQServerControlTest.assertEquals((double)redeliveryMultiplier, (double)info.getRedeliveryMultiplier(), (double)1.0E-6);
        ActiveMQServerControlTest.assertEquals((long)maxRedeliveryDelay, (long)info.getMaxRedeliveryDelay());
        ActiveMQServerControlTest.assertEquals((long)redistributionDelay, (long)info.getRedistributionDelay());
        ActiveMQServerControlTest.assertEquals((Object)sendToDLAOnNoRoute, (Object)info.isSendToDLAOnNoRoute());
        ActiveMQServerControlTest.assertEquals((Object)addressFullMessagePolicy, (Object)info.getAddressFullMessagePolicy());
        ActiveMQServerControlTest.assertEquals((long)slowConsumerThreshold, (long)info.getSlowConsumerThreshold());
        ActiveMQServerControlTest.assertEquals((long)slowConsumerCheckPeriod, (long)info.getSlowConsumerCheckPeriod());
        ActiveMQServerControlTest.assertEquals((Object)slowConsumerPolicy, (Object)info.getSlowConsumerPolicy());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateJmsQueues, (Object)info.isAutoCreateJmsQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteJmsQueues, (Object)info.isAutoDeleteJmsQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateJmsTopics, (Object)info.isAutoCreateJmsTopics());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteJmsTopics, (Object)info.isAutoDeleteJmsTopics());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateQueues, (Object)info.isAutoCreateQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteQueues, (Object)info.isAutoDeleteQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateAddresses, (Object)info.isAutoCreateAddresses());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteAddresses, (Object)info.isAutoDeleteAddresses());
        ActiveMQServerControlTest.assertEquals((Object)configDeleteQueues, (Object)info.getConfigDeleteQueues());
        ActiveMQServerControlTest.assertEquals((Object)configDeleteAddresses, (Object)info.getConfigDeleteAddresses());
        ActiveMQServerControlTest.assertEquals((long)maxSizeBytesRejectThreshold, (long)info.getMaxSizeBytesRejectThreshold());
        ActiveMQServerControlTest.assertEquals((Object)defaultLastValueKey, (Object)info.getDefaultLastValueKey());
        ActiveMQServerControlTest.assertEquals((Object)defaultNonDestructive, (Object)info.isDefaultNonDestructive());
        ActiveMQServerControlTest.assertEquals((Object)defaultExclusiveQueue, (Object)info.isDefaultExclusiveQueue());
        ActiveMQServerControlTest.assertEquals((Object)defaultGroupRebalance, (Object)info.isDefaultGroupRebalance());
        ActiveMQServerControlTest.assertEquals((long)defaultGroupBuckets, (long)info.getDefaultGroupBuckets());
        ActiveMQServerControlTest.assertEquals((Object)defaultGroupFirstKey, (Object)info.getDefaultGroupFirstKey());
        ActiveMQServerControlTest.assertEquals((long)defaultMaxConsumers, (long)info.getDefaultMaxConsumers());
        ActiveMQServerControlTest.assertEquals((Object)defaultPurgeOnNoConsumers, (Object)info.isDefaultPurgeOnNoConsumers());
        ActiveMQServerControlTest.assertEquals((long)defaultConsumersBeforeDispatch, (long)info.getDefaultConsumersBeforeDispatch());
        ActiveMQServerControlTest.assertEquals((long)defaultDelayBeforeDispatch, (long)info.getDefaultDelayBeforeDispatch());
        ActiveMQServerControlTest.assertEquals((Object)defaultQueueRoutingType, (Object)info.getDefaultQueueRoutingType());
        ActiveMQServerControlTest.assertEquals((Object)defaultAddressRoutingType, (Object)info.getDefaultAddressRoutingType());
        ActiveMQServerControlTest.assertEquals((long)defaultConsumerWindowSize, (long)info.getDefaultConsumerWindowSize());
        ActiveMQServerControlTest.assertEquals((long)defaultRingSize, (long)info.getDefaultRingSize());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteCreatedQueues, (Object)info.isAutoDeleteCreatedQueues());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteQueuesDelay, (long)info.getAutoDeleteQueuesDelay());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteQueuesMessageCount, (long)info.getAutoDeleteQueuesMessageCount());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteAddressesDelay, (long)info.getAutoDeleteAddressesDelay());
        ActiveMQServerControlTest.assertEquals((double)redeliveryCollisionAvoidanceFactor, (double)info.getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        ActiveMQServerControlTest.assertEquals((long)retroactiveMessageCount, (long)info.getRetroactiveMessageCount());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateDeadLetterResources, (Object)info.isAutoCreateDeadLetterResources());
        ActiveMQServerControlTest.assertEquals((Object)deadLetterQueuePrefix, (Object)info.getDeadLetterQueuePrefix());
        ActiveMQServerControlTest.assertEquals((Object)deadLetterQueueSuffix, (Object)info.getDeadLetterQueueSuffix());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateExpiryResources, (Object)info.isAutoCreateExpiryResources());
        ActiveMQServerControlTest.assertEquals((Object)expiryQueuePrefix, (Object)info.getExpiryQueuePrefix());
        ActiveMQServerControlTest.assertEquals((Object)expiryQueueSuffix, (Object)info.getExpiryQueueSuffix());
        ActiveMQServerControlTest.assertEquals((Object)enableMetrics, (Object)info.isEnableMetrics());
        serverControl.addAddressSettings(addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, -1L, 1000, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
        jsonString = serverControl.getAddressSettingsAsJSON(exactAddress);
        info = AddressSettingsInfo.from((String)jsonString);
        ActiveMQServerControlTest.assertEquals((Object)DLA, (Object)info.getDeadLetterAddress());
        ActiveMQServerControlTest.assertEquals((Object)expiryAddress, (Object)info.getExpiryAddress());
        ActiveMQServerControlTest.assertEquals((long)expiryDelay, (long)info.getExpiryDelay());
        ActiveMQServerControlTest.assertEquals((long)minExpiryDelay, (long)info.getMinExpiryDelay());
        ActiveMQServerControlTest.assertEquals((long)maxExpiryDelay, (long)info.getMaxExpiryDelay());
        ActiveMQServerControlTest.assertEquals((Object)lastValueQueue, (Object)info.isLastValueQueue());
        ActiveMQServerControlTest.assertEquals((long)deliveryAttempts, (long)info.getMaxDeliveryAttempts());
        ActiveMQServerControlTest.assertEquals((long)-1L, (long)info.getMaxSizeBytes());
        ActiveMQServerControlTest.assertEquals((long)pageMaxCacheSize, (long)info.getPageCacheMaxSize());
        ActiveMQServerControlTest.assertEquals((long)1000L, (long)info.getPageSizeBytes());
        ActiveMQServerControlTest.assertEquals((long)redeliveryDelay, (long)info.getRedeliveryDelay());
        ActiveMQServerControlTest.assertEquals((double)redeliveryMultiplier, (double)info.getRedeliveryMultiplier(), (double)1.0E-6);
        ActiveMQServerControlTest.assertEquals((long)maxRedeliveryDelay, (long)info.getMaxRedeliveryDelay());
        ActiveMQServerControlTest.assertEquals((long)redistributionDelay, (long)info.getRedistributionDelay());
        ActiveMQServerControlTest.assertEquals((Object)sendToDLAOnNoRoute, (Object)info.isSendToDLAOnNoRoute());
        ActiveMQServerControlTest.assertEquals((Object)addressFullMessagePolicy, (Object)info.getAddressFullMessagePolicy());
        ActiveMQServerControlTest.assertEquals((long)slowConsumerThreshold, (long)info.getSlowConsumerThreshold());
        ActiveMQServerControlTest.assertEquals((long)slowConsumerCheckPeriod, (long)info.getSlowConsumerCheckPeriod());
        ActiveMQServerControlTest.assertEquals((Object)slowConsumerPolicy, (Object)info.getSlowConsumerPolicy());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateJmsQueues, (Object)info.isAutoCreateJmsQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteJmsQueues, (Object)info.isAutoDeleteJmsQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateJmsTopics, (Object)info.isAutoCreateJmsTopics());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteJmsTopics, (Object)info.isAutoDeleteJmsTopics());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateQueues, (Object)info.isAutoCreateQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteQueues, (Object)info.isAutoDeleteQueues());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateAddresses, (Object)info.isAutoCreateAddresses());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteAddresses, (Object)info.isAutoDeleteAddresses());
        ActiveMQServerControlTest.assertEquals((Object)configDeleteQueues, (Object)info.getConfigDeleteQueues());
        ActiveMQServerControlTest.assertEquals((Object)configDeleteAddresses, (Object)info.getConfigDeleteAddresses());
        ActiveMQServerControlTest.assertEquals((long)maxSizeBytesRejectThreshold, (long)info.getMaxSizeBytesRejectThreshold());
        ActiveMQServerControlTest.assertEquals((Object)defaultLastValueKey, (Object)info.getDefaultLastValueKey());
        ActiveMQServerControlTest.assertEquals((Object)defaultNonDestructive, (Object)info.isDefaultNonDestructive());
        ActiveMQServerControlTest.assertEquals((Object)defaultExclusiveQueue, (Object)info.isDefaultExclusiveQueue());
        ActiveMQServerControlTest.assertEquals((Object)defaultGroupRebalance, (Object)info.isDefaultGroupRebalance());
        ActiveMQServerControlTest.assertEquals((long)defaultGroupBuckets, (long)info.getDefaultGroupBuckets());
        ActiveMQServerControlTest.assertEquals((Object)defaultGroupFirstKey, (Object)info.getDefaultGroupFirstKey());
        ActiveMQServerControlTest.assertEquals((long)defaultMaxConsumers, (long)info.getDefaultMaxConsumers());
        ActiveMQServerControlTest.assertEquals((Object)defaultPurgeOnNoConsumers, (Object)info.isDefaultPurgeOnNoConsumers());
        ActiveMQServerControlTest.assertEquals((long)defaultConsumersBeforeDispatch, (long)info.getDefaultConsumersBeforeDispatch());
        ActiveMQServerControlTest.assertEquals((long)defaultDelayBeforeDispatch, (long)info.getDefaultDelayBeforeDispatch());
        ActiveMQServerControlTest.assertEquals((Object)defaultQueueRoutingType, (Object)info.getDefaultQueueRoutingType());
        ActiveMQServerControlTest.assertEquals((Object)defaultAddressRoutingType, (Object)info.getDefaultAddressRoutingType());
        ActiveMQServerControlTest.assertEquals((long)defaultConsumerWindowSize, (long)info.getDefaultConsumerWindowSize());
        ActiveMQServerControlTest.assertEquals((long)defaultRingSize, (long)info.getDefaultRingSize());
        ActiveMQServerControlTest.assertEquals((Object)autoDeleteCreatedQueues, (Object)info.isAutoDeleteCreatedQueues());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteQueuesDelay, (long)info.getAutoDeleteQueuesDelay());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteQueuesMessageCount, (long)info.getAutoDeleteQueuesMessageCount());
        ActiveMQServerControlTest.assertEquals((long)autoDeleteAddressesDelay, (long)info.getAutoDeleteAddressesDelay());
        ActiveMQServerControlTest.assertEquals((double)redeliveryCollisionAvoidanceFactor, (double)info.getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        ActiveMQServerControlTest.assertEquals((long)retroactiveMessageCount, (long)info.getRetroactiveMessageCount());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateDeadLetterResources, (Object)info.isAutoCreateDeadLetterResources());
        ActiveMQServerControlTest.assertEquals((Object)deadLetterQueuePrefix, (Object)info.getDeadLetterQueuePrefix());
        ActiveMQServerControlTest.assertEquals((Object)deadLetterQueueSuffix, (Object)info.getDeadLetterQueueSuffix());
        ActiveMQServerControlTest.assertEquals((Object)autoCreateExpiryResources, (Object)info.isAutoCreateExpiryResources());
        ActiveMQServerControlTest.assertEquals((Object)expiryQueuePrefix, (Object)info.getExpiryQueuePrefix());
        ActiveMQServerControlTest.assertEquals((Object)expiryQueueSuffix, (Object)info.getExpiryQueueSuffix());
        ActiveMQServerControlTest.assertEquals((Object)enableMetrics, (Object)info.isEnableMetrics());
        ex = false;
        try {
            serverControl.addAddressSettings(addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, -2L, 1000, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
        }
        catch (Exception e) {
            ex = true;
        }
        ActiveMQServerControlTest.assertTrue((String)"Supposed to have an exception called", (boolean)ex);
    }

    @Test
    public void testRemoveAddressSettingsEffective() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addr = "test";
        String root = "test.#";
        String DLA = "someDLA";
        String expiryAddress = "someExpiry";
        long expiryDelay = RandomUtil.randomPositiveLong();
        long minExpiryDelay = 10000L;
        long maxExpiryDelay = 20000L;
        boolean lastValueQueue = true;
        int deliveryAttempts = 1;
        long maxSizeBytes = 0xA00000L;
        int pageSizeBytes = 0x100000;
        int pageMaxCacheSize = 7;
        long redeliveryDelay = 4L;
        double redeliveryMultiplier = 1.0;
        long maxRedeliveryDelay = 1000L;
        long redistributionDelay = 5L;
        boolean sendToDLAOnNoRoute = true;
        String addressFullMessagePolicy = "PAGE";
        long slowConsumerThreshold = 5L;
        long slowConsumerCheckPeriod = 10L;
        String slowConsumerPolicy = SlowConsumerPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        boolean autoCreateJmsQueues = RandomUtil.randomBoolean();
        boolean autoDeleteJmsQueues = RandomUtil.randomBoolean();
        boolean autoCreateJmsTopics = RandomUtil.randomBoolean();
        boolean autoDeleteJmsTopics = RandomUtil.randomBoolean();
        boolean autoCreateQueues = RandomUtil.randomBoolean();
        boolean autoDeleteQueues = RandomUtil.randomBoolean();
        boolean autoCreateAddresses = RandomUtil.randomBoolean();
        boolean autoDeleteAddresses = RandomUtil.randomBoolean();
        String configDeleteQueues = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        String configDeleteAddresses = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        long maxSizeBytesRejectThreshold = RandomUtil.randomPositiveLong();
        String defaultLastValueKey = RandomUtil.randomString();
        boolean defaultNonDestructive = RandomUtil.randomBoolean();
        boolean defaultExclusiveQueue = RandomUtil.randomBoolean();
        boolean defaultGroupRebalance = RandomUtil.randomBoolean();
        int defaultGroupBuckets = RandomUtil.randomPositiveInt();
        String defaultGroupFirstKey = RandomUtil.randomString();
        int defaultMaxConsumers = RandomUtil.randomPositiveInt();
        boolean defaultPurgeOnNoConsumers = RandomUtil.randomBoolean();
        int defaultConsumersBeforeDispatch = RandomUtil.randomPositiveInt();
        long defaultDelayBeforeDispatch = RandomUtil.randomPositiveLong();
        String defaultQueueRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        String defaultAddressRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        int defaultConsumerWindowSize = RandomUtil.randomPositiveInt();
        long defaultRingSize = RandomUtil.randomPositiveLong();
        boolean autoDeleteCreatedQueues = RandomUtil.randomBoolean();
        long autoDeleteQueuesDelay = RandomUtil.randomPositiveLong();
        long autoDeleteQueuesMessageCount = RandomUtil.randomPositiveLong();
        long autoDeleteAddressesDelay = RandomUtil.randomPositiveLong();
        double redeliveryCollisionAvoidanceFactor = RandomUtil.randomDouble();
        long retroactiveMessageCount = RandomUtil.randomPositiveLong();
        boolean autoCreateDeadLetterResources = RandomUtil.randomBoolean();
        String deadLetterQueuePrefix = RandomUtil.randomString();
        String deadLetterQueueSuffix = RandomUtil.randomString();
        boolean autoCreateExpiryResources = RandomUtil.randomBoolean();
        String expiryQueuePrefix = RandomUtil.randomString();
        String expiryQueueSuffix = RandomUtil.randomString();
        boolean enableMetrics = RandomUtil.randomBoolean();
        serverControl.addAddressSettings(root, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
        AddressSettingsInfo rootInfo = AddressSettingsInfo.from((String)serverControl.getAddressSettingsAsJSON(root));
        long addrMinExpiryDelay = rootInfo.getMinExpiryDelay() + 1L;
        long addrMaxExpiryDelay = rootInfo.getMaxExpiryDelay() - 1L;
        serverControl.addAddressSettings(addr, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, addrMinExpiryDelay, addrMaxExpiryDelay, enableMetrics);
        AddressSettingsInfo addrInfo = AddressSettingsInfo.from((String)serverControl.getAddressSettingsAsJSON(addr));
        ActiveMQServerControlTest.assertEquals((String)"settings for addr should carry update", (long)addrMinExpiryDelay, (long)addrInfo.getMinExpiryDelay());
        ActiveMQServerControlTest.assertEquals((String)"settings for addr should carry update", (long)addrMaxExpiryDelay, (long)addrInfo.getMaxExpiryDelay());
        serverControl.removeAddressSettings(addr);
        AddressSettingsInfo rereadAddrInfo = AddressSettingsInfo.from((String)serverControl.getAddressSettingsAsJSON(addr));
        ActiveMQServerControlTest.assertEquals((String)"settings for addr should have reverted to original value after removal", (long)rootInfo.getMinExpiryDelay(), (long)rereadAddrInfo.getMinExpiryDelay());
        ActiveMQServerControlTest.assertEquals((String)"settings for addr should have reverted to original value after removal", (long)rootInfo.getMaxExpiryDelay(), (long)rereadAddrInfo.getMaxExpiryDelay());
    }

    @Test
    public void testNullRouteNameOnDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), null, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
    }

    @Test
    public void testCreateAndDestroyDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String routingName = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), routingName, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        DivertControl divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        ActiveMQServerControlTest.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        ActiveMQServerControlTest.assertEquals((Object)address, (Object)divertControl.getAddress());
        ActiveMQServerControlTest.assertEquals((Object)forwardingAddress, (Object)divertControl.getForwardingAddress());
        ActiveMQServerControlTest.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        ActiveMQServerControlTest.assertTrue((boolean)divertControl.isExclusive());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getFilter());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getTransformerClassName());
        String[] divertNames = serverControl.getDivertNames();
        ActiveMQServerControlTest.assertEquals((long)1L, (long)divertNames.length);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)divertNames[0]);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        String divertQueue = RandomUtil.randomString();
        String queue = RandomUtil.randomString();
        if (this.legacyCreateQueue) {
            session.createQueue(forwardingAddress, RoutingType.ANYCAST, divertQueue);
            session.createQueue(address, RoutingType.ANYCAST, queue);
        } else {
            session.createQueue(new QueueConfiguration(divertQueue).setAddress(forwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(address);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(queue);
        ClientConsumer divertedConsumer = session.createConsumer(divertQueue);
        session.start();
        ActiveMQServerControlTest.assertNull((Object)consumer.receiveImmediate());
        message = divertedConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        serverControl.destroyDivert(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getDivertNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((Message)message);
        ActiveMQServerControlTest.assertNull((Object)divertedConsumer.receiveImmediate());
        message = consumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        consumer.close();
        divertedConsumer.close();
        session.deleteQueue(queue);
        session.deleteQueue(divertQueue);
        session.close();
        locator.close();
    }

    @Test
    public void testCreateAndUpdateDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String routingName = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        String updatedForwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), routingName, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        DivertControl divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        ActiveMQServerControlTest.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        ActiveMQServerControlTest.assertEquals((Object)address, (Object)divertControl.getAddress());
        ActiveMQServerControlTest.assertEquals((Object)forwardingAddress, (Object)divertControl.getForwardingAddress());
        ActiveMQServerControlTest.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        ActiveMQServerControlTest.assertTrue((boolean)divertControl.isExclusive());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getFilter());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getTransformerClassName());
        String[] divertNames = serverControl.getDivertNames();
        ActiveMQServerControlTest.assertEquals((long)1L, (long)divertNames.length);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)divertNames[0]);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        String updatedDivertQueue = RandomUtil.randomString();
        String divertQueue = RandomUtil.randomString();
        String queue = RandomUtil.randomString();
        if (this.legacyCreateQueue) {
            session.createQueue(updatedForwardingAddress, RoutingType.ANYCAST, updatedDivertQueue);
            session.createQueue(forwardingAddress, RoutingType.ANYCAST, divertQueue);
            session.createQueue(address, RoutingType.ANYCAST, queue);
        } else {
            session.createQueue(new QueueConfiguration(updatedDivertQueue).setAddress(updatedForwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(divertQueue).setAddress(forwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(address);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(queue);
        ClientConsumer divertedConsumer = session.createConsumer(divertQueue);
        ClientConsumer updatedDivertedConsumer = session.createConsumer(updatedDivertQueue);
        session.start();
        ActiveMQServerControlTest.assertNull((Object)consumer.receiveImmediate());
        message = divertedConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        ActiveMQServerControlTest.assertNull((Object)updatedDivertedConsumer.receiveImmediate());
        serverControl.updateDivert(name.toString(), updatedForwardingAddress, null, null, null, ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        ActiveMQServerControlTest.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        ActiveMQServerControlTest.assertEquals((Object)address, (Object)divertControl.getAddress());
        ActiveMQServerControlTest.assertEquals((Object)updatedForwardingAddress, (Object)divertControl.getForwardingAddress());
        ActiveMQServerControlTest.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        ActiveMQServerControlTest.assertTrue((boolean)divertControl.isExclusive());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getFilter());
        ActiveMQServerControlTest.assertNull((Object)divertControl.getTransformerClassName());
        divertNames = serverControl.getDivertNames();
        ActiveMQServerControlTest.assertEquals((long)1L, (long)divertNames.length);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)divertNames[0]);
        PersistedDivertConfiguration pdc = (PersistedDivertConfiguration)this.server.getStorageManager().recoverDivertConfigurations().get(0);
        ActiveMQServerControlTest.assertEquals((Object)pdc.getDivertConfiguration().getForwardingAddress(), (Object)updatedForwardingAddress);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((Message)message);
        ActiveMQServerControlTest.assertNull((Object)consumer.receiveImmediate());
        ActiveMQServerControlTest.assertNull((Object)divertedConsumer.receiveImmediate());
        message = updatedDivertedConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        consumer.close();
        divertedConsumer.close();
        updatedDivertedConsumer.close();
        session.deleteQueue(queue);
        session.deleteQueue(divertQueue);
        session.deleteQueue(updatedDivertQueue);
        session.close();
        locator.close();
    }

    @Test
    public void testCreateAndDestroyBridge() throws Exception {
        String name = RandomUtil.randomString();
        String sourceAddress = RandomUtil.randomString();
        String sourceQueue = RandomUtil.randomString();
        String targetAddress = RandomUtil.randomString();
        String targetQueue = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getBridgeNames().length);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(sourceAddress, RoutingType.ANYCAST, sourceQueue);
            session.createQueue(targetAddress, RoutingType.ANYCAST, targetQueue);
        } else {
            session.createQueue(new QueueConfiguration(sourceQueue).setAddress(sourceAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(targetQueue).setAddress(targetAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        serverControl.createBridge(name, sourceQueue, targetAddress, null, null, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 1, 0, false, 1, -1, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, this.connectorConfig.getName(), false, false, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        String[] bridgeNames = serverControl.getBridgeNames();
        ActiveMQServerControlTest.assertEquals((long)1L, (long)bridgeNames.length);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)bridgeNames[0]);
        BridgeControl bridgeControl = ManagementControlHelper.createBridgeControl(name, this.mbeanServer);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)bridgeControl.getName());
        ActiveMQServerControlTest.assertTrue((boolean)bridgeControl.isStarted());
        ClientProducer producer = session.createProducer(sourceAddress);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((Message)message);
        session.start();
        ClientConsumer targetConsumer = session.createConsumer(targetQueue);
        message = targetConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        ClientConsumer sourceConsumer = session.createConsumer(sourceQueue);
        ActiveMQServerControlTest.assertNull((Object)sourceConsumer.receiveImmediate());
        serverControl.destroyBridge(name);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getBridgeNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((Message)message);
        ActiveMQServerControlTest.assertNull((Object)targetConsumer.receiveImmediate());
        message = sourceConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        sourceConsumer.close();
        targetConsumer.close();
        session.deleteQueue(sourceQueue);
        session.deleteQueue(targetQueue);
        session.close();
        locator.close();
    }

    @Test
    public void testCreateAndDestroyBridgeFromJson() throws Exception {
        String name = RandomUtil.randomString();
        String sourceAddress = RandomUtil.randomString();
        String sourceQueue = RandomUtil.randomString();
        String targetAddress = RandomUtil.randomString();
        String targetQueue = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getBridgeNames().length);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(sourceAddress, RoutingType.ANYCAST, sourceQueue);
            session.createQueue(targetAddress, RoutingType.ANYCAST, targetQueue);
        } else {
            session.createQueue(new QueueConfiguration(sourceQueue).setAddress(sourceAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(targetQueue).setAddress(targetAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration(name).setQueueName(sourceQueue).setForwardingAddress(targetAddress).setUseDuplicateDetection(false).setConfirmationWindowSize(1).setProducerWindowSize(-1).setStaticConnectors(Collections.singletonList(this.connectorConfig.getName())).setHA(false).setUser(null).setPassword(null);
        serverControl.createBridge(bridgeConfiguration.toJSON());
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        String[] bridgeNames = serverControl.getBridgeNames();
        ActiveMQServerControlTest.assertEquals((long)1L, (long)bridgeNames.length);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)bridgeNames[0]);
        BridgeControl bridgeControl = ManagementControlHelper.createBridgeControl(name, this.mbeanServer);
        ActiveMQServerControlTest.assertEquals((Object)name, (Object)bridgeControl.getName());
        ActiveMQServerControlTest.assertTrue((boolean)bridgeControl.isStarted());
        ClientProducer producer = session.createProducer(sourceAddress);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((Message)message);
        session.start();
        ClientConsumer targetConsumer = session.createConsumer(targetQueue);
        message = targetConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        ClientConsumer sourceConsumer = session.createConsumer(sourceQueue);
        ActiveMQServerControlTest.assertNull((Object)sourceConsumer.receiveImmediate());
        serverControl.destroyBridge(name);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getBridgeNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((Message)message);
        ActiveMQServerControlTest.assertNull((Object)targetConsumer.receiveImmediate());
        message = sourceConsumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)message);
        ActiveMQServerControlTest.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        sourceConsumer.close();
        targetConsumer.close();
        session.deleteQueue(sourceQueue);
        session.deleteQueue(targetQueue);
        session.close();
        locator.close();
    }

    @Test
    public void testListPreparedTransactionDetails() throws Exception {
        SimpleString atestq = new SimpleString("BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(atestq).setDurable(Boolean.valueOf(true)));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        m2.putStringProperty("m2", "m2");
        m3.putStringProperty("m3", "m3");
        m4.putStringProperty("m4", "m4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        ClientMessage m5 = this.createTextMessage(clientSession, "");
        ClientMessage m6 = this.createTextMessage(clientSession, "");
        ClientMessage m7 = this.createTextMessage(clientSession, "");
        ClientMessage m8 = this.createTextMessage(clientSession, "");
        m5.putStringProperty("m5", "m5");
        m6.putStringProperty("m6", "m6");
        m7.putStringProperty("m7", "m7");
        m8.putStringProperty("m8", "m8");
        XidImpl xid2 = this.newXID();
        clientSession.start((Xid)xid2, 0);
        clientProducer.send((Message)m5);
        clientProducer.send((Message)m6);
        clientProducer.send((Message)m7);
        clientProducer.send((Message)m8);
        clientSession.end((Xid)xid2, 0x4000000);
        ActiveMQServerControl serverControl = this.createManagementControl();
        JsonArray jsonArray = JsonUtil.readJsonArray((String)serverControl.listProducersInfoAsJSON());
        ActiveMQServerControlTest.assertEquals((long)1L, (long)jsonArray.size());
        ActiveMQServerControlTest.assertEquals((long)8L, (long)((JsonObject)jsonArray.get(0)).getInt("msgSent"));
        clientSession.close();
        locator.close();
        String txDetails = serverControl.listPreparedTransactionDetailsAsJSON();
        Assert.assertTrue((boolean)txDetails.matches(".*m1.*"));
        Assert.assertTrue((boolean)txDetails.matches(".*m2.*"));
        Assert.assertTrue((boolean)txDetails.matches(".*m3.*"));
        Assert.assertTrue((boolean)txDetails.matches(".*m4.*"));
        Assert.assertFalse((boolean)txDetails.matches(".*m5.*"));
        Assert.assertFalse((boolean)txDetails.matches(".*m6.*"));
        Assert.assertFalse((boolean)txDetails.matches(".*m7.*"));
        Assert.assertFalse((boolean)txDetails.matches(".*m8.*"));
    }

    @Test
    public void testListPreparedTransactionDetailsOnConsumer() throws Exception {
        SimpleString atestq = new SimpleString("BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(atestq));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "valuem1");
        m2.putStringProperty("m2", "valuem2");
        m3.putStringProperty("m3", "valuem3");
        m4.putStringProperty("m4", "valuem4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.commit((Xid)xid, false);
        ClientConsumer consumer = clientSession.createConsumer(atestq);
        clientSession.start();
        xid = this.newXID();
        clientSession.start((Xid)xid, 0);
        m1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)m1);
        m1.acknowledge();
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        ActiveMQServerControl serverControl = this.createManagementControl();
        String jsonOutput = serverControl.listPreparedTransactionDetailsAsJSON();
        Assert.assertTrue((jsonOutput.lastIndexOf("valuem1") > 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((jsonOutput.lastIndexOf("valuem2") < 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((jsonOutput.lastIndexOf("valuem3") < 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((jsonOutput.lastIndexOf("valuem4") < 0 ? (byte)1 : 0) != 0);
        clientSession.close();
        locator.close();
    }

    @Test
    public void testListPreparedTransactionDetailsAsHTML() throws Exception {
        SimpleString atestq = new SimpleString("BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(atestq));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        m2.putStringProperty("m2", "m2");
        m3.putStringProperty("m3", "m3");
        m4.putStringProperty("m4", "m4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.close();
        locator.close();
        ActiveMQServerControl serverControl = this.createManagementControl();
        String html = serverControl.listPreparedTransactionDetailsAsHTML();
        Assert.assertTrue((boolean)html.matches(".*m1.*"));
        Assert.assertTrue((boolean)html.matches(".*m2.*"));
        Assert.assertTrue((boolean)html.matches(".*m3.*"));
        Assert.assertTrue((boolean)html.matches(".*m4.*"));
    }

    @Test
    public void testCommitPreparedTransactions() throws Exception {
        SimpleString recQueue = new SimpleString("BasicXaTestqRec");
        SimpleString sendQueue = new SimpleString("BasicXaTestqSend");
        byte[] globalTransactionId = UUIDGenerator.getInstance().generateStringUUID().getBytes();
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, globalTransactionId);
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, globalTransactionId);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(recQueue, recQueue, null, true);
            clientSession.createQueue(sendQueue, sendQueue, null, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(recQueue));
            clientSession.createQueue(new QueueConfiguration(sendQueue));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        ClientProducer clientProducer = clientSession.createProducer(recQueue);
        clientProducer.send((Message)m1);
        locator.close();
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer consumer = receiveClientSession.createConsumer(recQueue);
        ServerLocator sendLocator = this.createInVMNonHALocator();
        ClientSessionFactory sendCsf = this.createSessionFactory(sendLocator);
        ClientSession sendClientSession = sendCsf.createSession(true, false, false);
        ClientProducer producer = sendClientSession.createProducer(sendQueue);
        receiveClientSession.start((Xid)xid, 0);
        receiveClientSession.start();
        sendClientSession.start((Xid)xid2, 0);
        ClientMessage m = consumer.receive(5000L);
        ActiveMQServerControlTest.assertNotNull((Object)m);
        producer.send((Message)m);
        receiveClientSession.end((Xid)xid, 0x4000000);
        sendClientSession.end((Xid)xid2, 0x4000000);
        receiveClientSession.prepare((Xid)xid);
        sendClientSession.prepare((Xid)xid2);
        ActiveMQServerControl serverControl = this.createManagementControl();
        sendLocator.close();
        receiveLocator.close();
        boolean success = serverControl.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        success = serverControl.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
    }

    @Test
    public void testScaleDownWithConnector() throws Exception {
        this.scaleDown(new ScaleDownHandler(){

            @Override
            public void scaleDown(ActiveMQServerControl control) throws Exception {
                control.scaleDown("server2-connector");
            }
        });
    }

    @Test
    public void testScaleDownWithOutConnector() throws Exception {
        this.scaleDown(new ScaleDownHandler(){

            @Override
            public void scaleDown(ActiveMQServerControl control) throws Exception {
                control.scaleDown(null);
            }
        });
    }

    @Test
    public void testForceFailover() throws Exception {
        block2: {
            ActiveMQServerControl serverControl = this.createManagementControl();
            try {
                serverControl.forceFailover();
            }
            catch (Exception e) {
                if (this.usingCore()) break block2;
                ActiveMQServerControlTest.fail((String)e.getMessage());
            }
        }
        Wait.waitFor(() -> !this.server.isStarted());
        ActiveMQServerControlTest.assertFalse((boolean)this.server.isStarted());
    }

    @Test
    public void testTotalMessageCount() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(new QueueConfiguration(random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(true);
        producer1.send((Message)message);
        producer2.send((Message)message);
        session.commit();
        Queue queue1 = this.server.locateQueue(SimpleString.toSimpleString((String)random1));
        queue1.flushExecutor();
        Queue queue2 = this.server.locateQueue(SimpleString.toSimpleString((String)random1));
        queue2.flushExecutor();
        ActiveMQServerControlTest.assertEquals((long)2L, (long)serverControl.getTotalMessageCount());
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @Test
    public void testTotalConnectionCount() throws Exception {
        int CONNECTION_COUNT = 100;
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        for (int i = 0; i < 100; ++i) {
            this.createSessionFactory(locator).close();
        }
        ActiveMQServerControlTest.assertEquals((long)(100 + (this.usingCore() ? 1 : 0)), (long)serverControl.getTotalConnectionCount());
        ActiveMQServerControlTest.assertEquals((long)(this.usingCore() ? 1 : 0), (long)serverControl.getConnectionCount());
        locator.close();
    }

    @Test
    public void testTotalMessagesAdded() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(new QueueConfiguration(random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(false);
        producer1.send((Message)message);
        producer2.send((Message)message);
        session.commit();
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        session.start();
        ActiveMQServerControlTest.assertNotNull((Object)consumer1.receive().acknowledge());
        ActiveMQServerControlTest.assertNotNull((Object)consumer2.receive().acknowledge());
        session.commit();
        ActiveMQServerControlTest.assertEquals((long)2L, (long)serverControl.getTotalMessagesAdded());
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getTotalMessageCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @Test
    public void testTotalMessagesAcknowledged() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(new QueueConfiguration(random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(false);
        producer1.send((Message)message);
        producer2.send((Message)message);
        session.commit();
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        session.start();
        ActiveMQServerControlTest.assertNotNull((Object)consumer1.receive().acknowledge());
        ActiveMQServerControlTest.assertNotNull((Object)consumer2.receive().acknowledge());
        session.commit();
        ActiveMQServerControlTest.assertEquals((long)2L, (long)serverControl.getTotalMessagesAcknowledged());
        ActiveMQServerControlTest.assertEquals((long)0L, (long)serverControl.getTotalMessageCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @Test
    public void testTotalConsumerCount() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        QueueControl queueControl1 = ManagementControlHelper.createQueueControl(SimpleString.toSimpleString((String)random1), SimpleString.toSimpleString((String)random1), RoutingType.ANYCAST, this.mbeanServer);
        QueueControl queueControl2 = ManagementControlHelper.createQueueControl(SimpleString.toSimpleString((String)random2), SimpleString.toSimpleString((String)random2), RoutingType.ANYCAST, this.mbeanServer);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(new QueueConfiguration(random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(new QueueConfiguration(random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        ActiveMQServerControlTest.assertEquals((long)(this.usingCore() ? 3L : 2L), (long)serverControl.getTotalConsumerCount());
        ActiveMQServerControlTest.assertEquals((long)1L, (long)queueControl1.getConsumerCount());
        ActiveMQServerControlTest.assertEquals((long)1L, (long)queueControl2.getConsumerCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @Test
    public void testListConnectionsAsJSON() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        ArrayList<ClientSessionFactory> factories = new ArrayList<ClientSessionFactory>();
        ServerLocator locator = this.createInVMNonHALocator();
        factories.add(this.createSessionFactory(locator));
        Thread.sleep(200L);
        factories.add(this.createSessionFactory(locator));
        this.addClientSession(((ClientSessionFactory)factories.get(1)).createSession());
        String jsonString = serverControl.listConnectionsAsJSON();
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)(this.usingCore() ? 3L : 2L), (long)array.size());
        String key = "creationTime";
        JsonObject[] sorted = new JsonObject[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            sorted[i] = array.getJsonObject(i);
        }
        if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
            JsonObject o = sorted[1];
            sorted[1] = sorted[0];
            sorted[0] = o;
        }
        if (this.usingCore()) {
            if (sorted[1].getJsonNumber(key).longValue() > sorted[2].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[2];
                sorted[2] = sorted[1];
                sorted[1] = o;
            }
            if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[1];
                sorted[1] = sorted[0];
                sorted[0] = o;
            }
        }
        JsonObject first = sorted[0];
        JsonObject second = sorted[1];
        Assert.assertTrue((first.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((first.getString("clientAddress").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)first.getJsonNumber("sessionCount").longValue());
        Assert.assertTrue((second.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((second.getString("clientAddress").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)second.getJsonNumber("sessionCount").longValue());
    }

    @Test
    public void testListConsumersAsJSON() throws Exception {
        JsonObject second;
        JsonObject first;
        SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
        String filter = "x = 1";
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.addClientConsumer(session.createConsumer(queueName));
        Thread.sleep(100L);
        this.addClientConsumer(session.createConsumer(queueName, SimpleString.toSimpleString((String)"x = 1"), true));
        String jsonString = serverControl.listConsumersAsJSON(factory.getConnection().getID().toString());
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)2L, (long)array.size());
        if (array.getJsonObject(0).getJsonNumber("creationTime").longValue() < array.getJsonObject(1).getJsonNumber("creationTime").longValue()) {
            first = array.getJsonObject(0);
            second = array.getJsonObject(1);
        } else {
            first = array.getJsonObject(1);
            second = array.getJsonObject(0);
        }
        Assert.assertNotNull((Object)first.getJsonNumber("consumerID").longValue());
        Assert.assertTrue((first.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)factory.getConnection().getID().toString(), (Object)first.getString("connectionID"));
        Assert.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)first.getString("sessionID"));
        Assert.assertTrue((first.getString("queueName").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)queueName.toString(), (Object)first.getString("queueName"));
        Assert.assertEquals((Object)false, (Object)first.getBoolean("browseOnly"));
        Assert.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)first.getJsonNumber("deliveringCount").longValue());
        Assert.assertNotNull((Object)second.getJsonNumber("consumerID").longValue());
        Assert.assertTrue((second.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)factory.getConnection().getID().toString(), (Object)second.getString("connectionID"));
        Assert.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)second.getString("sessionID"));
        Assert.assertTrue((second.getString("queueName").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)queueName.toString(), (Object)second.getString("queueName"));
        Assert.assertEquals((Object)true, (Object)second.getBoolean("browseOnly"));
        Assert.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)second.getJsonNumber("deliveringCount").longValue());
        Assert.assertTrue((second.getString("filter").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"x = 1", (Object)second.getString("filter"));
    }

    @Test
    public void testListAllConsumersAsJSON() throws Exception {
        SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession());
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory factory2 = this.createSessionFactory(locator2);
        ClientSession session2 = this.addClientSession(factory2.createSession());
        serverControl.createAddress(queueName.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.addClientConsumer(session.createConsumer(queueName));
        Thread.sleep(200L);
        this.addClientConsumer(session2.createConsumer(queueName));
        String jsonString = serverControl.listAllConsumersAsJSON();
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)(this.usingCore() ? 3L : 2L), (long)array.size());
        String key = "creationTime";
        JsonObject[] sorted = new JsonObject[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            sorted[i] = array.getJsonObject(i);
        }
        if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
            JsonObject o = sorted[1];
            sorted[1] = sorted[0];
            sorted[0] = o;
        }
        if (this.usingCore()) {
            if (sorted[1].getJsonNumber(key).longValue() > sorted[2].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[2];
                sorted[2] = sorted[1];
                sorted[1] = o;
            }
            if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[1];
                sorted[1] = sorted[0];
                sorted[0] = o;
            }
        }
        JsonObject first = sorted[0];
        JsonObject second = sorted[1];
        Assert.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertNotNull((Object)first.getJsonNumber("consumerID").longValue());
        Assert.assertTrue((first.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)factory.getConnection().getID().toString(), (Object)first.getString("connectionID"));
        Assert.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)first.getString("sessionID"));
        Assert.assertTrue((first.getString("queueName").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)queueName.toString(), (Object)first.getString("queueName"));
        Assert.assertEquals((Object)false, (Object)first.getBoolean("browseOnly"));
        Assert.assertEquals((long)0L, (long)first.getJsonNumber("deliveringCount").longValue());
        Assert.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertNotNull((Object)second.getJsonNumber("consumerID").longValue());
        Assert.assertTrue((second.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)factory2.getConnection().getID().toString(), (Object)second.getString("connectionID"));
        Assert.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString("sessionID"));
        Assert.assertTrue((second.getString("queueName").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)queueName.toString(), (Object)second.getString("queueName"));
        Assert.assertEquals((Object)false, (Object)second.getBoolean("browseOnly"));
        Assert.assertEquals((long)0L, (long)second.getJsonNumber("deliveringCount").longValue());
    }

    @Test
    public void testListSessionsAsJSON() throws Exception {
        SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session1 = this.addClientSession(factory.createSession());
        ClientSession session2 = this.addClientSession(factory.createSession("myUser", "myPass", false, false, false, false, 0));
        session2.createConsumer(queueName);
        String jsonString = serverControl.listSessionsAsJSON(factory.getConnection().getID().toString());
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)2L, (long)array.size());
        JsonObject first = this.lookupSession(array, session1);
        JsonObject second = this.lookupSession(array, session2);
        Assert.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session1).getName(), (Object)first.getString("sessionID"));
        Assert.assertTrue((first.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"guest", (Object)first.getString("principal"));
        Assert.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)first.getJsonNumber("consumerCount").longValue());
        Assert.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString("sessionID"));
        Assert.assertTrue((second.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"myUser", (Object)second.getString("principal"));
        Assert.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)second.getJsonNumber("consumerCount").longValue());
    }

    private JsonObject lookupSession(JsonArray jsonArray, ClientSession session) throws Exception {
        String name = ((ClientSessionImpl)session).getName();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject obj = jsonArray.getJsonObject(i);
            String sessionID = obj.getString("sessionID");
            Assert.assertNotNull((Object)sessionID);
            if (!sessionID.equals(name)) continue;
            return obj;
        }
        Assert.fail((String)("Sesison not found for session id " + name));
        return null;
    }

    @Test
    public void testListAllSessionsAsJSON() throws Exception {
        SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory factory2 = this.createSessionFactory(locator2);
        ClientSession session1 = this.addClientSession(factory.createSession());
        Thread.sleep(5L);
        ClientSession session2 = this.addClientSession(factory2.createSession("myUser", "myPass", false, false, false, false, 0));
        session2.addMetaData("foo", "bar");
        session2.addMetaData("bar", "baz");
        session2.createConsumer(queueName);
        String jsonString = serverControl.listAllSessionsAsJSON();
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)(2 + (this.usingCore() ? 1 : 0)), (long)array.size());
        JsonObject first = this.lookupSession(array, session1);
        JsonObject second = this.lookupSession(array, session2);
        Assert.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session1).getName(), (Object)first.getString("sessionID"));
        Assert.assertTrue((first.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"guest", (Object)first.getString("principal"));
        Assert.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)first.getJsonNumber("consumerCount").longValue());
        Assert.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString("sessionID"));
        Assert.assertTrue((second.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)"myUser", (Object)second.getString("principal"));
        Assert.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)second.getJsonNumber("consumerCount").longValue());
        Assert.assertEquals((Object)second.getJsonObject("metadata").getJsonString("foo").getString(), (Object)"bar");
        Assert.assertEquals((Object)second.getJsonObject("metadata").getJsonString("bar").getString(), (Object)"baz");
    }

    @Test
    public void testListAllSessionsAsJSONWithJMS() throws Exception {
        SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)"vm://0", (String)"cf");
        Connection con = cf.createConnection();
        String clientID = UUID.randomUUID().toString();
        con.setClientID(clientID);
        String jsonString = serverControl.listAllSessionsAsJSON();
        log.debug((Object)jsonString);
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)(1 + (this.usingCore() ? 1 : 0)), (long)array.size());
        JsonObject obj = this.lookupSession(array, ((ActiveMQConnection)con).getInitialSession());
        Assert.assertEquals((Object)obj.getJsonObject("metadata").getJsonString("jms-client-id").getString(), (Object)clientID);
        Assert.assertNotNull((Object)obj.getJsonObject("metadata").getJsonString("jms-session"));
    }

    @Test
    public void testListQueues() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("my_queue_two");
        SimpleString queueName3 = new SimpleString("other_queue_three");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_queue");
        String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)2L, (long)array.size());
        Assert.assertTrue((boolean)array.getJsonObject(0).getString("name").contains("my_queue"));
        Assert.assertTrue((boolean)array.getJsonObject(1).getString("name").contains("my_queue"));
        filterString = this.createJsonFilter("", "", "");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertTrue((String)"number of queues returned from query", (3 <= array.size() ? (byte)1 : 0) != 0);
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)1L, (long)array.size());
        Assert.assertNotEquals((String)"name", (Object)"", (Object)array.getJsonObject(0).getString("name"));
        Assert.assertNotEquals((String)"id", (Object)"", (Object)array.getJsonObject(0).getString("id"));
        Assert.assertNotEquals((String)"address", (Object)"", (Object)array.getJsonObject(0).getString("address"));
        Assert.assertEquals((String)"filter", (Object)"", (Object)array.getJsonObject(0).getString("filter"));
        Assert.assertEquals((String)"durable", (Object)"false", (Object)array.getJsonObject(0).getString("durable"));
        Assert.assertEquals((String)"paused", (Object)"false", (Object)array.getJsonObject(0).getString("paused"));
        Assert.assertNotEquals((String)"temporary", (Object)"", (Object)array.getJsonObject(0).getString("temporary"));
        Assert.assertEquals((String)"purgeOnNoConsumers", (Object)"false", (Object)array.getJsonObject(0).getString("purgeOnNoConsumers"));
        Assert.assertNotEquals((String)"consumerCount", (Object)"", (Object)array.getJsonObject(0).getString("consumerCount"));
        Assert.assertEquals((String)"maxConsumers", (Object)"-1", (Object)array.getJsonObject(0).getString("maxConsumers"));
        Assert.assertEquals((String)"autoCreated", (Object)"false", (Object)array.getJsonObject(0).getString("autoCreated"));
        Assert.assertEquals((String)"user", (Object)"", (Object)array.getJsonObject(0).getString("user"));
        Assert.assertNotEquals((String)"routingType", (Object)"", (Object)array.getJsonObject(0).getString("routingType"));
        Assert.assertEquals((String)"messagesAdded", (Object)"0", (Object)array.getJsonObject(0).getString("messagesAdded"));
        Assert.assertEquals((String)"messageCount", (Object)"0", (Object)array.getJsonObject(0).getString("messageCount"));
        Assert.assertEquals((String)"messagesAcked", (Object)"0", (Object)array.getJsonObject(0).getString("messagesAcked"));
        Assert.assertEquals((String)"deliveringCount", (Object)"0", (Object)array.getJsonObject(0).getString("deliveringCount"));
        Assert.assertEquals((String)"messagesKilled", (Object)"0", (Object)array.getJsonObject(0).getString("messagesKilled"));
        Assert.assertEquals((String)"exclusive", (Object)"false", (Object)array.getJsonObject(0).getString("exclusive"));
        Assert.assertEquals((String)"lastValue", (Object)"false", (Object)array.getJsonObject(0).getString("lastValue"));
        Assert.assertEquals((String)"scheduledCount", (Object)"0", (Object)array.getJsonObject(0).getString("scheduledCount"));
        Assert.assertEquals((String)"groupRebalance", (Object)"false", (Object)array.getJsonObject(0).getString("groupRebalance"));
        Assert.assertEquals((String)"groupBuckets", (Object)"-1", (Object)array.getJsonObject(0).getString("groupBuckets"));
        Assert.assertEquals((String)"groupFirstKey", (Object)"", (Object)array.getJsonObject(0).getString("groupFirstKey"));
    }

    @Test
    public void testListQueuesOrder() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_1");
        SimpleString queueName2 = new SimpleString("my_queue_2");
        SimpleString queueName3 = new SimpleString("my_queue_3");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, new SimpleString("filter1"), null, true, false, false, Integer.valueOf(20), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setRoutingType(RoutingType.ANYCAST).setFilterString("filter1").setMaxConsumers(Integer.valueOf(20)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        Thread.sleep(500L);
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, new SimpleString("filter3"), null, true, false, true, Integer.valueOf(40), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setRoutingType(RoutingType.ANYCAST).setFilterString("filter3").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(40)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        Thread.sleep(500L);
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, new SimpleString("filter0"), null, true, false, false, Integer.valueOf(10), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setRoutingType(RoutingType.ANYCAST).setFilterString("filter0").setMaxConsumers(Integer.valueOf(10)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_queue");
        String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"queue1 default Order", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"queue2 default Order", (Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"queue3 default Order", (Object)queueName3.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "id", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"queue3 ordered by id", (Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"queue2 ordered by id", (Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"queue1 ordered by id", (Object)queueName1.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"queue3 ordered by address", (Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"queue2 ordered by address", (Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"queue1 ordered by address", (Object)queueName1.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "autoCreated", "asc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"pos1 ordered by autocreate", (Object)"false", (Object)array.getJsonObject(0).getString("autoCreated"));
        Assert.assertEquals((String)"pos2 ordered by autocreate", (Object)"false", (Object)array.getJsonObject(1).getString("autoCreated"));
        Assert.assertEquals((String)"pos3 ordered by autocreate", (Object)"true", (Object)array.getJsonObject(2).getString("autoCreated"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "filter", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"queue2 ordered by filter", (Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"queue1 ordered by filter", (Object)queueName1.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"queue3 ordered by filter", (Object)queueName3.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "maxConsumers", "asc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)3L, (long)array.size());
        Assert.assertEquals((String)"queue3 ordered by filter", (Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"queue1 ordered by filter", (Object)queueName1.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"queue2 ordered by filter", (Object)queueName2.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)1L, (long)array.size());
        Assert.assertEquals((String)"queue3 ordered by page", (Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 2, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)1L, (long)array.size());
        Assert.assertEquals((String)"queue2 ordered by page", (Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 3, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)1L, (long)array.size());
        Assert.assertEquals((String)"queue1 ordered by page", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
    }

    @Test
    public void testListQueuesNumericFilter() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("my_queue_two");
        SimpleString queueName3 = new SimpleString("one_consumer_queue_three");
        SimpleString queueName4 = new SimpleString("my_queue_four");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false, 10, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)).setMaxConsumers(Integer.valueOf(10)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName4, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName4, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName4).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            session.start();
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer1_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer2_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer3_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer1_q3 = session.createConsumer(queueName3);
            ClientProducer clientProducer = session.createProducer(queueName1);
            ClientMessage message = session.createMessage(false);
            for (int i = 0; i < 10; ++i) {
                clientProducer.send((Message)message);
            }
            ClientMessage messageReceived = consumer1_q1.receive(100L);
            if (messageReceived == null) {
                ActiveMQServerControlTest.fail((String)"should have received a message");
            }
            messageReceived.acknowledge();
            session.commit();
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "CONTAINS", "0");
            String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "LESS_THAN", "1");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from LESS_THAN query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName4.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "2");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from GREATER_THAN query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("CONSUMER_COUNT", "EQUALS", "3");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from EQUALS query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("MESSAGE_COUNT", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from MESSAGE_COUNT query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("MESSAGES_ADDED", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from MESSAGE_COUNT query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("DELIVERING_COUNT", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from DELIVERING_COUNT query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("MESSAGES_ACKED", "GREATER_THAN", "0");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from MESSAGES_ACKED query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("MAX_CONSUMERS", "GREATER_THAN", "9");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from MAX_CONSUMERS query", (long)1L, (long)array.size());
            Assert.assertEquals((String)"correct queue returned from query", (Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"));
            filterString = this.createJsonFilter("MESSAGES_KILLED", "GREATER_THAN", "0");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from MESSAGES_KILLED query", (long)0L, (long)array.size());
        }
    }

    @Test
    public void testListQueuesNumericFilterInvalid() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("one_consumer_queue_two");
        SimpleString queueName3 = new SimpleString("one_consumer_queue_three");
        SimpleString queueName4 = new SimpleString("my_queue_four");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false, 10, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)).setMaxConsumers(Integer.valueOf(10)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName4, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName4, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName4).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            session.start();
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "CONTAINS", "NOT_NUMBER");
            String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "LESS_THAN", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from LESS_THAN query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from GREATER_THAN query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "EQUALS", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from EQUALS query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("name", "LESS_THAN", "my_queue");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from LESS_THAN on non numeric field", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("name", "GREATER_THAN", "my_queue");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from GREATER_THAN on non numeric field", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", " ");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from GREATER_THAN query", (long)0L, (long)array.size());
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "0.12");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of queues returned from GREATER_THAN query", (long)0L, (long)array.size());
        }
    }

    @Test
    public void testListAddresses() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("my_queue_two");
        SimpleString queueName3 = new SimpleString("other_queue_three");
        SimpleString queueName4 = new SimpleString("other_queue_four");
        SimpleString addressName1 = new SimpleString("my_address_one");
        SimpleString addressName2 = new SimpleString("my_address_two");
        SimpleString addressName3 = new SimpleString("other_address_three");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName3, null, false, false);
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(new QueueConfiguration(queueName4).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_address");
        String addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        JsonObject addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        JsonArray array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of addresses returned from query", (long)2L, (long)array.size());
        Assert.assertTrue((String)"address name check", (boolean)array.getJsonObject(0).getString("name").contains("my_address"));
        Assert.assertTrue((String)"address name check", (boolean)array.getJsonObject(1).getString("name").contains("my_address"));
        filterString = this.createJsonFilter("name", "EQUALS", addressName1.toString());
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of addresses returned from query", (long)1L, (long)array.size());
        Assert.assertEquals((String)"address name check", (Object)addressName1.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertNotEquals((String)"id", (Object)"", (Object)array.getJsonObject(0).getString("id"));
        Assert.assertTrue((String)"routingTypes", (boolean)array.getJsonObject(0).getString("routingTypes").contains(RoutingType.ANYCAST.name()));
        Assert.assertEquals((String)"queueCount", (Object)"1", (Object)array.getJsonObject(0).getString("queueCount"));
        filterString = this.createJsonFilter("", "", "");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertTrue((String)"number of addresses returned from query", (3 <= array.size() ? (byte)1 : 0) != 0);
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 1);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of queues returned from query", (long)1L, (long)array.size());
        filterString = this.createJsonFilter("QUEUE_COUNT", "GREATER_THAN", "1");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of addresses returned from query", (long)1L, (long)array.size());
        Assert.assertEquals((String)"address name check", (Object)addressName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        filterString = this.createJsonFilter("QUEUE_COUNT", "LESS_THAN", "0");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number of addresses returned from query", (long)0L, (long)array.size());
    }

    @Test
    public void testListAddressOrder() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("my_queue_two");
        SimpleString queueName3 = new SimpleString("other_queue_three");
        SimpleString queueName4 = new SimpleString("other_queue_four");
        SimpleString addressName1 = new SimpleString("my_address_1");
        SimpleString addressName2 = new SimpleString("my_address_2");
        SimpleString addressName3 = new SimpleString("my_address_3");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(addressName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName3, null, false, false);
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName3).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(new QueueConfiguration(queueName4).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my");
        String addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        JsonObject addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        JsonArray array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number addresses returned", (long)3L, (long)array.size());
        Assert.assertEquals((String)"address1 default order", (Object)addressName1.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"address2 default order", (Object)addressName2.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"address3 default order", (Object)addressName3.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my", "name", "desc");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number addresses returned", (long)3L, (long)array.size());
        Assert.assertEquals((String)"address3 ordered by name", (Object)addressName3.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"address2 ordered by name", (Object)addressName2.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"address1 ordered by name", (Object)addressName1.toString(), (Object)array.getJsonObject(2).getString("name"));
        filterString = this.createJsonFilter("name", "CONTAINS", "my", "queueCount", "asc");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assert.assertEquals((String)"number addresses returned", (long)3L, (long)array.size());
        Assert.assertEquals((String)"address2 ordered by queue count", (Object)addressName2.toString(), (Object)array.getJsonObject(0).getString("name"));
        Assert.assertEquals((String)"address1 ordered by queue count", (Object)addressName1.toString(), (Object)array.getJsonObject(1).getString("name"));
        Assert.assertEquals((String)"address3 ordered by queue count", (Object)addressName3.toString(), (Object)array.getJsonObject(2).getString("name"));
    }

    @Test
    public void testListConsumers() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString queueName2 = new SimpleString("my_queue_two");
        SimpleString queueName3 = new SimpleString("other_queue_three");
        SimpleString addressName1 = new SimpleString("my_address_one");
        SimpleString addressName2 = new SimpleString("my_address_two");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName2, null, false, false);
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName3, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName2).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(new QueueConfiguration(queueName3).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer1_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer1_q3 = session.createConsumer(queueName3);
            String filterString = this.createJsonFilter("queue", "EQUALS", queueName1.toString());
            String consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            JsonObject consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            JsonArray array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)2L, (long)array.size());
            Assert.assertEquals((String)"check consumer's queue", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("queue"));
            Assert.assertEquals((String)"check consumer's queue", (Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("queue"));
            filterString = this.createJsonFilter("queue", "CONTAINS", "my_queue");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)3L, (long)array.size());
            filterString = this.createJsonFilter("address", "EQUALS", addressName1.toString());
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)2L, (long)array.size());
            Assert.assertEquals((String)"check consumers address", (Object)addressName1.toString(), (Object)array.getJsonObject(0).getString("address"));
            Assert.assertEquals((String)"check consumers address", (Object)addressName1.toString(), (Object)array.getJsonObject(1).getString("address"));
            filterString = this.createJsonFilter("", "", "");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertTrue((String)"at least 4 consumers returned from query", (4 <= array.size() ? (byte)1 : 0) != 0);
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 1);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)1L, (long)array.size());
            filterString = this.createJsonFilter("queue", "EQUALS", queueName3.toString());
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)1L, (long)array.size());
            JsonObject jsonConsumer = array.getJsonObject(0);
            Assert.assertEquals((String)"queue name in consumer", (Object)queueName3.toString(), (Object)jsonConsumer.getString("queue"));
            Assert.assertEquals((String)"address name in consumer", (Object)addressName2.toString(), (Object)jsonConsumer.getString("address"));
            Assert.assertEquals((String)"consumer protocol ", (Object)"CORE", (Object)jsonConsumer.getString("protocol"));
            Assert.assertEquals((String)"queue type", (Object)"anycast", (Object)jsonConsumer.getString("queueType"));
            Assert.assertNotEquals((String)"id", (Object)"", (Object)jsonConsumer.getString("id"));
            Assert.assertNotEquals((String)"session", (Object)"", (Object)jsonConsumer.getString("session"));
            Assert.assertEquals((String)"clientID", (Object)"", (Object)jsonConsumer.getString("clientID"));
            Assert.assertEquals((String)"user", (Object)"", (Object)jsonConsumer.getString("user"));
            Assert.assertNotEquals((String)"localAddress", (Object)"", (Object)jsonConsumer.getString("localAddress"));
            Assert.assertNotEquals((String)"remoteAddress", (Object)"", (Object)jsonConsumer.getString("remoteAddress"));
            Assert.assertNotEquals((String)"creationTime", (Object)"", (Object)jsonConsumer.getString("creationTime"));
        }
    }

    @Test
    public void testListConsumersOrder() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSessionImpl session1 = (ClientSessionImpl)csf.createSession();
            ClientSessionImpl session2 = (ClientSessionImpl)csf.createSession();
            ClientSessionImpl session3 = (ClientSessionImpl)csf.createSession();
            ClientConsumer consumer_s1 = session1.createConsumer(queueName1);
            Thread.sleep(500L);
            ClientConsumer consumer_s2 = session2.createConsumer(queueName1);
            Thread.sleep(500L);
            ClientConsumer consumer_s3 = session3.createConsumer(queueName1);
            String filterString = this.createJsonFilter("queue", "EQUALS", queueName1.toString());
            String consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            JsonObject consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            JsonArray array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"Consumer1 default order", (Object)session1.getName(), (Object)array.getJsonObject(0).getString("session"));
            Assert.assertEquals((String)"Consumer2 default order", (Object)session2.getName(), (Object)array.getJsonObject(1).getString("session"));
            Assert.assertEquals((String)"Consumer3 default order", (Object)session3.getName(), (Object)array.getJsonObject(2).getString("session"));
            filterString = this.createJsonFilter("queue", "EQUALS", queueName1.toString(), "creationTime", "desc");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of consumers returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"Consumer3 creation time", (Object)session3.getName(), (Object)array.getJsonObject(0).getString("session"));
            Assert.assertEquals((String)"Consumer2 creation time", (Object)session2.getName(), (Object)array.getJsonObject(1).getString("session"));
            Assert.assertEquals((String)"Consumer1 creation time", (Object)session1.getName(), (Object)array.getJsonObject(2).getString("session"));
        }
    }

    @Test
    public void testListSessions() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSessionImpl session1 = (ClientSessionImpl)csf.createSession();
            Thread.sleep(500L);
            ClientSessionImpl session2 = (ClientSessionImpl)csf.createSession();
            Thread.sleep(500L);
            ClientSessionImpl session3 = (ClientSessionImpl)csf.createSession();
            ClientConsumer consumer1_s1 = session1.createConsumer(queueName1);
            ClientConsumer consumer2_s1 = session1.createConsumer(queueName1);
            ClientConsumer consumer1_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer2_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer3_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer4_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer1_s3 = session3.createConsumer(queueName1);
            ClientConsumer consumer2_s3 = session3.createConsumer(queueName1);
            ClientConsumer consumer3_s3 = session3.createConsumer(queueName1);
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1");
            String sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            JsonObject sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            JsonArray array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of sessions returned from query", (long)3L, (long)array.size());
            JsonObject jsonSession = array.getJsonObject(0);
            Assert.assertNotEquals((String)"id", (Object)"", (Object)jsonSession.getString("id"));
            Assert.assertEquals((String)"user", (Object)"", (Object)jsonSession.getString("user"));
            Assert.assertNotEquals((String)"creationTime", (Object)"", (Object)jsonSession.getString("creationTime"));
            Assert.assertEquals((String)"consumerCount", (long)2L, (long)jsonSession.getInt("consumerCount"));
            Assert.assertTrue((String)"producerCount", (0 <= jsonSession.getInt("producerCount") ? (byte)1 : 0) != 0);
            Assert.assertNotEquals((String)"connectionID", (Object)"", (Object)jsonSession.getString("connectionID"));
            Assert.assertEquals((String)"session1 location", (Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"));
            Assert.assertEquals((String)"session2 location", (Object)session2.getName(), (Object)array.getJsonObject(1).getString("id"));
            Assert.assertEquals((String)"session3 location", (Object)session3.getName(), (Object)array.getJsonObject(2).getString("id"));
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "consumerCount", "asc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assert.assertTrue((String)"number of sessions returned from query", (3 == array.size() ? (byte)1 : 0) != 0);
            Assert.assertEquals((String)"session1 ordered by consumer", (Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"));
            Assert.assertEquals((String)"session3 ordered by consumer", (Object)session3.getName(), (Object)array.getJsonObject(1).getString("id"));
            Assert.assertEquals((String)"session2 ordered by consumer", (Object)session2.getName(), (Object)array.getJsonObject(2).getString("id"));
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "consumerCount", "asc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assert.assertTrue((String)"number of sessions returned from query", (3 == array.size() ? (byte)1 : 0) != 0);
            Assert.assertEquals((String)"session1 ordered by consumer", (Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"));
            Assert.assertEquals((String)"session3 ordered by consumer", (Object)session3.getName(), (Object)array.getJsonObject(1).getString("id"));
            Assert.assertEquals((String)"session2 ordered by consumer", (Object)session2.getName(), (Object)array.getJsonObject(2).getString("id"));
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "creationTime", "desc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assert.assertTrue((String)"number of sessions returned from query", (3 == array.size() ? (byte)1 : 0) != 0);
            Assert.assertEquals((String)"session3 ordered by creationTime", (Object)session3.getName(), (Object)array.getJsonObject(0).getString("id"));
            Assert.assertEquals((String)"session2 ordered by creationTime", (Object)session2.getName(), (Object)array.getJsonObject(1).getString("id"));
            Assert.assertEquals((String)"session1 ordered by creationTime", (Object)session1.getName(), (Object)array.getJsonObject(2).getString("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RetryMethod(retries=2)
    @Test
    public void testListConnections() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientSessionFactoryImpl csf = null;
        ClientSessionFactoryImpl csf2 = null;
        ClientSessionFactoryImpl csf3 = null;
        try (ServerLocator locator = this.createInVMNonHALocator();){
            csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            Thread.sleep(50L);
            csf2 = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            Thread.sleep(50L);
            csf3 = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            ClientSession session1_c1 = csf.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c1 = csf.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session1_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session3_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session4_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session1_c4 = csf3.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c4 = csf3.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session3_c4 = csf3.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            String filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1");
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            System.err.println(connectionsAsJsonString);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)3L, (long)array.size());
            JsonObject jsonConnection = array.getJsonObject(0);
            Assert.assertNotEquals((String)"connectionID", (Object)"", (Object)jsonConnection.getString("connectionID"));
            Assert.assertNotEquals((String)"remoteAddress", (Object)"", (Object)jsonConnection.getString("remoteAddress"));
            Assert.assertEquals((String)"users", (Object)"guest", (Object)jsonConnection.getString("users"));
            Assert.assertNotEquals((String)"creationTime", (Object)"", (Object)jsonConnection.getString("creationTime"));
            Assert.assertNotEquals((String)"implementation", (Object)"", (Object)jsonConnection.getString("implementation"));
            Assert.assertNotEquals((String)"protocol", (Object)"", (Object)jsonConnection.getString("protocol"));
            Assert.assertEquals((String)"clientID", (Object)"", (Object)jsonConnection.getString("clientID"));
            Assert.assertNotEquals((String)"localAddress", (Object)"", (Object)jsonConnection.getString("localAddress"));
            Assert.assertEquals((String)"sessionCount", (long)2L, (long)jsonConnection.getInt("sessionCount"));
            Assert.assertEquals((String)"connection1 default Order", (Object)csf.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"));
            Assert.assertEquals((String)"connection2 default Order", (Object)csf2.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"));
            Assert.assertEquals((String)"connection3 session Order", (Object)csf3.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"));
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "users", "asc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"connection1 users Order", (Object)"guest", (Object)array.getJsonObject(0).getString("users"));
            Assert.assertEquals((String)"connection3 users Order", (Object)"guest,myUser", (Object)array.getJsonObject(1).getString("users"));
            Assert.assertEquals((String)"connection2 users Order", (Object)"myUser", (Object)array.getJsonObject(2).getString("users"));
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "users", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"connection2 users Order", (Object)"myUser", (Object)array.getJsonObject(0).getString("users"));
            Assert.assertEquals((String)"connection3 users Order", (Object)"guest,myUser", (Object)array.getJsonObject(1).getString("users"));
            Assert.assertEquals((String)"connection1 users Order", (Object)"guest", (Object)array.getJsonObject(2).getString("users"));
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "sessionCount", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"connection2 session Order", (Object)csf2.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"));
            Assert.assertEquals((String)"connection3 session Order", (Object)csf3.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"));
            Assert.assertEquals((String)"connection1 session Order", (Object)csf.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"));
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "creationTime", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)3L, (long)array.size());
            Assert.assertEquals((String)"connection3 creationTime Order", (Object)csf3.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"));
            Assert.assertEquals((String)"connection2 creationTime Order", (Object)csf2.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"));
            Assert.assertEquals((String)"connection1 creationTime Order", (Object)csf.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"));
        }
        finally {
            if (csf != null) {
                csf.close();
            }
            if (csf2 != null) {
                csf.close();
            }
            if (csf3 != null) {
                csf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListConnectionsClientID() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ClientSessionFactoryImpl csf = null;
             ServerLocator locator = this.createInVMNonHALocator();){
            csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            ClientSession session1_c1 = csf.createSession();
            ClientSession session2_c1 = csf.createSession();
            session1_c1.addMetaData("jms-session", "");
            session1_c1.addMetaData("jms-client-id", "MYClientID");
            String filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1");
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assert.assertEquals((String)"number of connections returned from query", (long)1L, (long)array.size());
            JsonObject jsonConnection = array.getJsonObject(0);
            Assert.assertEquals((String)"clientID", (Object)"MYClientID", (Object)jsonConnection.getString("clientID"));
        }
    }

    @Test
    public void testListProducers() throws Exception {
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientSession session2 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            ClientProducer producer2 = session1.createProducer(addressName1);
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assert.assertTrue((String)"number of producers returned from query", (2 <= array.size() ? (byte)1 : 0) != 0);
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assert.assertNotEquals((String)"id", (Object)"", (Object)jsonSession.getString("id"));
                Assert.assertNotEquals((String)"session", (Object)"", (Object)jsonSession.getString("session"));
                Assert.assertEquals((String)"clientID", (Object)"", (Object)jsonSession.getString("clientID"));
                Assert.assertEquals((String)"user", (Object)"", (Object)jsonSession.getString("user"));
                Assert.assertNotEquals((String)"protocol", (Object)"", (Object)jsonSession.getString("protocol"));
                Assert.assertEquals((String)"address", (Object)"", (Object)jsonSession.getString("address"));
                Assert.assertNotEquals((String)"localAddress", (Object)"", (Object)jsonSession.getString("localAddress"));
                Assert.assertNotEquals((String)"remoteAddress", (Object)"", (Object)jsonSession.getString("remoteAddress"));
                Assert.assertNotEquals((String)"creationTime", (Object)"", (Object)jsonSession.getString("creationTime"));
            }
            Assert.assertTrue((String)"Valid session not found", (boolean)foundElement);
        }
    }

    @Test
    public void testMemoryUsagePercentage() throws Exception {
        int MESSAGE_SIZE = 100000;
        String name1 = "messageUsagePercentage.test.1";
        this.server.stop();
        this.server.getConfiguration().setGlobalMaxSize(-1L);
        this.server.start();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ActiveMQServerControlTest.assertEquals((String)"Memory Usage before adding messages", (long)0L, (long)serverControl.getAddressMemoryUsage());
        ActiveMQServerControlTest.assertEquals((String)"MemoryUsagePercentage", (long)0L, (long)serverControl.getAddressMemoryUsagePercentage());
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            if (this.legacyCreateQueue) {
                session.createQueue(name1, RoutingType.ANYCAST, name1);
            } else {
                session.createQueue(new QueueConfiguration(name1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            }
            Queue serverQueue = this.server.locateQueue(SimpleString.toSimpleString((String)name1));
            Assert.assertFalse((boolean)serverQueue.isDurable());
            ClientProducer producer1 = session.createProducer(name1);
            this.sendMessagesWithPredefinedSize(30, session, producer1, 100000);
            ActiveMQServerControlTest.assertTrue((String)"Memory Usage within range ", (3000000L < serverControl.getAddressMemoryUsage() && serverControl.getAddressMemoryUsage() < 3100000L ? (byte)1 : 0) != 0);
            ActiveMQServerControlTest.assertEquals((String)"MemoryUsagePercentage", (long)0L, (long)serverControl.getAddressMemoryUsagePercentage());
        }
    }

    @Test
    public void testMemoryUsage() throws Exception {
        int MESSAGE_SIZE = 100000;
        String name1 = "messageUsage.test.1";
        String name2 = "messageUsage.test.2";
        this.server.stop();
        this.server.getConfiguration().setGlobalMaxSize(5000000L);
        this.server.start();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ActiveMQServerControlTest.assertEquals((String)"Memory Usage before adding messages", (long)0L, (long)serverControl.getAddressMemoryUsage());
        ActiveMQServerControlTest.assertEquals((String)"MemoryUsagePercentage", (long)0L, (long)serverControl.getAddressMemoryUsagePercentage());
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            if (this.legacyCreateQueue) {
                session.createQueue(name1, RoutingType.ANYCAST, name1);
                session.createQueue(name2, RoutingType.ANYCAST, name2);
            } else {
                session.createQueue(new QueueConfiguration(name1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
                session.createQueue(new QueueConfiguration(name2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            }
            Queue serverQueue = this.server.locateQueue(SimpleString.toSimpleString((String)name1));
            Assert.assertFalse((boolean)serverQueue.isDurable());
            ClientProducer producer1 = session.createProducer(name1);
            ClientProducer producer2 = session.createProducer(name2);
            this.sendMessagesWithPredefinedSize(10, session, producer1, 100000);
            this.sendMessagesWithPredefinedSize(10, session, producer2, 100000);
            ActiveMQServerControlTest.assertTrue((String)"Memory Usage within range ", (2000000L < serverControl.getAddressMemoryUsage() && serverControl.getAddressMemoryUsage() < 0x200B20L ? (byte)1 : 0) != 0);
            ActiveMQServerControlTest.assertTrue((String)"MemoryUsagePercentage", (40 <= serverControl.getAddressMemoryUsagePercentage() && 42 >= serverControl.getAddressMemoryUsagePercentage() ? (byte)1 : 0) != 0);
        }
    }

    @Test
    public void testConnectorServiceManagement() throws Exception {
        ActiveMQServerControl managementControl = this.createManagementControl();
        managementControl.createConnectorService("myconn", FakeConnectorServiceFactory.class.getCanonicalName(), new HashMap());
        Assert.assertEquals((long)1L, (long)this.server.getConnectorsService().getConnectors().size());
        managementControl.createConnectorService("myconn2", FakeConnectorServiceFactory.class.getCanonicalName(), new HashMap());
        Assert.assertEquals((long)2L, (long)this.server.getConnectorsService().getConnectors().size());
        managementControl.destroyConnectorService("myconn");
        Assert.assertEquals((long)1L, (long)this.server.getConnectorsService().getConnectors().size());
        Assert.assertEquals((Object)"myconn2", (Object)managementControl.getConnectorServices()[0]);
    }

    @Test
    public void testCloseCOREclient() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer COREclient = receiveClientSession.createConsumer(name);
        ServerSession ss = (ServerSession)this.server.getSessions().iterator().next();
        ServerConsumer sc = (ServerConsumer)ss.getServerConsumers().iterator().next();
        Assert.assertFalse((boolean)COREclient.isClosed());
        serverControl.closeConsumerWithID(((ClientSessionImpl)receiveClientSession).getName(), Long.toString(sc.sequentialID()));
        Wait.waitFor(() -> COREclient.isClosed());
        Assert.assertTrue((boolean)COREclient.isClosed());
    }

    @Test
    public void testCloseJMSclient() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        Connection conn = cf.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)"ConsumerTestTopic");
        MessageConsumer JMSclient = session.createConsumer((Destination)topic, "test1");
        long clientID = -1L;
        String sessionID = ((ClientSessionImpl)((ActiveMQSession)session).getCoreSession()).getName();
        Set sessions = this.server.getSessions();
        for (ServerSession sess : sessions) {
            if (!sess.getName().equals(sessionID.toString())) continue;
            Set serverConsumers = sess.getServerConsumers();
            for (ServerConsumer serverConsumer : serverConsumers) {
                clientID = serverConsumer.sequentialID();
            }
        }
        Assert.assertFalse((boolean)((ActiveMQMessageConsumer)JMSclient).isClosed());
        serverControl.closeConsumerWithID(sessionID, Long.toString(clientID));
        Wait.waitFor(() -> ((ActiveMQMessageConsumer)JMSclient).isClosed());
        Assert.assertTrue((boolean)((ActiveMQMessageConsumer)JMSclient).isClosed());
    }

    @Test
    public void testAddUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.addUser("x", "x", "x", true);
            ActiveMQServerControlTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.removeUser("x");
            ActiveMQServerControlTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testListUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.listUser("x");
            ActiveMQServerControlTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResetUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.resetUser("x", "x", "x");
            ActiveMQServerControlTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBrokerConnections() throws Exception {
        class Fake
        implements BrokerConnection {
            String name;
            boolean started = false;

            Fake(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getProtocol() {
                return "fake";
            }

            public void start() throws Exception {
                this.started = true;
            }

            public void stop() throws Exception {
                this.started = false;
            }

            public boolean isStarted() {
                return this.started;
            }
        }
        Fake fake = new Fake("fake" + UUIDGenerator.getInstance().generateStringUUID());
        this.server.registerBrokerConnection((BrokerConnection)fake);
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            String result = serverControl.listBrokerConnections();
            Assert.assertTrue((boolean)result.contains(fake.getName()));
            serverControl.startBrokerConnection(fake.getName());
            Assert.assertTrue((boolean)fake.isStarted());
            serverControl.stopBrokerConnection(fake.getName());
            Assert.assertFalse((boolean)fake.isStarted());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void scaleDown(ScaleDownHandler handler) throws Exception {
        SimpleString address = new SimpleString("testQueue");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverId", "2");
        Configuration config = this.createDefaultInVMConfig(2).clearAcceptorConfigurations().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName(), params)).setSecurityEnabled(false);
        ActiveMQServer server2 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, null, (boolean)true));
        this.conf.clearConnectorConfigurations().addConnectorConfiguration("server2-connector", new TransportConfiguration(INVM_CONNECTOR_FACTORY, params));
        server2.start();
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(address, RoutingType.ANYCAST, address, null, true, false, -1, false, false);
        } else {
            this.server.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        server2.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            server2.createQueue(address, RoutingType.ANYCAST, address, null, true, false, -1, false, false);
        } else {
            server2.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        ClientProducer producer = session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("m" + i);
            producer.send((Message)message);
        }
        ActiveMQServerControl managementControl = this.createManagementControl();
        handler.scaleDown(managementControl);
        locator.close();
        locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY, params)}));
        csf = this.createSessionFactory(locator);
        session = csf.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage m = consumer.receive(5000L);
            ActiveMQServerControlTest.assertNotNull((Object)m);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.connectorConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        this.conf = this.createDefaultNettyConfig().setJMXManagementEnabled(true).addConnectorConfiguration(this.connectorConfig.getName(), this.connectorConfig);
        this.conf.setSecurityEnabled(true);
        SecurityConfiguration securityConfiguration = new SecurityConfiguration();
        securityConfiguration.addUser("guest", "guest");
        securityConfiguration.addUser("myUser", "myPass");
        securityConfiguration.addRole("guest", "guest");
        securityConfiguration.addRole("myUser", "guest");
        securityConfiguration.setDefaultUser("guest");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), securityConfiguration);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.conf, (MBeanServer)this.mbeanServer, (ActiveMQSecurityManager)securityManager, (boolean)true));
        this.server.start();
        HashSet<Role> role = new HashSet<Role>();
        role.add(new Role("guest", true, true, true, true, true, true, true, true, true, true));
        this.server.getSecurityRepository().addMatch("#", role);
    }

    protected ActiveMQServerControl createManagementControl() throws Exception {
        return ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
    }

    private String createJsonFilter(String fieldName, String operationName, String value) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("field", fieldName);
        filterMap.put("operation", operationName);
        filterMap.put("value", value);
        JsonObject jsonFilterObject = JsonUtil.toJsonObject(filterMap);
        return jsonFilterObject.toString();
    }

    private String createJsonFilter(String fieldName, String operationName, String value, String sortColumn, String sortOrder) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("field", fieldName);
        filterMap.put("operation", operationName);
        filterMap.put("value", value);
        filterMap.put("sortColumn", sortColumn);
        filterMap.put("sortOrder", sortOrder);
        JsonObject jsonFilterObject = JsonUtil.toJsonObject(filterMap);
        return jsonFilterObject.toString();
    }

    private void sendMessagesWithPredefinedSize(int numberOfMessages, ClientSession session, ClientProducer producer, int messageSize) throws Exception {
        int i;
        byte[] body = new byte[messageSize];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (i = 1; i <= messageSize; ++i) {
            bb.put(ActiveMQServerControlTest.getSamplebyte((long)i));
        }
        for (i = 0; i < numberOfMessages; ++i) {
            ClientMessage message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
    }

    static interface ScaleDownHandler {
        public void scaleDown(ActiveMQServerControl var1) throws Exception;
    }
}

