/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrashOnCompactTest
extends SpawnedTestBase {
    static int OK = 2;
    static int NOT_OK = 3;

    @Before
    public void setup() throws Exception {
    }

    @Test
    public void testCrashCompact() throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)CrashOnCompactTest.class.getCanonicalName(), (String[])new String[]{this.getTestDirfile().getAbsolutePath()});
        Assert.assertEquals((long)OK, (long)process.waitFor());
        this.checkJournalSize();
    }

    @Test
    public void testAddJournal() throws Exception {
        CrashOnCompactTest.addJournal(this.getTestDirfile(), false);
        this.checkJournalSize();
    }

    private void checkJournalSize() throws Exception {
        JournalImpl journal = CrashOnCompactTest.createJournal(this.getTestDirfile(), false);
        ArrayList info = new ArrayList();
        ArrayList txInfo = new ArrayList();
        journal.load(info, txInfo, new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }
        });
        Assert.assertEquals((long)900L, (long)info.size());
    }

    private static void addJournal(File folder, boolean crash) throws Exception {
        int i;
        JournalImpl journal = CrashOnCompactTest.createJournal(folder, crash);
        journal.loadInternalOnly();
        for (i = 0; i < 1000; ++i) {
            journal.appendAddRecord((long)i, (byte)1, new byte[5], true);
        }
        for (i = 0; i < 100; ++i) {
            journal.appendDeleteRecord((long)i, true);
        }
        journal.compact();
        journal.stop();
    }

    public static void main(String[] arg) {
        try {
            CrashOnCompactTest.addJournal(new File(arg[0]), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(NOT_OK);
    }

    private static JournalImpl createJournal(File folder, final boolean crash) throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(folder, 10);
        JournalImpl journal = new JournalImpl(102400, 2, 2, 0, 0, (SequentialFileFactory)factory, "jrntest", "jrn", 512){

            protected SequentialFile writeControlFile(SequentialFileFactory fileFactory, List<JournalFile> files, List<JournalFile> newFiles, List<Pair<String, String>> renames) throws Exception {
                if (crash) {
                    SequentialFile controlFile = fileFactory.createSequentialFile("journal-rename-control.ctr");
                    controlFile.open();
                    controlFile.close();
                    System.err.println("crashing after creation of control file");
                    System.exit(OK);
                }
                return JournalCompactor.writeControlFile((SequentialFileFactory)fileFactory, files, newFiles, renames);
            }
        };
        journal.setAutoReclaim(false);
        journal.start();
        return journal;
    }
}

