/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.config;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class JMSServerConfigParserTest
extends ActiveMQTestBase {
    @Test
    public void testParsing() throws Exception {
        Configuration config = this.createDefaultInVMConfig().addConnectorConfiguration("netty", new TransportConfiguration());
        String conf = "activemq-jms-for-JMSServerDeployerTest.xml";
        FileJMSConfiguration jmsconfig = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(conf);
        deploymentManager.addDeployable((Deployable)jmsconfig);
        deploymentManager.readConfiguration();
        JMSServerConfigParserTest.assertEquals((long)1L, (long)jmsconfig.getQueueConfigurations().size());
        JMSQueueConfiguration queueConfig = (JMSQueueConfiguration)jmsconfig.getQueueConfigurations().get(0);
        JMSServerConfigParserTest.assertEquals((Object)"fullConfigurationQueue", (Object)queueConfig.getName());
        JMSServerConfigParserTest.assertEquals((long)1L, (long)jmsconfig.getTopicConfigurations().size());
        TopicConfiguration topicConfig = (TopicConfiguration)jmsconfig.getTopicConfigurations().get(0);
        JMSServerConfigParserTest.assertEquals((Object)"fullConfigurationTopic", (Object)topicConfig.getName());
    }
}

