/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jdbc.store.journal;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.tests.integration.jdbc.store.journal.FakeEncodingSupportImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JDBCJournalTest
extends ActiveMQTestBase {
    @Rule
    public ThreadLeakCheckRule threadLeakCheckRule = new ThreadLeakCheckRule();
    private JDBCJournalImpl journal;
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;
    private SQLProvider sqlProvider;
    private DatabaseStorageConfiguration dbConf;
    @Parameterized.Parameter
    public boolean useAuthentication;

    @Parameterized.Parameters(name="authentication = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @After
    public void tearDown() throws Exception {
        this.journal.destroy();
        try {
            if (this.useAuthentication) {
                DriverManager.getConnection("jdbc:derby:;shutdown=true", this.getJdbcUser(), this.getJdbcPassword());
            } else {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.useAuthentication) {
            System.clearProperty("derby.connection.requireAuthentication");
            System.clearProperty("derby.user." + this.getJdbcUser());
        }
        this.scheduledExecutorService.shutdownNow();
        this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        this.scheduledExecutorService = null;
        this.executorService.shutdown();
        this.executorService = null;
    }

    protected String getJdbcUser() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.user", "testuser");
        }
        return null;
    }

    protected String getJdbcPassword() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.password", "testpassword");
        }
        return null;
    }

    @Before
    public void setup() throws Exception {
        this.dbConf = this.createDefaultDatabaseStorageConfiguration();
        if (this.useAuthentication) {
            System.setProperty("derby.connection.requireAuthentication", "true");
            System.setProperty("derby.user." + this.getJdbcUser(), this.getJdbcPassword());
            this.dbConf.setJdbcUser(this.getJdbcUser());
            this.dbConf.setJdbcPassword(this.getJdbcPassword());
        }
        this.sqlProvider = JDBCUtils.getSQLProvider((String)this.dbConf.getJdbcDriverClassName(), (String)this.dbConf.getMessageTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.MESSAGE_JOURNAL);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
        this.journal = new JDBCJournalImpl(this.dbConf.getConnectionProvider(), this.sqlProvider, this.scheduledExecutorService, (Executor)this.executorService, new IOCriticalErrorListener(){

            public void onIOException(Throwable code, String message, SequentialFile file) {
            }
        }, 5L);
        this.journal.start();
    }

    @Test
    public void testRestartEmptyJournal() throws SQLException {
        Assert.assertTrue((boolean)this.journal.isStarted());
        Assert.assertEquals((long)0L, (long)this.journal.getNumberOfRecords());
        this.journal.stop();
        this.journal.start();
        Assert.assertTrue((boolean)this.journal.isStarted());
    }

    @Test
    public void testConcurrentEmptyJournal() throws SQLException {
        Assert.assertTrue((boolean)this.journal.isStarted());
        Assert.assertEquals((long)0L, (long)this.journal.getNumberOfRecords());
        JDBCJournalImpl secondJournal = new JDBCJournalImpl(this.dbConf.getConnectionProvider(), this.sqlProvider, this.scheduledExecutorService, (Executor)this.executorService, (code, message, file) -> Assert.fail((String)message), 5L);
        secondJournal.start();
        try {
            Assert.assertTrue((boolean)secondJournal.isStarted());
        }
        finally {
            secondJournal.stop();
        }
    }

    @Test
    public void testInsertRecords() throws Exception {
        int noRecords = 10;
        for (int i = 0; i < noRecords; ++i) {
            this.journal.appendAddRecord((long)i, (byte)1, new byte[0], true);
        }
        JDBCJournalTest.assertEquals((long)noRecords, (long)this.journal.getNumberOfRecords());
    }

    @Test
    public void testCleanupTxRecords() throws Exception {
        this.journal.appendDeleteRecordTransactional(1L, 1L);
        this.journal.appendCommitRecord(1L, true);
        JDBCJournalTest.assertEquals((long)0L, (long)this.journal.getNumberOfRecords());
    }

    @Test
    public void testCleanupTxRecords4TransactionalRecords() throws Exception {
        this.journal.appendAddRecordTransactional(152L, 154L, (byte)13, new byte[0]);
        this.journal.appendCommitRecord(152L, true);
        JDBCJournalTest.assertEquals((long)2L, (long)this.journal.getNumberOfRecords());
        this.journal.appendDeleteRecordTransactional(236L, 154L);
        this.journal.appendCommitRecord(236L, true);
        JDBCJournalTest.assertEquals((long)0L, (long)this.journal.getNumberOfRecords());
    }

    @Test
    public void testCallbacks() throws Exception {
        int noRecords = 10;
        final CountDownLatch done = new CountDownLatch(10);
        IOCompletion completion = new IOCompletion(){

            public void storeLineUp() {
            }

            public void done() {
                done.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        };
        for (int i = 0; i < 10; ++i) {
            this.journal.appendAddRecord(1L, (byte)1, (EncodingSupport)new FakeEncodingSupportImpl(new byte[0]), true, completion);
        }
        this.journal.sync();
        done.await(5L, TimeUnit.SECONDS);
        JDBCJournalTest.assertEquals((long)done.getCount(), (long)0L);
    }

    @Test
    public void testReadJournal() throws Exception {
        int noRecords = 100;
        for (int i = 0; i < noRecords; ++i) {
            this.journal.appendAddRecord((long)i, (byte)i, new byte[i], true);
        }
        int noTx = 10;
        int noTxRecords = 100;
        for (int i = 1000; i < 1000 + noTx; ++i) {
            for (int j = 0; j < noTxRecords; ++j) {
                this.journal.appendAddRecordTransactional((long)i, Long.valueOf(i + "" + j).longValue(), (byte)1, new byte[0]);
            }
            this.journal.appendPrepareRecord((long)i, new byte[0], true);
            this.journal.appendCommitRecord((long)i, true);
        }
        Thread.sleep(2000L);
        ArrayList recordInfos = new ArrayList();
        ArrayList txInfos = new ArrayList();
        this.journal.load(recordInfos, txInfos, null);
        JDBCJournalTest.assertEquals((long)(noRecords + noTxRecords * noTx), (long)recordInfos.size());
    }
}

