/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.discovery;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.discovery.DiscoveryBaseTest;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiscoveryTest
extends DiscoveryBaseTest {
    private static final String TEST_JGROUPS_CONF_FILE = "test-jgroups-file_ping.xml";
    BroadcastGroup bg = null;
    BroadcastGroup bg1 = null;
    BroadcastGroup bg2 = null;
    BroadcastGroup bg3 = null;
    DiscoveryGroup dg = null;
    DiscoveryGroup dg1 = null;
    DiscoveryGroup dg2 = null;
    DiscoveryGroup dg3 = null;

    @Before
    public void prepareLoopback() {
        JChannelManager.getInstance().setLoopbackMessages(true);
    }

    @After
    public void tearDown() throws Exception {
        JChannelManager.getInstance().clear().setLoopbackMessages(false);
        DiscoveryTest.deleteDirectory((File)new File("./target/tmp/amqtest.ping.dir"));
        for (ActiveMQComponent component : new ActiveMQComponent[]{this.bg, this.bg1, this.bg2, this.bg3, this.dg, this.dg1, this.dg2, this.dg3}) {
            DiscoveryTest.stopComponent((ActiveMQComponent)component);
        }
        super.tearDown();
    }

    @Test
    public void testSimpleBroadcast() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = new BroadcastGroupImpl((NodeManager)new DiscoveryBaseTest.FakeNodeManager(this, nodeID), RandomUtil.randomString(), 0L, null, (BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.address1).setGroupPort(groupPort));
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testSimpleBroadcastJGropus() throws Exception {
        String nodeID = RandomUtil.randomString();
        this.bg = new BroadcastGroupImpl((NodeManager)new DiscoveryBaseTest.FakeNodeManager(this, nodeID), "broadcast", 100L, null, (BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE));
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = new DiscoveryGroup(nodeID + "1", "broadcast", 5000L, (BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE), null);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJGropusChannelReferenceCounting() throws Exception {
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        try {
            int i;
            int num = 100;
            BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
            for (int i2 = 0; i2 < num; ++i2) {
                receivers[i2] = factory.createBroadcastEndpoint();
                receivers[i2].openClient();
            }
            byte[] data = new byte[]{1, 2, 3, 4, 5};
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                byte[] received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                DiscoveryTest.assertNotNull((Object)received);
                DiscoveryTest.assertEquals((long)5L, (long)received.length);
                DiscoveryTest.assertEquals((long)1L, (long)received[0]);
                DiscoveryTest.assertEquals((long)2L, (long)received[1]);
                DiscoveryTest.assertEquals((long)3L, (long)received[2]);
                DiscoveryTest.assertEquals((long)4L, (long)received[3]);
                DiscoveryTest.assertEquals((long)5L, (long)received[4]);
            }
            for (i = 0; i < num - 1; ++i) {
                receivers[i].close(false);
            }
            byte[] data1 = receivers[num - 1].receiveBroadcast(5L, TimeUnit.SECONDS);
            DiscoveryTest.assertNull((Object)data1);
            broadcaster.broadcast(data);
            data1 = receivers[num - 1].receiveBroadcast(5L, TimeUnit.SECONDS);
            DiscoveryTest.assertNotNull((Object)data1);
            DiscoveryTest.assertEquals((long)5L, (long)data1.length);
            DiscoveryTest.assertEquals((long)1L, (long)data1[0]);
            DiscoveryTest.assertEquals((long)2L, (long)data1[1]);
            DiscoveryTest.assertEquals((long)3L, (long)data1[2]);
            DiscoveryTest.assertEquals((long)4L, (long)data1[3]);
            DiscoveryTest.assertEquals((long)5L, (long)data1[4]);
            receivers[num - 1].close(false);
        }
        finally {
            broadcaster.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJGropusChannelReferenceCounting1() throws Exception {
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        int num = 50;
        BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
        for (int i = 0; i < num; ++i) {
            receivers[i] = factory.createBroadcastEndpoint();
            receivers[i].openClient();
        }
        try {
            byte[] received;
            int i;
            byte[] data = new byte[]{1, 2, 3, 4, 5};
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                DiscoveryTest.assertNotNull((Object)received);
                DiscoveryTest.assertEquals((long)5L, (long)received.length);
                DiscoveryTest.assertEquals((long)1L, (long)received[0]);
                DiscoveryTest.assertEquals((long)2L, (long)received[1]);
                DiscoveryTest.assertEquals((long)3L, (long)received[2]);
                DiscoveryTest.assertEquals((long)4L, (long)received[3]);
                DiscoveryTest.assertEquals((long)5L, (long)received[4]);
            }
            for (i = 0; i < num; ++i) {
                receivers[i].close(false);
            }
            for (i = 0; i < num; ++i) {
                receivers[i] = factory.createBroadcastEndpoint();
                receivers[i].openClient();
            }
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                DiscoveryTest.assertNotNull((Object)received);
                DiscoveryTest.assertEquals((long)5L, (long)received.length);
                DiscoveryTest.assertEquals((long)1L, (long)received[0]);
                DiscoveryTest.assertEquals((long)2L, (long)received[1]);
                DiscoveryTest.assertEquals((long)3L, (long)received[2]);
                DiscoveryTest.assertEquals((long)4L, (long)received[3]);
                DiscoveryTest.assertEquals((long)5L, (long)received[4]);
            }
        }
        finally {
            for (int i = 0; i < num; ++i) {
                receivers[i].close(false);
            }
            broadcaster.close(true);
        }
    }

    @Test
    public void testJGropusChannelReferenceCounting2() throws Exception {
        byte[] received;
        int i;
        int i2;
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        int num = 50;
        BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
        for (i2 = 0; i2 < num; ++i2) {
            receivers[i2] = factory.createBroadcastEndpoint();
            receivers[i2].openClient();
        }
        for (i2 = 0; i2 < num / 2; ++i2) {
            receivers[i2].close(false);
        }
        for (i2 = 0; i2 < num / 2; ++i2) {
            receivers[i2] = factory.createBroadcastEndpoint();
            receivers[i2].openClient();
        }
        int num2 = 10;
        BroadcastEndpoint[] moreReceivers = new BroadcastEndpoint[num2];
        for (int i3 = 0; i3 < num2; ++i3) {
            moreReceivers[i3] = factory.createBroadcastEndpoint();
            moreReceivers[i3].openClient();
        }
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        broadcaster.broadcast(data);
        for (i = 0; i < num; ++i) {
            received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
            DiscoveryTest.assertNotNull((Object)received);
            DiscoveryTest.assertEquals((long)5L, (long)received.length);
            DiscoveryTest.assertEquals((long)1L, (long)received[0]);
            DiscoveryTest.assertEquals((long)2L, (long)received[1]);
            DiscoveryTest.assertEquals((long)3L, (long)received[2]);
            DiscoveryTest.assertEquals((long)4L, (long)received[3]);
            DiscoveryTest.assertEquals((long)5L, (long)received[4]);
        }
        for (i = 0; i < num2; ++i) {
            received = moreReceivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
            DiscoveryTest.assertNotNull((Object)received);
            DiscoveryTest.assertEquals((long)5L, (long)received.length);
            DiscoveryTest.assertEquals((long)1L, (long)received[0]);
            DiscoveryTest.assertEquals((long)2L, (long)received[1]);
            DiscoveryTest.assertEquals((long)3L, (long)received[2]);
            DiscoveryTest.assertEquals((long)4L, (long)received[3]);
            DiscoveryTest.assertEquals((long)5L, (long)received[4]);
        }
        for (i = 0; i < num; ++i) {
            receivers[i].close(false);
        }
        for (i = 0; i < num2; ++i) {
            moreReceivers[i].close(false);
        }
        broadcaster.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStraightSendReceiveJGroups() throws Exception {
        BroadcastEndpoint broadcaster = null;
        BroadcastEndpoint client = null;
        try {
            JGroupsFileBroadcastEndpointFactory endpointFactory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
            broadcaster = endpointFactory.createBroadcastEndpoint();
            broadcaster.openBroadcaster();
            client = endpointFactory.createBroadcastEndpoint();
            client.openClient();
            Thread.sleep(1000L);
            byte[] randomBytes = "PQP".getBytes();
            broadcaster.broadcast(randomBytes);
            byte[] btreceived = client.receiveBroadcast(5L, TimeUnit.SECONDS);
            this.instanceLog.debug((Object)("BTReceived = " + Arrays.toString(btreceived)));
            DiscoveryTest.assertNotNull((Object)btreceived);
            DiscoveryTest.assertEquals((long)randomBytes.length, (long)btreceived.length);
            for (int i = 0; i < randomBytes.length; ++i) {
                DiscoveryTest.assertEquals((long)randomBytes[i], (long)btreceived[i]);
            }
        }
        finally {
            try {
                if (broadcaster != null) {
                    broadcaster.close(true);
                }
                if (client != null) {
                    client.close(false);
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    @Test
    public void testSimpleBroadcastSpecificNIC() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress localAddress = InetAddress.getLoopbackAddress();
        this.instanceLog.debug((Object)("Local address is " + localAddress));
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), localAddress, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), localAddress, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testSimpleBroadcastWithStopStartDiscoveryGroup() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        this.bg.stop();
        this.dg.stop();
        this.dg.start();
        this.bg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testIgnoreTrafficFromOwnNode() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(nodeID, RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)0L, (long)entries.size());
    }

    @Test
    public void testSimpleBroadcastDifferentPort() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(DiscoveryTest.getUDPDiscoveryAddress());
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        int port2 = DiscoveryTest.getUDPDiscoveryPort((int)1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, port2, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
    }

    @Test
    public void testSimpleBroadcastDifferentAddressAndPort() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        InetAddress groupAddress2 = InetAddress.getByName(this.address2);
        int port2 = DiscoveryTest.getUDPDiscoveryPort((int)1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress2, port2, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
    }

    @Test
    public void testMultipleGroups() throws Exception {
        int groupPort1 = DiscoveryTest.getUDPDiscoveryPort();
        int groupPort2 = DiscoveryTest.getUDPDiscoveryPort((int)1);
        int groupPort3 = DiscoveryTest.getUDPDiscoveryPort((int)2);
        InetAddress groupAddress1 = InetAddress.getByName(this.address1);
        InetAddress groupAddress2 = InetAddress.getByName(this.address2);
        InetAddress groupAddress3 = InetAddress.getByName(this.address3);
        int timeout = 5000;
        String node1 = UUIDGenerator.getInstance().generateStringUUID();
        String node2 = UUIDGenerator.getInstance().generateStringUUID();
        String node3 = UUIDGenerator.getInstance().generateStringUUID();
        this.bg1 = this.newBroadcast(node1, RandomUtil.randomString(), null, -1, groupAddress1, groupPort1);
        this.bg2 = this.newBroadcast(node2, RandomUtil.randomString(), null, -1, groupAddress2, groupPort2);
        this.bg3 = this.newBroadcast(node3, RandomUtil.randomString(), null, -1, groupAddress3, groupPort3);
        this.bg2.start();
        this.bg1.start();
        this.bg3.start();
        TransportConfiguration live1 = this.generateTC("live1");
        TransportConfiguration live2 = this.generateTC("live2");
        TransportConfiguration live3 = this.generateTC("live3");
        this.bg1.addConnector(live1);
        this.bg2.addConnector(live2);
        this.bg3.addConnector(live3);
        this.dg1 = this.newDiscoveryGroup("group-1::" + RandomUtil.randomString(), "group-1::" + RandomUtil.randomString(), null, groupAddress1, groupPort1, 5000L);
        this.dg1.start();
        this.dg2 = this.newDiscoveryGroup("group-2::" + RandomUtil.randomString(), "group-2::" + RandomUtil.randomString(), null, groupAddress2, groupPort2, 5000L);
        this.dg2.start();
        this.dg3 = this.newDiscoveryGroup("group-3::" + RandomUtil.randomString(), "group-3::" + RandomUtil.randomString(), null, groupAddress3, groupPort3, 5000L);
        this.dg3.start();
        this.bg1.broadcastConnectors();
        this.bg2.broadcastConnectors();
        this.bg3.broadcastConnectors();
        boolean ok = this.dg1.waitForBroadcast(5000L);
        Assert.assertTrue((boolean)ok);
        List entries = this.dg1.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg2.waitForBroadcast(5000L);
        Assert.assertTrue((boolean)ok);
        entries = this.dg2.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live2), entries);
        ok = this.dg3.waitForBroadcast(5000L);
        Assert.assertTrue((boolean)ok);
        entries = this.dg3.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live3), entries);
    }

    @Test
    public void testDiscoveryListenersCalled() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        DiscoveryBaseTest.MyListener listener1 = new DiscoveryBaseTest.MyListener();
        DiscoveryBaseTest.MyListener listener2 = new DiscoveryBaseTest.MyListener();
        DiscoveryBaseTest.MyListener listener3 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener1);
        this.dg.registerListener((DiscoveryListener)listener2);
        this.dg.registerListener((DiscoveryListener)listener3);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        Assert.assertTrue((boolean)listener3.called);
        listener1.called = false;
        listener2.called = false;
        listener3.called = false;
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
        Assert.assertFalse((boolean)listener3.called);
    }

    @Test
    public void testConnectorsUpdatedMultipleBroadcasters() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String node1 = RandomUtil.randomString();
        String node2 = RandomUtil.randomString();
        String node3 = RandomUtil.randomString();
        this.bg1 = this.newBroadcast(node1, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg1.start();
        this.bg2 = this.newBroadcast(node2, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg2.start();
        this.bg3 = this.newBroadcast(node3, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg3.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg1.addConnector(live1);
        TransportConfiguration live2 = this.generateTC();
        this.bg2.addConnector(live2);
        TransportConfiguration live3 = this.generateTC();
        this.bg3.addConnector(live3);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        DiscoveryBaseTest.MyListener listener1 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener1);
        DiscoveryBaseTest.MyListener listener2 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener2);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg1, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2), entries);
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg3, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg1, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg3, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg2.removeConnector(live2);
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        Thread.sleep(1000L);
        this.bg1.broadcastConnectors();
        boolean ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live3), entries);
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg1.removeConnector(live1);
        this.bg3.removeConnector(live3);
        Thread.sleep(1000L);
        this.bg1.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)0L, (long)entries.size());
        Assert.assertTrue((boolean)listener1.called);
        Assert.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg1.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)0L, (long)entries.size());
        Assert.assertFalse((boolean)listener1.called);
        Assert.assertFalse((boolean)listener2.called);
    }

    @Test
    public void testMultipleDiscoveryGroups() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg1 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg2 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg3 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg1.start();
        this.dg2.start();
        this.dg3.start();
        this.bg.broadcastConnectors();
        boolean ok = this.dg1.waitForBroadcast(1000L);
        Assert.assertTrue((boolean)ok);
        List entries = this.dg1.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg2.waitForBroadcast(1000L);
        Assert.assertTrue((boolean)ok);
        entries = this.dg2.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg3.waitForBroadcast(1000L);
        Assert.assertTrue((boolean)ok);
        entries = this.dg3.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        this.bg.stop();
        this.dg1.stop();
        this.dg2.stop();
        this.dg3.stop();
    }

    @Test
    public void testDiscoveryGroupNotifications() throws Exception {
        SimpleNotificationService notifService = new SimpleNotificationService();
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        notifService.addNotificationListener(notifListener);
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L, notifService);
        Assert.assertEquals((long)0L, (long)notifListener.getNotifications().size());
        this.dg.start();
        Assert.assertEquals((long)1L, (long)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assert.assertEquals((Object)CoreNotificationType.DISCOVERY_GROUP_STARTED, (Object)notif.getType());
        Assert.assertEquals((Object)this.dg.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
        this.dg.stop();
        Assert.assertEquals((long)2L, (long)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assert.assertEquals((Object)CoreNotificationType.DISCOVERY_GROUP_STOPPED, (Object)notif.getType());
        Assert.assertEquals((Object)this.dg.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
    }

    @Test
    public void testBroadcastGroupNotifications() throws Exception {
        SimpleNotificationService notifService = new SimpleNotificationService();
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        notifService.addNotificationListener(notifListener);
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.setNotificationService((NotificationService)notifService);
        Assert.assertEquals((long)0L, (long)notifListener.getNotifications().size());
        this.bg.start();
        Assert.assertEquals((long)1L, (long)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assert.assertEquals((Object)CoreNotificationType.BROADCAST_GROUP_STARTED, (Object)notif.getType());
        Assert.assertEquals((Object)this.bg.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
        this.bg.stop();
        Assert.assertEquals((long)2L, (long)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assert.assertEquals((Object)CoreNotificationType.BROADCAST_GROUP_STOPPED, (Object)notif.getType());
        Assert.assertEquals((Object)this.bg.getName(), (Object)notif.getProperties().getSimpleStringProperty(new SimpleString("name")).toString());
    }
}

