/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.util;

import java.util.concurrent.locks.Lock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CommandConfirmationHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ResponseHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;

public class BackupSyncDelay
implements Interceptor {
    private final ReplicationChannelHandler handler;
    private final ActiveMQServer backup;
    private final ActiveMQServer live;

    public void deliverUpToDateMsg() {
        this.live.getRemotingService().removeIncomingInterceptor((BaseInterceptor)this);
        if (this.backup.isStarted()) {
            this.handler.deliver();
        }
    }

    public BackupSyncDelay(ActiveMQServer backup, ActiveMQServer live, byte packetCode) {
        this.backup = backup;
        this.live = live;
        live.getRemotingService().addIncomingInterceptor((BaseInterceptor)this);
        this.handler = new ReplicationChannelHandler(packetCode);
    }

    public BackupSyncDelay(TestableServer backupServer, TestableServer liveServer) {
        this(backupServer.getServer(), liveServer.getServer(), 120);
    }

    public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
        if (packet.getType() == 115) {
            try {
                SharedNothingBackupActivation activation;
                Activation backupActivation = this.backup.getActivation();
                ReplicationEndpoint repEnd = null;
                if (backupActivation instanceof SharedNothingBackupActivation) {
                    activation = (SharedNothingBackupActivation)backupActivation;
                    repEnd = activation.getReplicationEndpoint();
                } else if (backupActivation instanceof ReplicationBackupActivation) {
                    activation = (ReplicationBackupActivation)backupActivation;
                    repEnd = activation.getReplicationEndpoint();
                }
                if (repEnd == null) {
                    throw new NullPointerException("replication endpoint isn't supposed to be null");
                }
                this.handler.addSubHandler(repEnd);
                Channel repChannel = repEnd.getChannel();
                repChannel.setHandler((ChannelHandler)this.handler);
                this.handler.setChannel(repChannel);
                this.live.getRemotingService().removeIncomingInterceptor((BaseInterceptor)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static class ChannelWrapper
    implements Channel {
        private final Channel channel;

        public ChannelWrapper(Channel channel) {
            this.channel = channel;
        }

        public boolean send(Packet packet, boolean flushConnection) {
            return this.channel.send(packet, flushConnection);
        }

        public String toString() {
            return "ChannelWrapper(" + this.channel + ")";
        }

        public long getID() {
            return this.channel.getID();
        }

        public boolean send(Packet packet) {
            return true;
        }

        public boolean sendBatched(Packet packet) {
            throw new UnsupportedOperationException();
        }

        public void flushConnection() {
            throw new UnsupportedOperationException();
        }

        public boolean sendAndFlush(Packet packet) {
            throw new UnsupportedOperationException();
        }

        public Packet sendBlocking(Packet packet, byte expected) throws ActiveMQException {
            throw new UnsupportedOperationException();
        }

        public void setHandler(ChannelHandler handler) {
            throw new UnsupportedOperationException();
        }

        public ChannelHandler getHandler() {
            throw new UnsupportedOperationException();
        }

        public void endOfBatch() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public void transferConnection(CoreRemotingConnection newConnection) {
            throw new UnsupportedOperationException();
        }

        public int getReconnectID() {
            return 0;
        }

        public boolean send(Packet packet, int reconnectID) {
            return false;
        }

        public Packet sendBlocking(Packet packet, int reconnectID, byte expectedPacket) throws ActiveMQException {
            return null;
        }

        public void replayCommands(int lastConfirmedCommandID) {
            throw new UnsupportedOperationException();
        }

        public int getLastConfirmedCommandID() {
            throw new UnsupportedOperationException();
        }

        public boolean isLocked() {
            return false;
        }

        public void lock() {
            throw new UnsupportedOperationException();
        }

        public void unlock() {
            throw new UnsupportedOperationException();
        }

        public void returnBlocking() {
            throw new UnsupportedOperationException();
        }

        public void returnBlocking(Throwable cause) {
            throw new UnsupportedOperationException();
        }

        public Lock getLock() {
            throw new UnsupportedOperationException();
        }

        public CoreRemotingConnection getConnection() {
            throw new UnsupportedOperationException();
        }

        public void confirm(Packet packet) {
            throw new UnsupportedOperationException();
        }

        public void setCommandConfirmationHandler(CommandConfirmationHandler handler) {
            throw new UnsupportedOperationException();
        }

        public void setResponseHandler(ResponseHandler handler) {
            throw new UnsupportedOperationException();
        }

        public void flushConfirmations() {
            throw new UnsupportedOperationException();
        }

        public void handlePacket(Packet packet) {
            throw new UnsupportedOperationException();
        }

        public void clearCommands() {
            throw new UnsupportedOperationException();
        }

        public int getConfirmationWindowSize() {
            throw new UnsupportedOperationException();
        }

        public void setTransferring(boolean transferring) {
            throw new UnsupportedOperationException();
        }

        public boolean supports(byte packetID) {
            return true;
        }

        public boolean supports(byte packetID, int version) {
            return true;
        }
    }

    public static class ReplicationChannelHandler
    implements ChannelHandler {
        private ReplicationEndpoint handler;
        private Packet onHold;
        private Channel channel;
        public volatile boolean deliver;
        private volatile boolean delivered;
        private boolean receivedUpToDate;
        private boolean mustHold = true;
        private final byte typeToIntercept;

        public ReplicationChannelHandler(byte type) {
            this.typeToIntercept = type;
        }

        public void addSubHandler(ReplicationEndpoint handler) {
            this.handler = handler;
        }

        public synchronized void deliver() {
            this.deliver = true;
            if (!this.receivedUpToDate) {
                return;
            }
            if (this.delivered) {
                return;
            }
            if (this.onHold == null) {
                throw new NullPointerException("Don't have the 'sync is done' packet to deliver");
            }
            ChannelWrapper wrapper = new ChannelWrapper(this.channel);
            this.handler.setChannel((Channel)wrapper);
            try {
                this.handler.handlePacket(this.onHold);
                this.delivered = true;
            }
            finally {
                this.handler.setChannel(this.channel);
                this.channel.setHandler((ChannelHandler)this.handler);
                this.onHold = null;
            }
        }

        public void setChannel(Channel channel) {
            this.channel = channel;
        }

        public void setHold(boolean hold) {
            this.mustHold = hold;
        }

        public synchronized void handlePacket(Packet packet) {
            if (this.onHold != null && this.deliver) {
                this.deliver();
            }
            if (this.typeToIntercept == 120) {
                ReplicationStartSyncMessage syncMsg;
                if (packet.getType() == 120 && this.mustHold && (syncMsg = (ReplicationStartSyncMessage)packet).isSynchronizationFinished() && !this.deliver) {
                    this.receivedUpToDate = true;
                    assert (this.onHold == null);
                    this.onHold = packet;
                    ReplicationResponseMessageV2 response = new ReplicationResponseMessageV2(true);
                    this.channel.send((Packet)response);
                    return;
                }
            } else if (this.typeToIntercept == packet.getType()) {
                this.channel.send((Packet)new ReplicationResponseMessage());
                return;
            }
            this.handler.handlePacket(packet);
        }
    }
}

