/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LiveToLiveFailoverTest
extends FailoverTest {
    private InVMNodeManager nodeManager0;
    private InVMNodeManager nodeManager1;
    private ClientSessionFactoryInternal sf2;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager0 = new InVMNodeManager(false);
        this.nodeManager1 = new InVMNodeManager(false);
        TransportConfiguration liveConnector0 = this.getConnectorTransportConfiguration(true, 0);
        TransportConfiguration liveConnector1 = this.getConnectorTransportConfiguration(true, 1);
        this.backupConfig = super.createDefaultInVMConfig(1).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true, 1)).setHAPolicyConfiguration((HAPolicyConfiguration)new ColocatedPolicyConfiguration().setRequestBackup(true).setLiveConfig((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).setBackupConfig((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration().addConnector(liveConnector1.getName())))).addConnectorConfiguration(liveConnector0.getName(), liveConnector0).addConnectorConfiguration(liveConnector1.getName(), liveConnector1).addClusterConfiguration(LiveToLiveFailoverTest.basicClusterConnectionConfig((String)liveConnector1.getName(), (String[])new String[]{liveConnector0.getName()}));
        this.backupServer = this.createColocatedTestableServer(this.backupConfig, (NodeManager)this.nodeManager1, (NodeManager)this.nodeManager0, 1);
        this.liveConfig = super.createDefaultInVMConfig(0).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true, 0)).setHAPolicyConfiguration((HAPolicyConfiguration)new ColocatedPolicyConfiguration().setRequestBackup(true).setBackupRequestRetryInterval(1000L).setLiveConfig((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).setBackupConfig((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration()))).addConnectorConfiguration(liveConnector0.getName(), liveConnector0).addConnectorConfiguration(liveConnector1.getName(), liveConnector1).addClusterConfiguration(LiveToLiveFailoverTest.basicClusterConnectionConfig((String)liveConnector0.getName(), (String[])new String[]{liveConnector1.getName()}));
        this.liveServer = this.createColocatedTestableServer(this.liveConfig, (NodeManager)this.nodeManager0, (NodeManager)this.nodeManager1, 0);
    }

    @Override
    protected void setLiveIdentity() {
        this.liveServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/liveServer0");
    }

    @Override
    protected void setBackupIdentity() {
        this.backupServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/liveServer1");
    }

    @Override
    protected void waitForBackup() {
        Map backupServers0 = this.liveServer.getServer().getClusterManager().getHAManager().getBackupServers();
        Map backupServers1 = this.backupServer.getServer().getClusterManager().getHAManager().getBackupServers();
        long toWait = 10000L;
        long time = System.currentTimeMillis();
        while (backupServers0.size() != 1 || backupServers1.size() != 1) {
            if (System.currentTimeMillis() > time + 10000L) {
                LiveToLiveFailoverTest.fail((String)("backup started? ( live server0 backups = " + backupServers0.size() + " live server1 backups = " + backupServers1.size() + ")"));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LiveToLiveFailoverTest.fail((String)e.getMessage());
            }
        }
        LiveToLiveFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)((ActiveMQServer)backupServers0.values().iterator().next()));
        LiveToLiveFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)((ActiveMQServer)backupServers1.values().iterator().next()));
    }

    @Override
    protected final ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers * 2);
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        LiveToLiveFailoverTest.assertTrue((String)("topology members expected " + topologyMembers), (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        LiveToLiveFailoverTest.closeSessionFactory((ClientSessionFactory)sf);
        sf = (ClientSessionFactoryInternal)locator.createSessionFactory(this.liveServer.getServer().getNodeID().toString());
        this.addSessionFactory((ClientSessionFactory)sf);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(new QueueConfiguration(ADDRESS));
            this.addSessionFactory((ClientSessionFactory)this.sf2);
        }
        return sf;
    }

    protected final ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, TransportConfiguration transportConfiguration, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers * 2);
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory(transportConfiguration);
        this.addSessionFactory((ClientSessionFactory)sf);
        LiveToLiveFailoverTest.assertTrue((String)("topology members expected " + topologyMembers), (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        LiveToLiveFailoverTest.closeSessionFactory((ClientSessionFactory)sf);
        sf = (ClientSessionFactoryInternal)locator.createSessionFactory(this.liveServer.getServer().getNodeID().toString());
        this.addSessionFactory((ClientSessionFactory)sf);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(new QueueConfiguration(ADDRESS));
            this.addSessionFactory((ClientSessionFactory)this.sf2);
        }
        return sf;
    }

    @Override
    protected void createClientSessionFactory() throws Exception {
        if (this.liveServer.getServer().isStarted()) {
            this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
            this.sf = (ClientSessionFactoryInternal)this.locator.createSessionFactory(this.liveServer.getServer().getNodeID().toString());
        } else {
            this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        }
    }

    @Override
    protected void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, this.getConnectorTransportConfiguration(true, 0), 2);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)this.locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            this.addSessionFactory((ClientSessionFactory)this.sf2);
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(new QueueConfiguration(ADDRESS));
        }
    }

    private TransportConfiguration getConnectorTransportConfiguration(boolean live, int server) {
        return TransportConfigurationUtils.getInVMConnector(live, server);
    }

    private TransportConfiguration getAcceptorTransportConfiguration(boolean live, int server) {
        return TransportConfigurationUtils.getInVMAcceptor(live, server);
    }

    @Test
    public void scaleDownDelay() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 1000);
        this.crash(session);
        Queue serverQueue = this.backupServer.getServer().locateQueue(ADDRESS);
        Wait.assertEquals((long)1000L, () -> ((Queue)serverQueue).getMessageCount());
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        session.close();
        this.sf.close();
        Assert.assertEquals((long)0L, (long)this.sf.numSessions());
        Assert.assertEquals((long)0L, (long)this.sf.numConnections());
    }

    @Override
    @Test
    public void testFailoverOnInitialConnection() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        this.crash(new ClientSession[0]);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf);
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 100);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        session.close();
    }

    @Override
    @Test
    public void testCreateNewFactoryAfterFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.crash(true, session);
        session.close();
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                this.createClientSessionFactory();
                break;
            }
            catch (Exception e) {
                Thread.sleep(100L);
            }
        }
        session = this.sendAndConsume((ClientSessionFactory)this.sf, false);
    }

    @Override
    public void testTimeoutOnFailoverTransactionCommitTimeoutCommunication() throws Exception {
    }

    @Override
    @Ignore
    public void testFailBothRestartLive() throws Exception {
    }

    @Override
    @Ignore
    public void testLiveAndBackupBackupComesBackNewFactory() throws Exception {
    }

    @Override
    @Ignore
    public void testLiveAndBackupLiveComesBackNewFactory() {
    }

    @Override
    @Ignore
    public void testTimeoutOnFailoverConsumeBlocked() throws Exception {
    }

    @Override
    @Ignore
    public void testFailoverMultipleSessionsWithConsumers() throws Exception {
    }

    @Override
    @Ignore
    public void testTimeoutOnFailover() throws Exception {
    }

    @Override
    @Ignore
    public void testTimeoutOnFailoverTransactionRollback() throws Exception {
    }

    @Override
    @Ignore
    public void testTimeoutOnFailoverConsume() throws Exception {
    }

    @Override
    @Ignore
    public void testTimeoutOnFailoverTransactionCommit() throws Exception {
    }

    @Override
    @Ignore
    public void testFailBack() throws Exception {
    }

    @Override
    @Ignore
    public void testFailBackLiveRestartsBackupIsGone() throws Exception {
    }

    @Override
    @Ignore
    public void testLiveAndBackupLiveComesBack() throws Exception {
    }

    @Override
    @Ignore
    public void testSimpleFailover() throws Exception {
    }

    @Override
    @Ignore
    public void testFailThenReceiveMoreMessagesAfterFailover2() throws Exception {
    }

    @Override
    @Ignore
    public void testWithoutUsingTheBackup() throws Exception {
    }

    @Override
    @Ignore
    public void testSimpleSendAfterFailoverDurableNonTemporary() throws Exception {
    }

    @Override
    @Ignore
    public void testCommitOccurredUnblockedAndResendNoDuplicates() throws Exception {
    }

    @Override
    @Ignore
    public void testFailLiveTooSoon() throws Exception {
    }
}

