/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

class SimpleMessageListener
implements MessageListener {
    private Session session;
    MessageProducer replyProducer;
    MessageConsumer requestConsumer;
    Connection connection = null;

    SimpleMessageListener() {
    }

    public SimpleMessageListener start() throws Exception {
        Queue requestQueue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61617");
        this.connection = cf.createConnection("guest", "guest");
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        this.replyProducer = this.session.createProducer(null);
        this.requestConsumer = this.session.createConsumer((Destination)requestQueue);
        this.requestConsumer.setMessageListener((MessageListener)this);
        return this;
    }

    public void onMessage(Message request) {
        try {
            Destination replyDestination = request.getJMSReplyTo();
            TextMessage replyMessage = this.session.createTextMessage("A reply message");
            replyMessage.setJMSCorrelationID(request.getJMSMessageID());
            this.replyProducer.send(replyDestination, (Message)replyMessage);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() throws JMSException {
        this.connection.close();
    }
}

