/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProtocolsMessageLoadBalancingTest
extends ClusterTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    private static final int NUMBER_OF_SERVERS = 2;
    private static final SimpleString queueName = SimpleString.toSimpleString((String)"queues.0");
    private static final int NUMBER_OF_MESSAGES = 154;
    @Parameterized.Parameter(value=0)
    public String protocol;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection getParameters() {
        return Arrays.asList({"AMQP"}, {"CORE"}, {"OPENWIRE"});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    private void startServers(MessageLoadBalancingType loadBalancingType) throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
        this.setupCluster(loadBalancingType);
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L).setExpiryAddress(SimpleString.toSimpleString((String)"queues.expiry"));
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.startServers(0);
        this.startServers(1);
        this.createQueue(SimpleString.toSimpleString((String)"queues.expiry"));
        this.createQueue(queueName);
    }

    private void createQueue(SimpleString queueName) throws Exception {
        QueueConfiguration queueConfiguration = new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST);
        this.servers[0].createQueue(queueConfiguration);
        this.servers[1].createQueue(queueConfiguration);
    }

    protected boolean isNetty() {
        return true;
    }

    private ConnectionFactory getJmsConnectionFactory(int node) {
        if (this.protocol.equals("AMQP")) {
            return new JmsConnectionFactory("amqp://localhost:" + (61616 + node));
        }
        if (this.protocol.equals("OPENWIRE")) {
            return new ActiveMQConnectionFactory("tcp://localhost:" + (61616 + node));
        }
        if (this.protocol.equals("CORE")) {
            return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("tcp://localhost:" + (61616 + node));
        }
        Assert.fail((String)("Protocol " + this.protocol + " unkown"));
        return null;
    }

    private void pauseClusteringBridges(ActiveMQServer server) throws Exception {
        for (ClusterConnection clusterConnection : server.getClusterManager().getClusterConnections()) {
            for (MessageFlowRecord record : ((ClusterConnectionImpl)clusterConnection).getRecords().values()) {
                record.getBridge().pause();
            }
        }
    }

    @Test
    public void testLoadBalancing() throws Exception {
        this.startServers(MessageLoadBalancingType.STRICT);
        ConnectionFactory[] factory = new ConnectionFactory[2];
        Connection[] connection = new Connection[2];
        Session[] session = new Session[2];
        MessageConsumer[] consumer = new MessageConsumer[2];
        for (int node = 0; node < 2; ++node) {
            factory[node] = this.getJmsConnectionFactory(node);
            connection[node] = factory[node].createConnection();
            session[node] = connection[node].createSession(false, 1);
            consumer[node] = session[node].createConsumer((Destination)session[node].createQueue(queueName.toString()));
        }
        this.waitForBindings(0, "queues.0", 1, 1, true);
        this.waitForBindings(1, "queues.0", 1, 1, true);
        this.waitForBindings(0, "queues.0", 1, 1, false);
        this.waitForBindings(1, "queues.0", 1, 1, false);
        this.pauseClusteringBridges(this.servers[0]);
        ConnectionFactory cf = this.getJmsConnectionFactory(0);
        Connection cn = cf.createConnection();
        Session sn = cn.createSession(false, 1);
        MessageProducer pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
        for (int i = 0; i < 154; ++i) {
            pd.send((Message)sn.createTextMessage("hello " + i));
        }
        cn.close();
        this.receiveMessages(connection[0], consumer[0], 77, true);
        connection[1].start();
        Assert.assertNull((Object)consumer[1].receiveNoWait());
        connection[1].stop();
        this.servers[0].stop();
        this.clearServer(0);
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1);
        this.servers[0].start();
        this.receiveMessages(connection[1], consumer[1], 77, true);
        for (int node = 0; node < 2; ++node) {
            connection[node].close();
        }
    }

    @Test
    public void testRedistributionStoppedWithNoRemoteConsumers() throws Exception {
        int i;
        this.startServers(MessageLoadBalancingType.ON_DEMAND);
        ConnectionFactory factory = this.getJmsConnectionFactory(1);
        this.waitForBindings(0, "queues.0", 1, 0, true);
        this.waitForBindings(1, "queues.0", 1, 0, true);
        this.waitForBindings(0, "queues.0", 1, 0, false);
        this.waitForBindings(1, "queues.0", 1, 0, false);
        ConnectionFactory cf0 = this.getJmsConnectionFactory(0);
        ConnectionFactory cf1 = this.getJmsConnectionFactory(1);
        Connection cn0 = cf0.createConnection();
        Session sn0 = cn0.createSession(false, 1);
        MessageConsumer c0 = sn0.createConsumer((Destination)sn0.createQueue(queueName.toString()));
        cn0.start();
        Connection cn1 = cf1.createConnection();
        Session sn1 = cn1.createSession(false, 1);
        MessageConsumer c1 = sn1.createConsumer((Destination)sn0.createQueue(queueName.toString()));
        cn1.start();
        MessageProducer pd = sn0.createProducer((Destination)sn0.createQueue(queueName.toString()));
        this.waitForBindings(0, "queues.0", 1, 1, false);
        this.waitForBindings(1, "queues.0", 1, 1, false);
        c0.close();
        for (i = 0; i < 154; ++i) {
            pd.send((Message)sn0.createTextMessage("hello " + i));
        }
        for (i = 0; i < 154; ++i) {
            ProtocolsMessageLoadBalancingTest.assertNotNull((Object)c1.receive(1000L));
        }
        c1.close();
        sn1.close();
        cn1.close();
        for (i = 0; i < 154; ++i) {
            pd.send((Message)sn0.createTextMessage("hello " + i));
        }
        cn0.close();
        ProtocolsMessageLoadBalancingTest.assertEquals((long)154L, (long)this.servers[0].locateQueue(queueName).getMessageCount());
        ProtocolsMessageLoadBalancingTest.assertEquals((long)0L, (long)this.servers[1].locateQueue(queueName).getMessageCount());
    }

    @Test
    public void testExpireRedistributed() throws Exception {
        this.startServers(MessageLoadBalancingType.ON_DEMAND);
        ConnectionFactory factory = this.getJmsConnectionFactory(1);
        this.waitForBindings(0, "queues.0", 1, 0, true);
        this.waitForBindings(1, "queues.0", 1, 0, true);
        this.waitForBindings(0, "queues.0", 1, 0, false);
        this.waitForBindings(1, "queues.0", 1, 0, false);
        ConnectionFactory cf = this.getJmsConnectionFactory(0);
        Connection cn = cf.createConnection();
        Session sn = cn.createSession(false, 1);
        MessageProducer pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
        pd.setTimeToLive(200L);
        for (int i = 0; i < 154; ++i) {
            pd.send((Message)sn.createTextMessage("hello " + i));
        }
        cn.close();
        Thread.sleep(200L);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("queues.expiry"));
        this.receiveMessages(connection, consumer, 154, true);
        connection.close();
    }

    @Test
    public void testRestartConnection() throws Exception {
        this.startServers(MessageLoadBalancingType.STRICT);
        this.instanceLog.debug((Object)("connections " + this.servers[1].getRemotingService().getConnections().size()));
        Wait.assertEquals((int)3, () -> this.servers[1].getRemotingService().getConnections().size());
        Wait.assertEquals((int)3, () -> this.servers[0].getRemotingService().getConnections().size());
        RemotingConnection[] connectionsServer1 = this.servers[1].getRemotingService().getConnections().toArray(new RemotingConnection[3]);
        RemotingConnection[] connectionsServer0 = this.servers[0].getRemotingService().getConnections().toArray(new RemotingConnection[3]);
        ConnectionFactory[] factory = new ConnectionFactory[2];
        Connection[] connection = new Connection[2];
        Session[] session = new Session[2];
        MessageConsumer[] consumer = new MessageConsumer[2];
        for (int node = 0; node < 2; ++node) {
            factory[node] = this.getJmsConnectionFactory(node);
            connection[node] = factory[node].createConnection();
            session[node] = connection[node].createSession(false, 1);
            consumer[node] = session[node].createConsumer((Destination)session[node].createQueue(queueName.toString()));
        }
        this.waitForBindings(0, "queues.0", 1, 1, true);
        this.waitForBindings(1, "queues.0", 1, 1, true);
        this.waitForBindings(0, "queues.0", 1, 1, false);
        this.waitForBindings(1, "queues.0", 1, 1, false);
        for (RemotingConnection remotingConnection : this.servers[1].getRemotingService().getConnections()) {
            remotingConnection.fail(new ActiveMQException("forcing failure"));
        }
        for (RemotingConnection remotingConnection : this.servers[1].getRemotingService().getConnections()) {
            remotingConnection.fail(new ActiveMQException("forcing failure"));
        }
        Thread.sleep(500L);
        for (int node = 0; node < 2; ++node) {
            try {
                connection[node].close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            factory[node] = this.getJmsConnectionFactory(node);
            connection[node] = factory[node].createConnection();
            session[node] = connection[node].createSession(false, 1);
            consumer[node] = session[node].createConsumer((Destination)session[node].createQueue(queueName.toString()));
        }
        this.waitForBindings(0, "queues.0", 1, 1, true);
        this.waitForBindings(1, "queues.0", 1, 1, true);
        this.waitForBindings(0, "queues.0", 1, 1, false);
        this.waitForBindings(1, "queues.0", 1, 1, false);
        this.instanceLog.debug((Object)("connections " + this.servers[1].getRemotingService().getConnections().size()));
        ConnectionFactory cf = this.getJmsConnectionFactory(0);
        Connection cn = cf.createConnection();
        Session sn = cn.createSession(false, 1);
        MessageProducer pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
        for (int i = 0; i < 154; ++i) {
            pd.send((Message)sn.createTextMessage("hello " + i));
        }
        cn.close();
        this.receiveMessages(connection[0], consumer[0], 77, true);
        this.receiveMessages(connection[1], consumer[1], 77, true);
        for (int node = 0; node < 2; ++node) {
            connection[node].close();
        }
    }

    @Test
    public void testRedistributeAfterLoadBalanced() throws Exception {
        this.startServers(MessageLoadBalancingType.ON_DEMAND);
        ConnectionFactory[] factory = new ConnectionFactory[2];
        Connection[] connection = new Connection[2];
        Session[] session = new Session[2];
        MessageConsumer[] consumer = new MessageConsumer[2];
        for (int node = 0; node < 2; ++node) {
            factory[node] = this.getJmsConnectionFactory(node);
            connection[node] = factory[node].createConnection();
            session[node] = connection[node].createSession(false, 1);
            consumer[node] = session[node].createConsumer((Destination)session[node].createQueue(queueName.toString()));
        }
        this.waitForBindings(0, "queues.0", 1, 1, true);
        this.waitForBindings(1, "queues.0", 1, 1, true);
        this.waitForBindings(0, "queues.0", 1, 1, false);
        this.waitForBindings(1, "queues.0", 1, 1, false);
        if (this.protocol.equals("AMQP")) {
            ServerLocator locator = ActiveMQClient.createServerLocator((String)"tcp://localhost:61616");
            locator.setMinLargeMessageSize(1024);
            ClientSessionFactory coreFactory = locator.createSessionFactory();
            ClientSession clientSession = coreFactory.createSession();
            ClientProducer producer = clientSession.createProducer(queueName);
            for (int i = 0; i < 154; ++i) {
                ClientMessage message = clientSession.createMessage((byte)0, true);
                StringBuffer stringbuffer = new StringBuffer();
                stringbuffer.append("hello");
                if (i % 3 == 0) {
                    for (int j = 0; j < 10240; ++j) {
                        stringbuffer.append(" ");
                    }
                }
                message.getBodyBuffer().writeUTF(stringbuffer.toString());
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            coreFactory.close();
        } else {
            ConnectionFactory cf = this.getJmsConnectionFactory(0);
            Connection cn = cf.createConnection();
            Session sn = cn.createSession(false, 1);
            MessageProducer pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
            for (int i = 0; i < 154; ++i) {
                StringBuffer stringbuffer = new StringBuffer();
                stringbuffer.append("hello");
                if (i % 3 == 0) {
                    for (int j = 0; j < 307200; ++j) {
                        stringbuffer.append(" ");
                    }
                }
                pd.send((Message)sn.createTextMessage(stringbuffer.toString()));
            }
            cn.close();
        }
        Wait.assertEquals((long)77L, () -> ((Queue)this.servers[1].locateQueue(queueName)).getMessageCount());
        Wait.assertEquals((long)77L, () -> ((Queue)this.servers[0].locateQueue(queueName)).getMessageCount());
        this.receiveMessages(connection[0], consumer[0], 77, true);
        connection[1].close();
        this.receiveMessages(connection[0], consumer[0], 77, true);
        connection[0].close();
    }

    private void receiveMessages(Connection connection, MessageConsumer messageConsumer, int messageCount, boolean exactCount) throws JMSException {
        connection.start();
        for (int i = 0; i < messageCount; ++i) {
            Message msg = messageConsumer.receive(5000L);
            Assert.assertNotNull((Object)msg);
        }
        if (exactCount) {
            Assert.assertNull((Object)messageConsumer.receiveNoWait());
        }
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new OpenWireProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new OpenWireProtocolManagerFactory());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }

    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = super.createBasicConfig(serverID);
        configuration.setMessageExpiryScanPeriod(100L);
        return configuration;
    }
}

