/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionalSendTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testSendWithCommit() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = session.createProducer(this.addressA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)session.createMessage(false));
        }
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)0L, (long)this.getMessageCount(q));
        session.commit();
        Assert.assertEquals((long)this.getMessageCount(q), (long)numMessages);
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)session.createMessage(false));
        }
        Wait.assertEquals((long)numMessages, () -> ((Queue)q).getMessageCount());
        session.commit();
        Wait.assertEquals((long)(numMessages * 2), () -> ((Queue)q).getMessageCount());
        session.close();
    }

    @Test
    public void testSendWithRollback() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = session.createProducer(this.addressA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)session.createMessage(false));
        }
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)this.getMessageCount(q), (long)0L);
        session.rollback();
        Assert.assertEquals((long)this.getMessageCount(q), (long)0L);
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)session.createMessage(false));
        }
        Wait.assertEquals((long)0L, () -> ((Queue)q).getMessageCount());
        session.commit();
        Wait.assertEquals((long)numMessages, () -> ((Queue)q).getMessageCount());
        session.close();
    }
}

