/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SessionTest
extends ActiveMQTestBase {
    private boolean legacyCreateQueue;
    private final String queueName = "ClientSessionTestQ";
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Parameterized.Parameters(name="legacyCreateQueue={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public SessionTest(boolean legacyCreateQueue) {
        this.legacyCreateQueue = legacyCreateQueue;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    @Test
    public void testFailureListener() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(clientSession);
        clientSession.addFailureListener((SessionFailureListener)listener);
        this.server.stop();
        Assert.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testFailureListenerRemoved() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        try {
            ClientSession clientSession = this.cf.createSession(false, true, true);
            class MyFailureListener
            implements SessionFailureListener {
                boolean called = false;

                MyFailureListener() {
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver) {
                    this.called = true;
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                    this.connectionFailed(me, failedOver);
                }

                public void beforeReconnect(ActiveMQException me) {
                }
            }
            MyFailureListener listener = new MyFailureListener();
            clientSession.addFailureListener((SessionFailureListener)listener);
            Assert.assertTrue((boolean)clientSession.removeFailureListener((SessionFailureListener)listener));
            clientSession.close();
            this.server.stop();
            Assert.assertFalse((boolean)listener.called);
        }
        finally {
            ((ClientSessionFactoryInternal)this.cf).causeExit();
            this.cf.close();
        }
    }

    @Test
    public void testCloseSessionOnDestroyedConnection() throws Exception {
        int cons;
        this.server.stop();
        long ttl = 500L;
        this.server.getConfiguration().setConnectionTTLOverride(ttl);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
        ClientSessionInternal clientSession = (ClientSessionInternal)this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = clientSession.createProducer();
        ClientConsumer consumer = clientSession.createConsumer("ClientSessionTestQ");
        Assert.assertEquals((long)1L, (long)this.server.getRemotingService().getConnections().size());
        RemotingConnection rc = clientSession.getConnection();
        rc.fail((ActiveMQException)new ActiveMQInternalErrorException());
        clientSession.close();
        long start = System.currentTimeMillis();
        while ((cons = this.server.getRemotingService().getConnections().size()) != 0) {
            long now = System.currentTimeMillis();
            if (now - start > 10000L) {
                throw new Exception("Timed out waiting for connections to close");
            }
            Thread.sleep(50L);
        }
    }

    @Test
    public void testBindingQuery() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "q1", false);
            clientSession.createQueue("a1", "q2", false);
            clientSession.createQueue("a2", "q3", false);
            clientSession.createQueue("a2", "q4", false);
            clientSession.createQueue("a2", "q5", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("q1").setAddress("a1").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(new QueueConfiguration("q2").setAddress("a1").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(new QueueConfiguration("q3").setAddress("a2").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(new QueueConfiguration("q4").setAddress("a2").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(new QueueConfiguration("q5").setAddress("a2").setDurable(Boolean.valueOf(false)));
        }
        ClientSession.AddressQuery resp = clientSession.addressQuery(new SimpleString("a"));
        List queues = resp.getQueueNames();
        Assert.assertTrue((boolean)queues.isEmpty());
        resp = clientSession.addressQuery(new SimpleString("a1"));
        queues = resp.getQueueNames();
        Assert.assertEquals((long)queues.size(), (long)2L);
        Assert.assertTrue((boolean)queues.contains(new SimpleString("q1")));
        Assert.assertTrue((boolean)queues.contains(new SimpleString("q2")));
        resp = clientSession.addressQuery(new SimpleString("a2"));
        queues = resp.getQueueNames();
        Assert.assertEquals((long)queues.size(), (long)3L);
        Assert.assertTrue((boolean)queues.contains(new SimpleString("q3")));
        Assert.assertTrue((boolean)queues.contains(new SimpleString("q4")));
        Assert.assertTrue((boolean)queues.contains(new SimpleString("q5")));
        clientSession.close();
    }

    @Test
    public void testQueueQuery() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setAddress("a1").setDurable(Boolean.valueOf(false)));
        }
        clientSession.createConsumer("ClientSessionTestQ");
        clientSession.createConsumer("ClientSessionTestQ");
        ClientProducer cp = clientSession.createProducer("a1");
        cp.send((Message)clientSession.createMessage(true));
        cp.send((Message)clientSession.createMessage(true));
        this.flushQueue();
        ClientSession.QueueQuery resp = clientSession.queueQuery(new SimpleString("ClientSessionTestQ"));
        Assert.assertEquals((Object)new SimpleString("a1"), (Object)resp.getAddress());
        Assert.assertEquals((long)2L, (long)resp.getConsumerCount());
        Assert.assertEquals((long)2L, (long)resp.getMessageCount());
        Assert.assertEquals(null, (Object)resp.getFilterString());
        clientSession.close();
    }

    private void flushQueue() throws Exception {
        Queue queue = this.server.locateQueue(SimpleString.toSimpleString((String)"ClientSessionTestQ"));
        SessionTest.assertNotNull((Object)queue);
        queue.flushExecutor();
    }

    @Test
    public void testQueueQueryWithFilter() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "ClientSessionTestQ", "foo=bar", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setAddress("a1").setFilterString("foo=bar").setDurable(Boolean.valueOf(false)));
        }
        clientSession.createConsumer("ClientSessionTestQ");
        clientSession.createConsumer("ClientSessionTestQ");
        ClientSession.QueueQuery resp = clientSession.queueQuery(new SimpleString("ClientSessionTestQ"));
        Assert.assertEquals((Object)new SimpleString("a1"), (Object)resp.getAddress());
        Assert.assertEquals((long)2L, (long)resp.getConsumerCount());
        Assert.assertEquals((long)0L, (long)resp.getMessageCount());
        Assert.assertEquals((Object)new SimpleString("foo=bar"), (Object)resp.getFilterString());
        clientSession.close();
    }

    @Test
    public void testQueueQueryNoQ() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)));
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientSession.QueueQuery resp = clientSession.queueQuery(new SimpleString("ClientSessionTestQ"));
        Assert.assertFalse((boolean)resp.isExists());
        Assert.assertFalse((boolean)resp.isAutoCreateQueues());
        Assert.assertEquals((Object)"ClientSessionTestQ", (Object)resp.getAddress().toString());
        clientSession.close();
    }

    @Test
    public void testClose() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer p = clientSession.createProducer();
        ClientProducer p1 = clientSession.createProducer("ClientSessionTestQ");
        ClientConsumer c = clientSession.createConsumer("ClientSessionTestQ");
        ClientConsumer c1 = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.close();
        Assert.assertTrue((boolean)clientSession.isClosed());
        Assert.assertTrue((boolean)p.isClosed());
        Assert.assertTrue((boolean)p1.isClosed());
        Assert.assertTrue((boolean)c.isClosed());
        Assert.assertTrue((boolean)c1.isClosed());
    }

    @Test
    public void testCreateMessageNonDurable() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage(false);
        Assert.assertFalse((boolean)clientMessage.isDurable());
        clientSession.close();
    }

    @Test
    public void testCreateMessageDurable() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage(true);
        Assert.assertTrue((boolean)clientMessage.isDurable());
        clientSession.close();
    }

    @Test
    public void testCreateMessageType() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage((byte)99, false);
        Assert.assertEquals((long)99L, (long)clientMessage.getType());
        clientSession.close();
    }

    @Test
    public void testCreateMessageOverrides() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage((byte)88, false, 100L, 300L, (byte)33);
        Assert.assertEquals((long)88L, (long)clientMessage.getType());
        Assert.assertEquals((long)100L, (long)clientMessage.getExpiration());
        Assert.assertEquals((long)300L, (long)clientMessage.getTimestamp());
        Assert.assertEquals((long)33L, (long)clientMessage.getPriority());
        clientSession.close();
    }

    @Test
    public void testGetVersion() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        Assert.assertEquals((long)this.server.getVersion().getIncrementingVersion(), (long)clientSession.getVersion());
        clientSession.close();
    }

    @Test
    public void testStart() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        clientSession.start();
        clientSession.close();
    }

    @Test
    public void testStop() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        clientSession.start();
        clientSession.stop();
        clientSession.close();
    }

    @Test
    public void testCommitWithSend() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, false, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer cp = clientSession.createProducer("ClientSessionTestQ");
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(new SimpleString("ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.commit();
        Assert.assertTrue((boolean)Wait.waitFor(() -> this.getMessageCount(q) == 10, (long)2000L, (long)100L));
        clientSession.close();
    }

    @Test
    public void testRollbackWithSend() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, false, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer cp = clientSession.createProducer("ClientSessionTestQ");
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(new SimpleString("ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.rollback();
        cp.send((Message)clientSession.createMessage(false));
        cp.send((Message)clientSession.createMessage(false));
        clientSession.commit();
        Wait.assertEquals((int)2, () -> this.getMessageCount(q));
        clientSession.close();
    }

    @Test
    public void testCommitWithReceive() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = this.cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer("ClientSessionTestQ");
        ClientSession clientSession = this.cf.createSession(false, true, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(new SimpleString("ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        ClientConsumer cc = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = cc.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        clientSession.commit();
        Assert.assertNull((Object)cc.receiveImmediate());
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.close();
        sendSession.close();
    }

    @Test
    public void testRollbackWithReceive() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = this.cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer("ClientSessionTestQ");
        ClientSession clientSession = this.cf.createSession(false, true, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(new QueueConfiguration("ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(new SimpleString("ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        ClientConsumer cc = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = cc.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        clientSession.close();
        sendSession.close();
    }

    @Test
    public void testGetNodeId() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        String nodeId = ((ClientSessionInternal)clientSession).getNodeId();
        SessionTest.assertNotNull((Object)nodeId);
    }

    @Test
    public void testCreateQueue() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        Queue result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString());
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.toSimpleString((String)"filter"), true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter"));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter"));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.toSimpleString((String)"filter"), true, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.toSimpleString((String)"filter"), true, true, 0, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        SessionTest.assertEquals((long)0L, (long)result.getMaxConsumers());
        SessionTest.assertTrue((boolean)result.isPurgeOnNoConsumers());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true, 0, true);
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        SessionTest.assertEquals((long)0L, (long)result.getMaxConsumers());
        SessionTest.assertTrue((boolean)result.isPurgeOnNoConsumers());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.toSimpleString((String)"filter"), true, true, 0, true, Boolean.valueOf(true), Boolean.valueOf(true));
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        SessionTest.assertEquals((long)0L, (long)result.getMaxConsumers());
        SessionTest.assertTrue((boolean)result.isPurgeOnNoConsumers());
        SessionTest.assertTrue((boolean)result.isExclusive());
        SessionTest.assertTrue((boolean)result.isLastValue());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true, 0, true, Boolean.valueOf(true), Boolean.valueOf(true));
        } else {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
        SessionTest.assertEquals((Object)queueName, (Object)result.getName());
        SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        SessionTest.assertTrue((boolean)result.isDurable());
        SessionTest.assertTrue((boolean)result.isAutoCreated());
        SessionTest.assertEquals((long)0L, (long)result.getMaxConsumers());
        SessionTest.assertTrue((boolean)result.isPurgeOnNoConsumers());
        SessionTest.assertTrue((boolean)result.isExclusive());
        SessionTest.assertTrue((boolean)result.isLastValue());
        SessionTest.assertTrue((boolean)result.isEnabled());
        this.server.destroyQueue(queueName);
        if (!this.legacyCreateQueue) {
            clientSession.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)).setEnabled(Boolean.valueOf(false)));
            result = this.server.locateQueue(queueName);
            SessionTest.assertEquals((Object)addressName, (Object)result.getAddress());
            SessionTest.assertEquals((Object)queueName, (Object)result.getName());
            SessionTest.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
            SessionTest.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
            SessionTest.assertTrue((boolean)result.isDurable());
            SessionTest.assertTrue((boolean)result.isAutoCreated());
            SessionTest.assertEquals((long)0L, (long)result.getMaxConsumers());
            SessionTest.assertTrue((boolean)result.isPurgeOnNoConsumers());
            SessionTest.assertTrue((boolean)result.isExclusive());
            SessionTest.assertTrue((boolean)result.isLastValue());
            SessionTest.assertFalse((boolean)result.isEnabled());
            this.server.destroyQueue(queueName);
        }
    }
}

