/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipleProducersTest
extends JMSTestBase {
    public Connection conn;
    public Queue queueOne = null;
    public Queue queueTwo = null;
    public Session session = null;
    public SimpleString dlq = new SimpleString("DLQ");
    public SimpleString expiryQueue = new SimpleString("ExpiryQueue");
    public SimpleString queueOneName = new SimpleString("queueOne");
    public SimpleString queueTwoName = new SimpleString("queueTwo");
    public QueueControl control = null;
    public long queueOneMsgCount = 0L;
    public long queueTwoMsgCount = 0L;

    @Before
    public void iniTest() throws Exception {
    }

    @Test
    public void wrongQueue() throws Exception {
        this.conn = this.cf.createConnection();
        this.session = this.conn.createSession(false, 1);
        HierarchicalRepository repos = this.server.getAddressSettingsRepository();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        addressSettings.setExpiryAddress(this.dlq);
        addressSettings.setDeadLetterAddress(this.expiryQueue);
        addressSettings.setRedeliveryDelay(0L);
        addressSettings.setMessageCounterHistoryDayLimit(2);
        addressSettings.setDefaultLastValueQueue(false);
        addressSettings.setMaxDeliveryAttempts(10);
        addressSettings.setMaxSizeBytes(0x100000L);
        addressSettings.setPageCacheMaxSize(5);
        addressSettings.setPageSizeBytes(0x200000);
        addressSettings.setRedistributionDelay(-1L);
        addressSettings.setSendToDLAOnNoRoute(false);
        addressSettings.setSlowConsumerCheckPeriod(5L);
        addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        addressSettings.setSlowConsumerThreshold(-1L);
        repos.setDefault((Object)addressSettings);
        this.queueOne = this.createQueue("queueOne");
        this.queueTwo = this.createQueue("queueTwo");
        try {
            while (true) {
                this.sendMessage(this.queueOne, this.session);
            }
        }
        catch (Throwable throwable) {
            int i;
            this.session.close();
            this.conn.close();
            this.session = null;
            this.conn = null;
            this.conn = this.cf.createConnection();
            this.session = this.conn.createSession(false, 1);
            try {
                this.sendMessage(this.queueOne, this.session);
                Assert.fail((String)"Exception expected");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (i = 0; i < 5; ++i) {
                this.sendMessage(this.queueTwo, this.session);
            }
            this.queueTwoMsgCount = this.server.locateQueue(this.queueTwoName).getMessageCount();
            this.control = (QueueControl)this.server.getManagementService().getResource("queue." + this.queueOne.getQueueName());
            this.control.removeMessages(null);
            for (i = 0; i < 5; ++i) {
                this.sendMessage(this.queueOne, this.session);
            }
            this.session.close();
            this.conn.close();
            Wait.waitFor(() -> this.server.locateQueue(this.queueOneName).getMessageCount() == 5L);
            Wait.waitFor(() -> this.server.locateQueue(this.queueTwoName).getMessageCount() == 5L);
            this.queueOneMsgCount = this.server.locateQueue(this.queueOneName).getMessageCount();
            this.queueTwoMsgCount = this.server.locateQueue(this.queueTwoName).getMessageCount();
            Assert.assertEquals((String)"queueTwo message count", (long)5L, (long)this.queueTwoMsgCount);
            Assert.assertEquals((String)"queueOne message count", (long)5L, (long)this.queueOneMsgCount);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Queue queue, Session session) throws Exception {
        try (MessageProducer mp = session.createProducer((Destination)queue);){
            mp.setDisableMessageID(true);
            mp.setDeliveryMode(1);
            mp.setPriority(4);
            mp.setTimeToLive(0L);
            mp.send((Message)session.createTextMessage("This is message for " + queue.getQueueName()));
        }
    }
}

