/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutogroupIdTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");
    private final SimpleString groupTestQ = new SimpleString("testGroupQueue");
    private ActiveMQServer server;
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testGroupIdAutomaticallySet() throws Exception {
        this.locator.setAutoGroup(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(100);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        session.start();
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch((CountDownLatch)latch);
        session.close();
        Assert.assertEquals((long)100L, (long)myMessageHandler.messagesReceived);
        Assert.assertEquals((long)0L, (long)myMessageHandler2.messagesReceived);
    }

    @Test
    public void testGroupIdAutomaticallySetMultipleProducers() throws Exception {
        int i;
        this.locator.setAutoGroup(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        ClientProducer producer2 = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(200);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler3 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        ClientConsumer consumer3 = session.createConsumer(this.groupTestQ);
        consumer3.setMessageHandler((MessageHandler)myMessageHandler3);
        session.start();
        int numMessages = 100;
        for (i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        for (i = 0; i < 100; ++i) {
            producer2.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch((CountDownLatch)latch);
        session.close();
        Assert.assertEquals((long)myMessageHandler.messagesReceived, (long)100L);
        Assert.assertEquals((long)myMessageHandler2.messagesReceived, (long)100L);
        Assert.assertEquals((long)myMessageHandler3.messagesReceived, (long)0L);
    }

    @Test
    public void testGroupIdAutomaticallyNotSet() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(100);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        session.start();
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch((CountDownLatch)latch);
        session.close();
        Assert.assertEquals((long)50L, (long)myMessageHandler.messagesReceived);
        Assert.assertEquals((long)50L, (long)myMessageHandler2.messagesReceived);
    }

    private static class MyMessageHandler
    implements MessageHandler {
        int messagesReceived = 0;
        private final CountDownLatch latch;

        private MyMessageHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onMessage(ClientMessage message) {
            ++this.messagesReceived;
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
            this.latch.countDown();
        }
    }
}

